/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.classfile.AnnotationDefaultAttribute;
import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.AnnotationsAttribute;
import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ConstantValueAttribute;
import aQute.bnd.classfile.ElementValueInfo;
import aQute.bnd.classfile.EnclosingMethodAttribute;
import aQute.bnd.classfile.ExceptionsAttribute;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.InnerClassesAttribute;
import aQute.bnd.classfile.LocalVariableTableAttribute;
import aQute.bnd.classfile.LocalVariableTypeTableAttribute;
import aQute.bnd.classfile.MemberInfo;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.classfile.ModuleMainClassAttribute;
import aQute.bnd.classfile.ModulePackagesAttribute;
import aQute.bnd.classfile.NestHostAttribute;
import aQute.bnd.classfile.NestMembersAttribute;
import aQute.bnd.classfile.ParameterAnnotationInfo;
import aQute.bnd.classfile.ParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.bnd.classfile.StackMapTableAttribute;
import aQute.bnd.classfile.TypeAnnotationInfo;
import aQute.bnd.classfile.TypeAnnotationsAttribute;
import aQute.bnd.classfile.builder.ClassFileBuilder;
import aQute.bnd.classfile.builder.MutableConstantPool;
import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.io.ByteBufferDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ClassChangesImpl;
import org.eclipse.transformer.action.impl.ElementActionImpl;
import org.eclipse.transformer.util.SignatureUtils;
import org.slf4j.Logger;

public class ClassActionImpl
extends ElementActionImpl {
    private static final int DUMP_WIDTH = 16;
    private final List<ActionImpl.StringReplacement> activeReplacements;

    public String relocateClass(String inputPath, String inputClassName, String outputClassName) {
        int nextSlash;
        String resourceInputPath = SignatureUtils.classNameToResourceName(inputClassName);
        String resourceOutputPath = SignatureUtils.classNameToResourceName(outputClassName);
        if (resourceInputPath.equals(inputPath)) {
            return resourceOutputPath;
        }
        int length = inputPath.length();
        int tail = resourceInputPath.length();
        int head = length - tail;
        if (length > tail && inputPath.charAt(head - 1) == '/' && inputPath.regionMatches(head, resourceInputPath, 0, tail)) {
            return inputPath.substring(0, head).concat(resourceOutputPath);
        }
        String prefix = inputPath.startsWith("WEB-INF/classes/") ? "WEB-INF/classes/" : (inputPath.startsWith("META-INF/versions/") ? ((nextSlash = inputPath.indexOf(47, "META-INF/versions/".length())) == -1 ? "META-INF/versions/" : inputPath.substring(0, nextSlash + 1)) : null);
        String outputPath = prefix == null ? resourceOutputPath : prefix.concat(resourceOutputPath);
        this.getLogger().warn("Class location mismatch: Class location [ {} ] does not match class name [ {} ]. Corrected transformed location to [ {} ] using transformed name [ {} ].", new Object[]{inputPath, inputClassName, outputPath, outputClassName});
        return outputPath;
    }

    private void traceDump(ByteData inputData) {
        Logger useLogger = this.getLogger();
        if (!useLogger.isTraceEnabled()) {
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        ByteBuffer buffer = inputData.buffer();
        while (buffer.hasRemaining()) {
            int nextWidth = Math.min(buffer.remaining(), 16);
            String nextLine = this.traceDumpLine(outputBuilder, buffer, nextWidth);
            useLogger.trace(nextLine);
        }
    }

    private String traceDumpLine(StringBuilder builder, ByteBuffer buffer, int width) {
        for (int byteNo = 0; byteNo < width; ++byteNo) {
            byte nextByte = buffer.get();
            builder.append(String.format("%02x ", nextByte));
        }
        String line = builder.toString();
        builder.setLength(0);
        return line;
    }

    public ClassActionImpl(ActionContext context) {
        super(context);
        List<ActionImpl.StringReplacement> useReplacements = this.createActiveReplacements(context.getSignatureRule());
        this.activeReplacements = useReplacements.isEmpty() ? NO_ACTIVE_REPLACEMENTS : useReplacements;
    }

    protected List<ActionImpl.StringReplacement> createActiveReplacements(SignatureRule signatureRule) {
        ArrayList<ActionImpl.StringReplacement> replacements = new ArrayList<ActionImpl.StringReplacement>();
        if (!signatureRule.getDirectPerClassUpdates().isEmpty()) {
            replacements.add(this::directPerClassUpdate);
        }
        if (!signatureRule.getDirectGlobalUpdates().isEmpty()) {
            replacements.add(this::directGlobalUpdate);
        }
        if (!signatureRule.getPackageRenames().isEmpty()) {
            replacements.add(this::descriptorUpdate);
        }
        replacements.add(this::packagesUpdate);
        replacements.add(this::binaryTypeUpdate);
        replacements.add(this::binaryPackagesUpdate);
        return replacements;
    }

    @Override
    protected List<ActionImpl.StringReplacement> getActiveReplacements() {
        return this.activeReplacements;
    }

    @Override
    protected boolean allowMultipleReplacements() {
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.CLASS;
    }

    @Override
    public ClassChangesImpl newChanges() {
        return new ClassChangesImpl();
    }

    @Override
    public ClassChangesImpl getActiveChanges() {
        return (ClassChangesImpl)super.getActiveChanges();
    }

    @Override
    public ClassChangesImpl getLastActiveChanges() {
        return (ClassChangesImpl)super.getLastActiveChanges();
    }

    protected void setClassNames(String inputClassName, String outputClassName) {
        ClassChangesImpl useChanges = this.getActiveChanges();
        useChanges.setInputClassName(inputClassName);
        useChanges.setOutputClassName(outputClassName);
    }

    protected void setSuperClassNames(String inputSuperName, String outputSuperName) {
        ClassChangesImpl useChanges = this.getActiveChanges();
        useChanges.setInputSuperName(inputSuperName);
        useChanges.setOutputSuperName(outputSuperName);
    }

    protected void addModifiedInterface() {
        this.getActiveChanges().addModifiedInterface();
    }

    protected void addModifiedField() {
        this.getActiveChanges().addModifiedField();
    }

    protected void addModifiedMethod() {
        this.getActiveChanges().addModifiedMethod();
    }

    protected void addModifiedAttribute() {
        this.getActiveChanges().addModifiedAttribute();
    }

    protected void setModifiedConstants(int modifiedConstants) {
        this.getActiveChanges().addModifiedConstants(modifiedConstants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData apply(ByteData inputData) throws TransformException {
        Logger useLogger = this.getLogger();
        this.startRecording(inputData);
        try {
            List interfaces;
            String outputName;
            ClassFile inputClass;
            useLogger.debug("Class input: [ {} ]", (Object)inputData);
            this.traceDump(inputData);
            try {
                DataInput inputClassData = ByteBufferDataInput.wrap((ByteBuffer)inputData.buffer());
                inputClass = ClassFile.parseClassFile((DataInput)inputClassData);
            }
            catch (IOException e) {
                throw new TransformException("Failed to parse raw class bytes [ " + inputData.name() + " ]", e);
            }
            this.displayClass(inputData.name(), inputClass);
            ClassFileBuilder classBuilder = new ClassFileBuilder(inputClass);
            String inputClassName = classBuilder.this_class();
            String outputClassName = this.transformBinaryType(inputClassName);
            if (outputClassName != null) {
                classBuilder.this_class(outputClassName);
                outputName = this.relocateClass(inputData.name(), inputClassName, outputClassName);
                useLogger.debug("Class name [ {} ] -> [ {} ]", (Object)inputData.name(), (Object)outputName);
            } else {
                outputClassName = inputClassName;
                outputName = inputData.name();
            }
            this.setClassNames(inputClassName, outputClassName);
            this.setResourceNames(inputData.name(), outputName);
            useLogger.trace("{}", (Object)classBuilder);
            String inputSuperName = classBuilder.super_class();
            if (inputSuperName != null) {
                String outputSuperName = this.transformBinaryType(inputSuperName);
                if (outputSuperName != null) {
                    classBuilder.super_class(outputSuperName);
                } else {
                    outputSuperName = inputSuperName;
                }
                this.setSuperClassNames(inputSuperName, outputSuperName);
                if (!outputSuperName.equals("java/lang/Object")) {
                    useLogger.trace("  extends {}", (Object)outputSuperName);
                }
            }
            if (!(interfaces = classBuilder.interfaces()).isEmpty()) {
                ListIterator<String> interfaceNames = interfaces.listIterator();
                while (interfaceNames.hasNext()) {
                    String inputInterfaceName = (String)interfaceNames.next();
                    String outputInterfaceName = this.transformBinaryType(inputInterfaceName);
                    if (outputInterfaceName == null) continue;
                    interfaceNames.set(outputInterfaceName);
                    this.addModifiedInterface();
                    useLogger.debug("Interface {} -> {}", (Object)inputInterfaceName, (Object)outputInterfaceName);
                }
                useLogger.trace("  implements {}", (Object)interfaces);
            }
            ListIterator<FieldInfo> fields = classBuilder.fields().listIterator();
            while (fields.hasNext()) {
                FieldInfo inputField = (FieldInfo)fields.next();
                FieldInfo outputField = this.transform(inputField, FieldInfo::new, SignatureRule.SignatureType.FIELD, inputData.name());
                if (outputField == null) continue;
                fields.set(outputField);
                this.addModifiedField();
                useLogger.debug("Field  {} -> {}", (Object)inputField, (Object)outputField);
            }
            ListIterator<MethodInfo> methods = classBuilder.methods().listIterator();
            while (methods.hasNext()) {
                MethodInfo inputMethod = (MethodInfo)methods.next();
                MethodInfo outputMethod = this.transform(inputMethod, MethodInfo::new, SignatureRule.SignatureType.METHOD, inputData.name());
                if (outputMethod == null) continue;
                methods.set(outputMethod);
                this.addModifiedMethod();
                useLogger.debug("Method {} -> {}", (Object)inputMethod, (Object)outputMethod);
            }
            ListIterator<Attribute> attributes = classBuilder.attributes().listIterator();
            while (attributes.hasNext()) {
                Attribute inputAttribute = (Attribute)attributes.next();
                Attribute outputAttribute = this.transform(inputAttribute, SignatureRule.SignatureType.CLASS, inputData.name());
                if (outputAttribute == null) continue;
                attributes.set(outputAttribute);
                this.addModifiedAttribute();
                useLogger.debug("Attribute {} -> {}", (Object)inputAttribute, (Object)outputAttribute);
            }
            MutableConstantPool constants = classBuilder.constant_pool();
            useLogger.debug("  Constant pool: {}", (Object)constants.size());
            int modifiedConstants = this.transform(constants, inputData.name());
            if (modifiedConstants > 0) {
                this.setModifiedConstants(modifiedConstants);
            }
            if (!this.isChanged()) {
                ByteData byteData = inputData;
                return byteData;
            }
            if (!this.isContentChanged()) {
                ByteData outputData = inputData.copy(outputName);
                useLogger.debug("  Class bytes: [ {} ]", (Object)outputData);
                ByteData byteData = outputData;
                return byteData;
            }
            ClassFile outputClass = classBuilder.build();
            Charset charset = inputData.charset();
            ByteBufferDataOutput outputClassData = new ByteBufferDataOutput(inputData.length() + 4096);
            try {
                outputClass.write((DataOutput)outputClassData);
            }
            catch (IOException e) {
                throw new TransformException("Failed to write transformed class bytes", e);
            }
            ByteDataImpl outputData = new ByteDataImpl(outputName, outputClassData.toByteBuffer(), charset);
            useLogger.debug("  Class output: [ {} ]", (Object)outputData);
            ByteDataImpl byteDataImpl = outputData;
            return byteDataImpl;
        }
        finally {
            this.stopRecording(inputData);
        }
    }

    private void displayClass(String inputName, ClassFile inputClass) {
        Logger useLogger = this.getLogger();
        useLogger.debug("Class [ {} ] as [ {} ] ", (Object)inputName, (Object)inputClass.this_class);
        if (!useLogger.isTraceEnabled()) {
            return;
        }
        useLogger.trace("  Super [ {} ]", (Object)inputClass.super_class);
        if (inputClass.interfaces != null) {
            useLogger.trace("  Interfaces [ {} ]", (Object)inputClass.interfaces.length);
            for (String string : inputClass.interfaces) {
                useLogger.trace("    [ {} ]", (Object)string);
            }
        }
        if (inputClass.fields != null) {
            useLogger.trace("  Fields [ {} ]", (Object)inputClass.fields.length);
            for (String string : inputClass.fields) {
                useLogger.trace("    [ {} ] [ {} ]", (Object)((FieldInfo)string).name, (Object)((FieldInfo)string).descriptor);
            }
        }
        if (inputClass.methods != null) {
            useLogger.trace("  Methods [ {} ]", (Object)inputClass.methods.length);
            for (String string : inputClass.methods) {
                useLogger.trace("    [ {} ] [ {} ]", (Object)((MethodInfo)string).name, (Object)((MethodInfo)string).descriptor);
            }
        }
    }

    private <MEMBERINFO extends MemberInfo> MEMBERINFO transform(MEMBERINFO member, MemberInfo.Constructor<MEMBERINFO> constructor, SignatureRule.SignatureType signatureType, String inputName) {
        String inputDescriptor = member.descriptor;
        String outputDescriptor = this.transformDescriptor(inputDescriptor);
        if (outputDescriptor != null) {
            this.getLogger().debug("Member {}.{} > {}", new Object[]{member.name, member.descriptor, outputDescriptor});
        }
        Attribute[] inputAttributes = member.attributes;
        Attribute[] outputAttributes = this.transform(inputAttributes, signatureType, inputName);
        if (outputDescriptor == null && outputAttributes == null) {
            return null;
        }
        return (MEMBERINFO)constructor.init(member.access, member.name, outputDescriptor == null ? inputDescriptor : outputDescriptor, outputAttributes == null ? inputAttributes : outputAttributes);
    }

    private Attribute[] transform(Attribute[] inputAttributes, SignatureRule.SignatureType signatureType, String inputName) {
        Logger useLogger = this.getLogger();
        Attribute[] outputAttributes = null;
        for (int attributeNo = 0; attributeNo < inputAttributes.length; ++attributeNo) {
            Attribute inputAttribute = inputAttributes[attributeNo];
            Attribute outputAttribute = this.transform(inputAttribute, signatureType, inputName);
            if (outputAttribute == null) continue;
            if (outputAttributes == null) {
                outputAttributes = (Attribute[])inputAttributes.clone();
            }
            outputAttributes[attributeNo] = outputAttribute;
            useLogger.debug("Attribute [ {} ] [ {} ] -> [ {} ]", new Object[]{attributeNo, inputAttribute, outputAttribute});
        }
        return outputAttributes;
    }

    private Attribute transform(Attribute attr, SignatureRule.SignatureType signatureType, String inputName) {
        Logger useLogger = this.getLogger();
        switch (attr.name()) {
            case "Signature": {
                SignatureAttribute inputAttribute = (SignatureAttribute)attr;
                String outputSignature = this.transformSignature(inputAttribute.signature, signatureType);
                return outputSignature == null ? null : new SignatureAttribute(outputSignature);
            }
            case "Exceptions": {
                ExceptionsAttribute inputAttribute = (ExceptionsAttribute)attr;
                String[] inputExceptions = inputAttribute.exceptions;
                String[] outputExceptions = null;
                for (int exNo = 0; exNo < inputExceptions.length; ++exNo) {
                    String exception = this.transformBinaryType(inputExceptions[exNo]);
                    if (exception == null) continue;
                    if (outputExceptions == null) {
                        outputExceptions = (String[])inputExceptions.clone();
                    }
                    outputExceptions[exNo] = exception;
                }
                return outputExceptions == null ? null : new ExceptionsAttribute(outputExceptions);
            }
            case "Code": {
                CodeAttribute attribute = (CodeAttribute)attr;
                CodeAttribute.ExceptionHandler[] inputHandlers = attribute.exception_table;
                CodeAttribute.ExceptionHandler[] outputHandlers = null;
                for (int handlerNo = 0; handlerNo < inputHandlers.length; ++handlerNo) {
                    String outputCatchType;
                    CodeAttribute.ExceptionHandler inputHandler = inputHandlers[handlerNo];
                    String inputCatchType = inputHandler.catch_type;
                    if (inputCatchType == null || (outputCatchType = this.transformBinaryType(inputCatchType)) == null) continue;
                    if (outputHandlers == null) {
                        outputHandlers = (CodeAttribute.ExceptionHandler[])inputHandlers.clone();
                    }
                    outputHandlers[handlerNo] = new CodeAttribute.ExceptionHandler(inputHandler.start_pc, inputHandler.end_pc, inputHandler.handler_pc, outputCatchType);
                }
                Attribute[] inputAttributes = attribute.attributes;
                Attribute[] outputAttributes = this.transform(inputAttributes, SignatureRule.SignatureType.METHOD, inputName);
                if (outputHandlers == null && outputAttributes == null) {
                    return null;
                }
                return new CodeAttribute(attribute.max_stack, attribute.max_locals, attribute.code, outputHandlers == null ? inputHandlers : outputHandlers, outputAttributes == null ? inputAttributes : outputAttributes);
            }
            case "EnclosingMethod": {
                String outputDescriptor;
                EnclosingMethodAttribute attribute = (EnclosingMethodAttribute)attr;
                String methodName = attribute.method_name;
                String inputClassName = attribute.class_name;
                String outputClassName = this.transformBinaryType(inputClassName);
                String inputDescriptor = attribute.method_descriptor;
                String string = outputDescriptor = inputDescriptor == null ? null : this.transformDescriptor(inputDescriptor);
                if (outputClassName == null && outputDescriptor == null) {
                    useLogger.trace("Enclosing method [ {} ] Class [ {} ] Descriptor [ {} ]", new Object[]{methodName, inputClassName, inputDescriptor});
                    return null;
                }
                if (outputClassName != null) {
                    useLogger.debug("Enclosing method [ {} ] Class [ {} ] -> [ {} ]", new Object[]{methodName, inputClassName, outputClassName});
                } else {
                    outputClassName = inputClassName;
                }
                if (outputDescriptor != null) {
                    useLogger.debug("Enclosing method [ {} ] Descriptor [ {} ] -> [ {} ]", new Object[]{methodName, inputDescriptor, outputDescriptor});
                } else {
                    outputDescriptor = inputDescriptor;
                }
                return new EnclosingMethodAttribute(outputClassName, methodName, outputDescriptor);
            }
            case "StackMapTable": {
                StackMapTableAttribute inputAttribute = (StackMapTableAttribute)attr;
                StackMapTableAttribute.StackMapFrame[] inputFrames = inputAttribute.entries;
                StackMapTableAttribute.StackMapFrame[] outputFrames = null;
                block54: for (int frameNo = 0; frameNo < inputFrames.length; ++frameNo) {
                    StackMapTableAttribute.StackMapFrame inputFrame = inputFrames[frameNo];
                    switch (inputFrame.type()) {
                        case 127: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.SameLocals1StackItemFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo stack = this.transform(frame.stack);
                            if (stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.SameLocals1StackItemFrame(frame.tag, stack);
                            continue block54;
                        }
                        case 247: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.SameLocals1StackItemFrameExtended)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo stack = this.transform(frame.stack);
                            if (stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.SameLocals1StackItemFrameExtended(frame.tag, frame.delta, stack);
                            continue block54;
                        }
                        case 254: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.AppendFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo[] locals = this.transform(frame.locals);
                            if (locals == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.AppendFrame(frame.tag, frame.delta, locals);
                            continue block54;
                        }
                        case 255: {
                            StackMapTableAttribute.SameLocals1StackItemFrame frame = (StackMapTableAttribute.FullFrame)inputFrame;
                            StackMapTableAttribute.VerificationTypeInfo[] locals = this.transform(frame.locals);
                            StackMapTableAttribute.VerificationTypeInfo[] stack = this.transform(frame.stack);
                            if (locals == null && stack == null) continue block54;
                            if (outputFrames == null) {
                                outputFrames = (StackMapTableAttribute.StackMapFrame[])inputFrames.clone();
                            }
                            outputFrames[frameNo] = new StackMapTableAttribute.FullFrame(frame.tag, frame.delta, locals == null ? frame.locals : locals, stack == null ? frame.stack : stack);
                            continue block54;
                        }
                    }
                }
                if (outputFrames == null) {
                    return null;
                }
                return new StackMapTableAttribute(outputFrames);
            }
            case "InnerClasses": {
                InnerClassesAttribute inputAttribute = (InnerClassesAttribute)attr;
                InnerClassesAttribute.InnerClass[] inputClasses = inputAttribute.classes;
                InnerClassesAttribute.InnerClass[] outputClasses = null;
                for (int classNo = 0; classNo < inputClasses.length; ++classNo) {
                    String outputOuterClass;
                    InnerClassesAttribute.InnerClass inputClass = inputClasses[classNo];
                    String inputInnerClass = inputClass.inner_class;
                    String outputInnerClass = inputInnerClass == null ? null : this.transformBinaryType(inputInnerClass);
                    String inputOuterClass = inputClass.outer_class;
                    String string = outputOuterClass = inputOuterClass == null ? null : this.transformBinaryType(inputOuterClass);
                    if (outputInnerClass == null && outputOuterClass == null) continue;
                    if (outputInnerClass != null) {
                        useLogger.debug("Inner class attribute [ {} ] Inner [ {} ] -> [ {} ]", new Object[]{classNo, inputInnerClass, outputInnerClass});
                    } else {
                        outputInnerClass = inputInnerClass;
                    }
                    if (outputOuterClass != null) {
                        useLogger.debug("Inner class attribute [ {} ] Outer [ {} ] -> [ {} ]", new Object[]{classNo, inputOuterClass, outputOuterClass});
                    } else {
                        outputOuterClass = inputOuterClass;
                    }
                    if (outputClasses == null) {
                        outputClasses = (InnerClassesAttribute.InnerClass[])inputClasses.clone();
                    }
                    outputClasses[classNo] = new InnerClassesAttribute.InnerClass(outputInnerClass, outputOuterClass, inputClass.inner_name, inputClass.inner_access);
                }
                if (outputClasses == null) {
                    return null;
                }
                return new InnerClassesAttribute(outputClasses);
            }
            case "LocalVariableTable": {
                LocalVariableTableAttribute inputAttribute = (LocalVariableTableAttribute)attr;
                LocalVariableTableAttribute.LocalVariable[] inputVariables = inputAttribute.local_variable_table;
                LocalVariableTableAttribute.LocalVariable[] outputVariables = null;
                for (int varNo = 0; varNo < inputVariables.length; ++varNo) {
                    LocalVariableTableAttribute.LocalVariable inputVariable = inputVariables[varNo];
                    String outputDescriptor = this.transformDescriptor(inputVariable.descriptor);
                    if (outputDescriptor == null) continue;
                    if (outputVariables == null) {
                        outputVariables = (LocalVariableTableAttribute.LocalVariable[])inputVariables.clone();
                    }
                    outputVariables[varNo] = new LocalVariableTableAttribute.LocalVariable(inputVariable.start_pc, inputVariable.length, inputVariable.name, outputDescriptor, inputVariable.index);
                }
                if (outputVariables == null) {
                    return null;
                }
                return new LocalVariableTableAttribute(outputVariables);
            }
            case "LocalVariableTypeTable": {
                LocalVariableTypeTableAttribute inputAttribute = (LocalVariableTypeTableAttribute)attr;
                LocalVariableTypeTableAttribute.LocalVariableType[] inputTypes = inputAttribute.local_variable_type_table;
                LocalVariableTypeTableAttribute.LocalVariableType[] outputTypes = null;
                for (int varNo = 0; varNo < inputTypes.length; ++varNo) {
                    LocalVariableTypeTableAttribute.LocalVariableType inputType = inputTypes[varNo];
                    String outputSignature = this.transformSignature(inputType.signature, SignatureRule.SignatureType.FIELD);
                    if (outputSignature == null) continue;
                    if (outputTypes == null) {
                        outputTypes = (LocalVariableTypeTableAttribute.LocalVariableType[])inputTypes.clone();
                    }
                    outputTypes[varNo] = new LocalVariableTypeTableAttribute.LocalVariableType(inputType.start_pc, inputType.length, inputType.name, outputSignature, inputType.index);
                }
                if (outputTypes == null) {
                    return null;
                }
                return new LocalVariableTypeTableAttribute(outputTypes);
            }
            case "RuntimeVisibleAnnotations": {
                RuntimeVisibleAnnotationsAttribute inputAttribute = (RuntimeVisibleAnnotationsAttribute)attr;
                RuntimeVisibleAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleAnnotations": {
                RuntimeInvisibleAnnotationsAttribute inputAttribute = (RuntimeInvisibleAnnotationsAttribute)attr;
                RuntimeInvisibleAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeVisibleParameterAnnotations": {
                RuntimeVisibleParameterAnnotationsAttribute inputAttribute = (RuntimeVisibleParameterAnnotationsAttribute)attr;
                RuntimeVisibleParameterAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleParameterAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleParameterAnnotations": {
                RuntimeInvisibleParameterAnnotationsAttribute inputAttribute = (RuntimeInvisibleParameterAnnotationsAttribute)attr;
                RuntimeInvisibleParameterAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleParameterAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeVisibleTypeAnnotations": {
                RuntimeVisibleTypeAnnotationsAttribute inputAttribute = (RuntimeVisibleTypeAnnotationsAttribute)attr;
                RuntimeVisibleTypeAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeVisibleTypeAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "RuntimeInvisibleTypeAnnotations": {
                RuntimeInvisibleTypeAnnotationsAttribute inputAttribute = (RuntimeInvisibleTypeAnnotationsAttribute)attr;
                RuntimeInvisibleTypeAnnotationsAttribute outputAttribute = this.transform(inputAttribute, RuntimeInvisibleTypeAnnotationsAttribute::new, inputName);
                return outputAttribute;
            }
            case "AnnotationDefault": {
                AnnotationDefaultAttribute inputAttribute = (AnnotationDefaultAttribute)attr;
                Object outputValue = this.transformElementValue(inputAttribute.value, inputName, "", "");
                return outputValue == null ? null : new AnnotationDefaultAttribute(outputValue);
            }
            case "Module": {
                ModuleAttribute inputAttribute = (ModuleAttribute)attr;
                ModuleAttribute.Export[] inputExports = inputAttribute.exports;
                ModuleAttribute.Export[] outputExports = null;
                for (int i = 0; i < inputExports.length; ++i) {
                    ModuleAttribute.Export inputExport = inputExports[i];
                    String outputExport = this.replaceBinaryPackage(inputExport.exports);
                    if (outputExport == null) continue;
                    if (outputExports == null) {
                        outputExports = (ModuleAttribute.Export[])inputExports.clone();
                    }
                    outputExports[i] = new ModuleAttribute.Export(outputExport, inputExport.exports_flags, inputExport.exports_to);
                }
                ModuleAttribute.Open[] inputOpens = inputAttribute.opens;
                ModuleAttribute.Open[] outputOpens = null;
                for (int i = 0; i < inputOpens.length; ++i) {
                    ModuleAttribute.Open inputOpen = inputOpens[i];
                    String outputOpen = this.replaceBinaryPackage(inputOpen.opens);
                    if (outputOpen == null) continue;
                    if (outputOpens == null) {
                        outputOpens = (ModuleAttribute.Open[])inputOpens.clone();
                    }
                    outputOpens[i] = new ModuleAttribute.Open(outputOpen, inputOpen.opens_flags, inputOpen.opens_to);
                }
                String[] inputUses = inputAttribute.uses;
                String[] outputUses = null;
                for (int i = 0; i < inputUses.length; ++i) {
                    String outputUse = this.transformBinaryType(inputUses[i]);
                    if (outputUse == null) continue;
                    if (outputUses == null) {
                        outputUses = (String[])inputUses.clone();
                    }
                    outputUses[i] = outputUse;
                }
                ModuleAttribute.Provide[] inputProvides = inputAttribute.provides;
                ModuleAttribute.Provide[] outputProvides = null;
                for (int i = 0; i < inputProvides.length; ++i) {
                    ModuleAttribute.Provide inputProvide = inputProvides[i];
                    String outputProvide = this.transformBinaryType(inputProvide.provides);
                    String[] inputProvideWiths = inputProvide.provides_with;
                    String[] outputProvideWiths = null;
                    for (int j = 0; j < inputProvideWiths.length; ++j) {
                        String outputProvideWith = this.transformBinaryType(inputProvideWiths[j]);
                        if (outputProvideWith == null) continue;
                        if (outputProvideWiths == null) {
                            outputProvideWiths = (String[])inputProvideWiths.clone();
                        }
                        outputProvideWiths[j] = outputProvideWith;
                    }
                    if (outputProvide == null && outputProvideWiths == null) continue;
                    if (outputProvide == null) {
                        outputProvide = inputProvide.provides;
                    }
                    if (outputProvideWiths == null) {
                        outputProvideWiths = inputProvideWiths;
                    }
                    if (outputProvides == null) {
                        outputProvides = (ModuleAttribute.Provide[])inputProvides.clone();
                    }
                    outputProvides[i] = new ModuleAttribute.Provide(outputProvide, outputProvideWiths);
                }
                if (outputExports == null && outputOpens == null && outputUses == null && outputProvides == null) {
                    return null;
                }
                if (outputExports == null) {
                    outputExports = inputExports;
                }
                if (outputOpens == null) {
                    outputOpens = inputOpens;
                }
                if (outputUses == null) {
                    outputUses = inputUses;
                }
                if (outputProvides == null) {
                    outputProvides = inputProvides;
                }
                return new ModuleAttribute(inputAttribute.module_name, inputAttribute.module_flags, inputAttribute.module_version, inputAttribute.requires, outputExports, outputOpens, outputUses, outputProvides);
            }
            case "ModuleMainClass": {
                ModuleMainClassAttribute inputAttribute = (ModuleMainClassAttribute)attr;
                String inputMainClass = inputAttribute.main_class;
                String outputMainClass = this.transformBinaryType(inputMainClass);
                return outputMainClass == null ? null : new ModuleMainClassAttribute(outputMainClass);
            }
            case "ModulePackages": {
                ModulePackagesAttribute inputAttribute = (ModulePackagesAttribute)attr;
                String[] inputPackages = inputAttribute.packages;
                String[] outputPackages = null;
                for (int i = 0; i < inputPackages.length; ++i) {
                    String outputPackage = this.replaceBinaryPackage(inputPackages[i]);
                    if (outputPackage == null) continue;
                    if (outputPackages == null) {
                        outputPackages = (String[])inputPackages.clone();
                    }
                    outputPackages[i] = outputPackage;
                }
                return outputPackages == null ? null : new ModulePackagesAttribute(outputPackages);
            }
            case "NestHost": {
                NestHostAttribute inputAttribute = (NestHostAttribute)attr;
                String inputHostClass = inputAttribute.host_class;
                String outputHostClass = this.transformBinaryType(inputHostClass);
                return outputHostClass == null ? null : new NestHostAttribute(outputHostClass);
            }
            case "NestMembers": {
                NestMembersAttribute inputAttribute = (NestMembersAttribute)attr;
                String[] inputClasses = inputAttribute.classes;
                String[] outputClasses = null;
                for (int i = 0; i < inputClasses.length; ++i) {
                    String outputClass = this.transformBinaryType(inputClasses[i]);
                    if (outputClass == null) continue;
                    if (outputClasses == null) {
                        outputClasses = (String[])inputClasses.clone();
                    }
                    outputClasses[i] = outputClass;
                }
                return outputClasses == null ? null : new NestMembersAttribute(outputClasses);
            }
            case "ConstantValue": {
                ConstantValueAttribute inputAttribute = (ConstantValueAttribute)attr;
                Object inputValue = inputAttribute.value;
                Object outputValue = this.transformConstantValue(inputValue, inputName);
                return outputValue == null ? null : new ConstantValueAttribute(outputValue);
            }
        }
        return null;
    }

    private Object transformConstantValue(Object inputValue, String inputName) {
        if (inputValue instanceof String) {
            return this.transformString(inputName, "ConstantValue", (String)inputValue);
        }
        this.getLogger().trace("    Non-String ConstantValue: {} (unchanged)", inputValue);
        return null;
    }

    private String transformString(String inputName, String inputCase, String initialValue) {
        return this.updateString(inputName, inputCase, initialValue);
    }

    private <ANNOTATIONSATTRIBUTE extends AnnotationsAttribute> ANNOTATIONSATTRIBUTE transform(ANNOTATIONSATTRIBUTE inputAttribute, AnnotationsAttribute.Constructor<ANNOTATIONSATTRIBUTE> constructor, String inputName) {
        AnnotationInfo[] outputAnnotations = this.transform(inputAttribute.annotations, inputName);
        return (ANNOTATIONSATTRIBUTE)(outputAnnotations == null ? null : constructor.init(outputAnnotations));
    }

    private AnnotationInfo[] transform(AnnotationInfo[] inputAnnotations, String inputName) {
        AnnotationInfo[] outputAnnotations = null;
        for (int annoNo = 0; annoNo < inputAnnotations.length; ++annoNo) {
            AnnotationInfo inputAnnotation = inputAnnotations[annoNo];
            AnnotationInfo outputAnnotation = this.transform(inputAnnotation, AnnotationInfo::new, inputName);
            if (outputAnnotation == null) continue;
            if (outputAnnotations == null) {
                outputAnnotations = (AnnotationInfo[])inputAnnotations.clone();
            }
            outputAnnotations[annoNo] = outputAnnotation;
        }
        return outputAnnotations;
    }

    private <PARAMETERANNOTATIONSATTRIBUTE extends ParameterAnnotationsAttribute> PARAMETERANNOTATIONSATTRIBUTE transform(PARAMETERANNOTATIONSATTRIBUTE attribute, ParameterAnnotationsAttribute.Constructor<PARAMETERANNOTATIONSATTRIBUTE> constructor, String inputName) {
        ParameterAnnotationInfo[] outputParmAnnotations = this.transform(attribute.parameter_annotations, inputName);
        if (outputParmAnnotations == null) {
            return null;
        }
        return (PARAMETERANNOTATIONSATTRIBUTE)constructor.init(outputParmAnnotations);
    }

    private ParameterAnnotationInfo[] transform(ParameterAnnotationInfo[] inputParmAnnotations, String inputName) {
        ParameterAnnotationInfo[] outputParmAnnotations = null;
        for (int parmNo = 0; parmNo < inputParmAnnotations.length; ++parmNo) {
            ParameterAnnotationInfo inputParmAnnotation = inputParmAnnotations[parmNo];
            AnnotationInfo[] outputAnnotations = this.transform(inputParmAnnotation.annotations, inputName);
            if (outputAnnotations == null) continue;
            if (outputParmAnnotations == null) {
                outputParmAnnotations = (ParameterAnnotationInfo[])inputParmAnnotations.clone();
            }
            outputParmAnnotations[parmNo] = new ParameterAnnotationInfo(inputParmAnnotation.parameter, outputAnnotations);
        }
        return outputParmAnnotations;
    }

    private <TYPEANNOTATIONSATTRIBUTE extends TypeAnnotationsAttribute> TYPEANNOTATIONSATTRIBUTE transform(TYPEANNOTATIONSATTRIBUTE inputAttribute, TypeAnnotationsAttribute.Constructor<TYPEANNOTATIONSATTRIBUTE> constructor, String inputName) {
        TypeAnnotationInfo[] outputAnnotations = this.transform(inputAttribute.type_annotations, inputName);
        if (outputAnnotations == null) {
            return null;
        }
        return (TYPEANNOTATIONSATTRIBUTE)constructor.init(outputAnnotations);
    }

    private TypeAnnotationInfo[] transform(TypeAnnotationInfo[] inputAnnotations, String inputName) {
        TypeAnnotationInfo[] outputAnnotations = null;
        for (int annoNo = 0; annoNo < inputAnnotations.length; ++annoNo) {
            TypeAnnotationInfo inputAnnotation = inputAnnotations[annoNo];
            TypeAnnotationInfo outputAnnotation = this.transform(inputAnnotation, (type, values) -> new TypeAnnotationInfo(inputAnnotation.target_type, inputAnnotation.target_info, inputAnnotation.target_index, inputAnnotation.type_path, type, values), inputName);
            if (outputAnnotation == null) continue;
            if (outputAnnotations == null) {
                outputAnnotations = (TypeAnnotationInfo[])inputAnnotations.clone();
            }
            outputAnnotations[annoNo] = outputAnnotation;
        }
        return outputAnnotations;
    }

    private <ANNOTATIONINFO extends AnnotationInfo> ANNOTATIONINFO transform(ANNOTATIONINFO inputAnnotation, AnnotationInfo.Constructor<ANNOTATIONINFO> constructor, String inputName) {
        String inputType = inputAnnotation.type;
        String outputType = this.transformDescriptor(inputType);
        ElementValueInfo[] inputValues = inputAnnotation.values;
        ElementValueInfo[] outputValues = this.transform(inputValues, inputName, inputType);
        if (outputType == null && outputValues == null) {
            return null;
        }
        return (ANNOTATIONINFO)constructor.init(outputType == null ? inputType : outputType, outputValues == null ? inputValues : outputValues);
    }

    private ElementValueInfo[] transform(ElementValueInfo[] inputElementValues, String inputName, String annotationType) {
        ElementValueInfo[] outputElementValues = null;
        for (int valueNo = 0; valueNo < inputElementValues.length; ++valueNo) {
            ElementValueInfo inputElementValue = inputElementValues[valueNo];
            Object outputValue = this.transformElementValue(inputElementValue.value, inputName, annotationType, inputElementValue.name);
            if (outputValue == null) continue;
            if (outputElementValues == null) {
                outputElementValues = (ElementValueInfo[])inputElementValues.clone();
            }
            outputElementValues[valueNo] = new ElementValueInfo(inputElementValue.name, outputValue);
        }
        return outputElementValues;
    }

    private Object transformElementValue(Object inputValue, String inputName, String annotationType, String elementName) {
        if (inputValue instanceof ElementValueInfo.EnumConst) {
            ElementValueInfo.EnumConst enumValue = (ElementValueInfo.EnumConst)inputValue;
            String inputType = enumValue.type;
            String outputType = this.transformDescriptor(inputType);
            if (outputType == null) {
                return null;
            }
            return new ElementValueInfo.EnumConst(outputType, enumValue.name);
        }
        if (inputValue instanceof ElementValueInfo.ResultConst) {
            ElementValueInfo.ResultConst resultValue = (ElementValueInfo.ResultConst)inputValue;
            String inputDescriptor = resultValue.descriptor;
            String outputDescriptor = this.transformDescriptor(inputDescriptor);
            if (outputDescriptor == null) {
                return null;
            }
            return new ElementValueInfo.ResultConst(outputDescriptor);
        }
        if (inputValue instanceof AnnotationInfo) {
            AnnotationInfo annotationValue = (AnnotationInfo)inputValue;
            return this.transform(annotationValue, AnnotationInfo::new, inputName);
        }
        if (inputValue instanceof String) {
            String oldVersion;
            String binaryPackageName;
            String dottedPackageName;
            String replacementVersion;
            String stringValue = (String)inputValue;
            String result = this.transformString(inputName, "AnnotationValue", stringValue);
            if (inputName.endsWith("/package-info.class") && annotationType.equals("Lorg/osgi/annotation/versioning/Version;") && elementName.equals("value") && (replacementVersion = this.replacePackageVersion("Export-Package", dottedPackageName = (binaryPackageName = inputName.substring(0, inputName.lastIndexOf(47))).replace('/', '.'), oldVersion = result == null ? stringValue : result)) != null) {
                result = replacementVersion;
            }
            return result;
        }
        if (inputValue instanceof Object[]) {
            Object[] inputElementValues = (Object[])inputValue;
            Object[] outputElementValues = null;
            for (int valueNo = 0; valueNo < inputElementValues.length; ++valueNo) {
                Object outputElementValue = this.transformElementValue(inputElementValues[valueNo], inputName, annotationType, elementName);
                if (outputElementValue == null) continue;
                if (outputElementValues == null) {
                    outputElementValues = (Object[])inputElementValues.clone();
                }
                outputElementValues[valueNo] = outputElementValue;
            }
            return outputElementValues;
        }
        return null;
    }

    private StackMapTableAttribute.VerificationTypeInfo[] transform(StackMapTableAttribute.VerificationTypeInfo[] inputVtis) {
        StackMapTableAttribute.VerificationTypeInfo[] outputVtis = null;
        for (int vtiNo = 0; vtiNo < inputVtis.length; ++vtiNo) {
            StackMapTableAttribute.VerificationTypeInfo inputVti = inputVtis[vtiNo];
            StackMapTableAttribute.VerificationTypeInfo outputVti = this.transform(inputVti);
            if (outputVti == null) continue;
            if (outputVtis == null) {
                outputVtis = (StackMapTableAttribute.VerificationTypeInfo[])inputVtis.clone();
            }
            outputVtis[vtiNo] = outputVti;
        }
        return outputVtis;
    }

    private StackMapTableAttribute.VerificationTypeInfo transform(StackMapTableAttribute.VerificationTypeInfo vti) {
        if (!(vti instanceof StackMapTableAttribute.ObjectVariableInfo)) {
            return null;
        }
        StackMapTableAttribute.ObjectVariableInfo inputOvi = (StackMapTableAttribute.ObjectVariableInfo)vti;
        String inputType = inputOvi.type;
        if (inputType == null) {
            return null;
        }
        String outputType = this.transformBinaryType(inputType);
        if (outputType == null) {
            return null;
        }
        return new StackMapTableAttribute.ObjectVariableInfo(inputOvi.tag, outputType);
    }

    private void logConstant(String typeName, String initialValue, String finalValue, String inputName) {
        this.getLogger().trace("Class [ {} ] [ {} ] [ {} ] [ {} ]", new Object[]{inputName, typeName, initialValue, finalValue});
    }

    private int transform(MutableConstantPool constants, String inputName) throws TransformException {
        Logger useLogger = this.getLogger();
        int modifiedConstants = 0;
        int numConstants = constants.size();
        block9: for (int constantNo = 1; constantNo < numConstants; ++constantNo) {
            if (useLogger.isTraceEnabled()) {
                useLogger.trace(String.format("Constant [ %3s ] [ %16s ] [ %s ]", constantNo, constants.tag(constantNo), constants.entry(constantNo)));
            }
            switch (constants.tag(constantNo)) {
                case 7: {
                    ConstantPool.ClassInfo info = (ConstantPool.ClassInfo)constants.entry(constantNo);
                    String inputClassName = (String)constants.entry(info.class_index);
                    String outputClassName = this.transformBinaryType(inputClassName);
                    if (outputClassName != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.ClassInfo(constants.utf8Info(outputClassName)));
                        ++modifiedConstants;
                        useLogger.debug("Class Reference: {} -> {}", (Object)inputClassName, (Object)outputClassName);
                        this.logConstant("Class Reference", inputClassName, outputClassName, inputName);
                        continue block9;
                    }
                    useLogger.debug("Skip class {} (unchanged)", (Object)inputClassName);
                    continue block9;
                }
                case 12: {
                    ConstantPool.ClassInfo info = (ConstantPool.NameAndTypeInfo)constants.entry(constantNo);
                    String inputDescriptor = constants.utf8(info.descriptor_index);
                    String outputDescriptor = this.transformDescriptor(inputDescriptor);
                    if (outputDescriptor != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.NameAndTypeInfo(info.name_index, constants.utf8Info(outputDescriptor)));
                        ++modifiedConstants;
                        useLogger.debug("NameAndType: {} -> {}", (Object)inputDescriptor, (Object)outputDescriptor);
                        this.logConstant("NameAndType", inputDescriptor, outputDescriptor, inputName);
                        continue block9;
                    }
                    useLogger.trace("Skip name-and-type {} (unchanged)", (Object)inputDescriptor);
                    continue block9;
                }
                case 16: {
                    ConstantPool.ClassInfo info = (ConstantPool.MethodTypeInfo)constants.entry(constantNo);
                    String inputDescriptor = constants.utf8(info.descriptor_index);
                    String outputDescriptor = this.transformDescriptor(inputDescriptor);
                    if (outputDescriptor != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.MethodTypeInfo(constants.utf8Info(outputDescriptor)));
                        ++modifiedConstants;
                        useLogger.debug("MethodType: {} -> {}", (Object)inputDescriptor, (Object)outputDescriptor);
                        this.logConstant("MethodType", inputDescriptor, outputDescriptor, inputName);
                        continue block9;
                    }
                    useLogger.trace("Skip method-type {} (unchanged)", (Object)inputDescriptor);
                    continue block9;
                }
                case 1: {
                    String inputUtf8 = (String)constants.entry(constantNo);
                    String outputUtf8 = this.transformString(inputName, "UTF8Constant", inputUtf8);
                    if (outputUtf8 != null) {
                        constants.entry(constantNo, (Object)outputUtf8);
                        ++modifiedConstants;
                        useLogger.debug("UTF8: {} -> {}", (Object)inputUtf8, (Object)outputUtf8);
                        this.logConstant("UTF8", inputUtf8, outputUtf8, inputName);
                        continue block9;
                    }
                    useLogger.trace("Skip UTF8 {} (unchanged)", (Object)inputUtf8);
                    continue block9;
                }
                case 8: {
                    ConstantPool.StringInfo stringInfo = (ConstantPool.StringInfo)constants.entry(constantNo);
                    String inputString = constants.utf8(stringInfo.string_index);
                    String outputString = this.transformString(inputName, "StringConstant", inputString);
                    if (outputString != null) {
                        constants.entry(constantNo, (Object)new ConstantPool.StringInfo(constants.utf8Info(outputString)));
                        ++modifiedConstants;
                        useLogger.debug("String: {} -> {}", (Object)inputString, (Object)outputString);
                        this.logConstant("String", inputString, outputString, inputName);
                        continue block9;
                    }
                    useLogger.trace("Skip string {} (unchanged)", (Object)inputString);
                    continue block9;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    useLogger.trace("Skip other (ignored)");
                    continue block9;
                }
                case 5: 
                case 6: {
                    useLogger.trace("Skip floating point value +1 (ignored)");
                    ++constantNo;
                    continue block9;
                }
                default: {
                    throw new TransformException("Unrecognized constant pool entry [ " + constantNo + " ]: [ " + constants.entry(constantNo) + " ]");
                }
            }
        }
        return modifiedConstants;
    }
}

