/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.ContainerChanges;
import org.eclipse.transformer.action.impl.ChangesImpl;
import org.slf4j.Logger;

public class ContainerChangesImpl
extends ChangesImpl
implements ContainerChanges {
    private final Map<String, int[]> unchangedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> changedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> renamedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> contentChangedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> failedByAction = new HashMap<String, int[]>();
    private final Map<String, int[]> duplicatedByAction = new HashMap<String, int[]>();
    private int allResources = 0;
    private int allUnselected = 0;
    private int allSelected = 0;
    private int allUnaccepted = 0;
    private int allAccepted = 0;
    private int allUnchanged = 0;
    private int allChanged = 0;
    private int allFailed = 0;
    private int allDuplicated = 0;
    private int allRenamed = 0;
    private int allContentChanged = 0;
    private static final String DASH_LINE = "================================================================================";
    private static final String SMALL_DASH_LINE = "--------------------------------------------------------------------------------";
    private static final String DATA_LINE = "[ %14s ] [ %6s ] %10s [ %6s ] %10s [ %6s ]%s";

    @Override
    public boolean isContentChanged() {
        return this.getAllChanged() != 0;
    }

    @Override
    public String toString() {
        return String.format("%s [%s]: [%d:%d]", this.getInputResourceName(), this.getChangeText(), this.getAllResources(), this.getAllChanged());
    }

    @Override
    public Set<String> getActionNames() {
        Set<String> unchangedNames = this.unchangedByAction.keySet();
        Set<String> changedNames = this.contentChangedByAction.keySet();
        HashSet<String> allNames = new HashSet<String>(unchangedNames.size() + changedNames.size());
        allNames.addAll(unchangedNames);
        allNames.addAll(changedNames);
        return allNames;
    }

    private void increment(Map<String, int[]> counter, String name) {
        int[] count = counter.get(name);
        if (count == null) {
            count = new int[]{1};
            counter.put(name, count);
        } else {
            count[0] = count[0] + 1;
        }
    }

    private void addChangeMap(Map<String, int[]> thisChangeMap, Map<String, int[]> otherChangeMap) {
        int[] nextChanges = new int[1];
        for (Map.Entry<String, int[]> mapEntry : otherChangeMap.entrySet()) {
            int[] thisChanges = thisChangeMap.putIfAbsent(mapEntry.getKey(), nextChanges);
            if (thisChanges == null) {
                thisChanges = nextChanges;
                nextChanges = new int[1];
            }
            thisChanges[0] = thisChanges[0] + mapEntry.getValue()[0];
        }
    }

    @Override
    public void add(ContainerChanges otherChanges) {
        this.addChangeMap(this.unchangedByAction, otherChanges.getUnchangedByAction());
        this.addChangeMap(this.changedByAction, otherChanges.getChangedByAction());
        this.addChangeMap(this.failedByAction, otherChanges.getFailedByAction());
        this.addChangeMap(this.duplicatedByAction, otherChanges.getDuplicatedByAction());
        this.addChangeMap(this.renamedByAction, otherChanges.getRenamedByAction());
        this.addChangeMap(this.contentChangedByAction, otherChanges.getChangedByAction());
        this.allResources += otherChanges.getAllResources();
        this.allUnselected += otherChanges.getAllUnselected();
        this.allUnaccepted += otherChanges.getAllUnaccepted();
        this.allAccepted += otherChanges.getAllAccepted();
        this.allUnchanged += otherChanges.getAllUnchanged();
        this.allChanged += otherChanges.getAllChanged();
        this.allFailed += otherChanges.getAllFailed();
        this.allDuplicated += otherChanges.getAllDuplicated();
        this.allContentChanged += otherChanges.getAllChanged();
        this.allRenamed += otherChanges.getAllRenamed();
    }

    @Override
    public Map<String, int[]> getUnchangedByAction() {
        return Collections.unmodifiableMap(this.unchangedByAction);
    }

    @Override
    public Map<String, int[]> getChangedByAction() {
        return Collections.unmodifiableMap(this.changedByAction);
    }

    @Override
    public Map<String, int[]> getRenamedByAction() {
        return Collections.unmodifiableMap(this.renamedByAction);
    }

    @Override
    public Map<String, int[]> getContentChangedByAction() {
        return Collections.unmodifiableMap(this.contentChangedByAction);
    }

    @Override
    public Map<String, int[]> getFailedByAction() {
        return Collections.unmodifiableMap(this.failedByAction);
    }

    @Override
    public Map<String, int[]> getDuplicatedByAction() {
        return Collections.unmodifiableMap(this.duplicatedByAction);
    }

    @Override
    public int getAllResources() {
        return this.allResources;
    }

    @Override
    public int getAllUnaccepted() {
        return this.allUnaccepted;
    }

    @Override
    public int getAllAccepted() {
        return this.allAccepted;
    }

    @Override
    public int getAllUnselected() {
        return this.allUnselected;
    }

    @Override
    public int getAllSelected() {
        return this.allSelected;
    }

    @Override
    public int getAllUnchanged() {
        return this.allUnchanged;
    }

    @Override
    public int getAllChanged() {
        return this.allChanged;
    }

    @Override
    public int getAllRenamed() {
        return this.allRenamed;
    }

    @Override
    public int getAllContentChanged() {
        return this.allContentChanged;
    }

    @Override
    public int getAllFailed() {
        return this.allFailed;
    }

    @Override
    public int getAllDuplicated() {
        return this.allDuplicated;
    }

    @Override
    public int getUnchanged(Action action) {
        return this.getUnchanged(action.getName());
    }

    @Override
    public int getUnchanged(String name) {
        int[] changes = this.unchangedByAction.get(name);
        return changes == null ? 0 : changes[0];
    }

    @Override
    public int getChanged(Action action) {
        return this.getChanged(action.getName());
    }

    @Override
    public int getChanged(String name) {
        int[] changes = this.changedByAction.get(name);
        return changes == null ? 0 : changes[0];
    }

    @Override
    public int getRenamed(Action action) {
        return this.getRenamed(action.getName());
    }

    @Override
    public int getRenamed(String name) {
        int[] renamed = this.renamedByAction.get(name);
        return renamed == null ? 0 : renamed[0];
    }

    @Override
    public int getContentChanged(Action action) {
        return this.getContentChanged(action.getName());
    }

    @Override
    public int getContentChanged(String name) {
        int[] changes = this.contentChangedByAction.get(name);
        return changes == null ? 0 : changes[0];
    }

    @Override
    public int getFailed(Action action) {
        return this.getFailed(action.getName());
    }

    @Override
    public int getFailed(String name) {
        int[] failed = this.failedByAction.get(name);
        return failed == null ? 0 : failed[0];
    }

    @Override
    public int getDuplicated(Action action) {
        return this.getDuplicated(action.getName());
    }

    @Override
    public int getDuplicated(String name) {
        int[] duplicated = this.duplicatedByAction.get(name);
        return duplicated == null ? 0 : duplicated[0];
    }

    @Override
    public void recordUnselected() {
        ++this.allResources;
        ++this.allUnselected;
    }

    @Override
    public void recordUnaccepted() {
        ++this.allResources;
        ++this.allSelected;
        ++this.allUnaccepted;
    }

    private void recordAccepted() {
        ++this.allResources;
        ++this.allSelected;
        ++this.allAccepted;
    }

    @Override
    public void recordUnchanged(Action action) {
        this.recordAccepted();
        ++this.allUnchanged;
        this.increment(this.unchangedByAction, action.getName());
    }

    @Override
    public void recordAction(Action action) {
        this.recordAccepted();
        String name = action.getName();
        boolean anyChanges = false;
        Changes lastChanges = action.getLastActiveChanges();
        if (lastChanges.isRenamed()) {
            anyChanges = true;
            ++this.allRenamed;
            this.increment(this.renamedByAction, name);
        }
        if (lastChanges.isContentChanged()) {
            anyChanges = true;
            ++this.allContentChanged;
            this.increment(this.contentChangedByAction, name);
        }
        if (anyChanges) {
            ++this.allChanged;
            this.increment(this.changedByAction, name);
        } else {
            ++this.allUnchanged;
            this.increment(this.unchangedByAction, name);
        }
    }

    @Override
    public void recordFailed(Action action) {
        this.recordAccepted();
        String name = action == null ? "null" : action.getName();
        ++this.allUnchanged;
        this.increment(this.unchangedByAction, name);
        ++this.allFailed;
        this.increment(this.failedByAction, name);
    }

    @Override
    public void recordDuplicated(Action action) {
        this.recordAccepted();
        String name = action == null ? "null" : action.getName();
        ++this.allUnchanged;
        this.increment(this.unchangedByAction, name);
        ++this.allDuplicated;
        this.increment(this.duplicatedByAction, name);
    }

    private String formatData(Object ... parms) {
        return String.format(DATA_LINE, parms);
    }

    @Override
    public void log(Logger logger, String inputPath, String outputPath) {
        if (logger.isDebugEnabled(Transformer.consoleMarker)) {
            logger.info(Transformer.consoleMarker, DASH_LINE);
        }
        super.log(logger, inputPath, outputPath);
    }

    @Override
    public void logChanges(Logger logger) {
        if (logger.isInfoEnabled(Transformer.consoleMarker)) {
            this.displaySummary(logger);
        }
        if (logger.isDebugEnabled(Transformer.consoleMarker)) {
            this.displayActions(logger);
        }
        logger.debug(Transformer.consoleMarker, DASH_LINE);
    }

    private void displaySummary(Logger logger) {
        logger.debug(Transformer.consoleMarker, DASH_LINE);
        logger.debug(Transformer.consoleMarker, "[ Summary ]");
        logger.debug(Transformer.consoleMarker, SMALL_DASH_LINE);
        logger.info(Transformer.consoleMarker, this.formatData("All Resources", this.getAllResources(), "Unaccepted", this.getAllUnaccepted(), "Accepted", this.getAllAccepted(), ""));
        logger.debug(Transformer.consoleMarker, this.formatData("All Accepted", this.getAllAccepted(), "Unselected", this.getAllUnselected(), "Selected", this.getAllSelected(), ""));
        logger.debug(Transformer.consoleMarker, this.formatData("All Selected", this.getAllAccepted(), "Unchanged", this.getAllUnchanged(), "Changed", this.getAllChanged(), ""));
        logger.info(Transformer.consoleMarker, this.formatData("All Unchanged", this.getAllUnchanged(), "Failed", this.getAllFailed(), "Duplicated", this.getAllDuplicated(), ""));
        logger.info(Transformer.consoleMarker, this.formatData("All Changed", this.getAllChanged(), "Renamed", this.getAllRenamed(), "Content", this.getAllContentChanged(), ""));
    }

    private void displayActions(Logger logger) {
        logger.debug(Transformer.consoleMarker, DASH_LINE);
        logger.debug(Transformer.consoleMarker, "[ Actions ]");
        logger.debug(Transformer.consoleMarker, SMALL_DASH_LINE);
        for (String actionName : this.getActionNames()) {
            int useUnchangedByAction = this.getUnchanged(actionName);
            int useChangedByAction = this.getChanged(actionName);
            logger.debug(Transformer.consoleMarker, this.formatData(actionName, useUnchangedByAction + useChangedByAction, "Unchanged", useUnchangedByAction, "Changed", useChangedByAction, ""));
        }
    }
}

