/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.File;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.ElementAction;
import org.eclipse.transformer.action.RenameAction;
import org.eclipse.transformer.action.impl.ContainerActionImpl;
import org.eclipse.transformer.action.impl.ZipActionImpl;
import org.eclipse.transformer.util.FileUtils;

public class DirectoryActionImpl
extends ContainerActionImpl {
    public DirectoryActionImpl(ActionContext context) {
        super(context);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.DIRECTORY;
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        return resourceFile != null && resourceFile.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String rootInputPath, File rootInputFile, String rootOutputPath, File rootOutputFile) throws TransformException {
        this.startRecording(rootInputPath);
        try {
            this.setResourceNames(rootInputPath, rootOutputPath);
            if (rootInputFile.isDirectory()) {
                this.transformDirectory("", rootInputFile, rootOutputFile);
            } else {
                this.transformFile("", rootInputFile, rootOutputFile);
            }
        }
        finally {
            this.stopRecording(rootInputPath);
        }
    }

    protected void transformDirectory(String pathFromRoot, File inputDirectory, File rootOutputFile) {
        for (File child : inputDirectory.listFiles()) {
            String childPathFromRoot = pathFromRoot.isEmpty() ? child.getName() : pathFromRoot + '/' + child.getName();
            if (child.isDirectory()) {
                this.transformDirectory(childPathFromRoot, child, rootOutputFile);
                continue;
            }
            this.transformFile(childPathFromRoot, child, rootOutputFile);
        }
    }

    protected void transformFile(String pathFromRoot, File inputFile, File rootOutputFile) {
        Action action = this.selectAction(pathFromRoot, inputFile);
        try {
            if (action == null) {
                this.copyInto(pathFromRoot, inputFile, rootOutputFile);
                this.recordUnaccepted(pathFromRoot);
            } else if (!this.selectResource(pathFromRoot)) {
                this.copyInto(pathFromRoot, inputFile, rootOutputFile);
                this.recordUnselected(pathFromRoot);
            } else if (action.isRenameAction()) {
                RenameAction renameAction = (RenameAction)action;
                String outputPathFromRoot = renameAction.apply(pathFromRoot);
                outputPathFromRoot = FileUtils.sanitize(outputPathFromRoot);
                this.copyInto(pathFromRoot, inputFile, rootOutputFile, outputPathFromRoot);
                this.recordAction(action, pathFromRoot);
            } else if (action.isArchiveAction()) {
                ZipActionImpl zipAction = (ZipActionImpl)action;
                String outputPathFromRoot = zipAction.relocateResource(pathFromRoot);
                outputPathFromRoot = FileUtils.sanitize(outputPathFromRoot);
                File outputFile = new File(rootOutputFile, outputPathFromRoot);
                zipAction.apply(pathFromRoot, inputFile, outputPathFromRoot, outputFile);
                this.recordAction(zipAction, pathFromRoot);
            } else if (!action.isElementAction()) {
                this.getLogger().warn("Strange: Unknown action type [ {} ] for [ {} ]", (Object)action.getClass().getName(), (Object)inputFile.getAbsolutePath());
                this.copyInto(pathFromRoot, inputFile, rootOutputFile);
                this.recordUnaccepted(pathFromRoot);
            } else {
                ElementAction elementAction = (ElementAction)action;
                this.transformFile(elementAction, pathFromRoot, inputFile, rootOutputFile);
                this.recordAction(elementAction, pathFromRoot);
            }
        }
        catch (Throwable th) {
            this.recordError(action, pathFromRoot, th);
        }
    }

    private void transformFile(ElementAction elementAction, String inputName, File inputFile, File outputRoot) throws TransformException {
        TransformException transformError;
        ByteData outputData;
        ByteData inputData = this.collect(inputName, inputFile);
        try {
            outputData = elementAction.apply(inputData);
            transformError = null;
        }
        catch (TransformException t) {
            outputData = inputData;
            transformError = t;
        }
        File outputFile = new File(outputRoot, outputData.name());
        this.write(outputData, outputFile);
        if (transformError != null) {
            throw transformError;
        }
    }
}

