/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.ThrowsSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeParameter;
import aQute.bnd.signatures.TypeVariableSignature;
import aQute.bnd.stream.MapStream;
import aQute.libg.glob.Glob;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.SignatureUtils;
import org.slf4j.Logger;

public class SignatureRuleImpl
implements SignatureRule {
    private final Logger logger;
    protected final Map<String, String> dottedPackageRenames;
    protected final Map<String, String> slashedPackageRenames;
    private static final String DOT_WILDCARD = ".*";
    private static final String SLASH_WILDCARD = "/*";
    protected final Map<String, String> packageVersions;
    protected final Map<String, Map<String, String>> specificPackageVersions;
    private final Map<String, BundleData> bundleUpdates;
    private final Map<String, Map<String, String>> specificTextUpdates;
    private final Map<Pattern, Map<String, String>> wildCardTextUpdates;
    private final Map<String, String> directStrings;
    private final Map<String, Map<String, String>> perClassDirectStrings;
    private final Map<String, String> changedBinaryTypes;
    private final Set<String> unchangedBinaryTypes;
    private final Set<String> unchangedDescriptors;
    private final Map<String, String> changedDescriptors;
    private final Set<String> unchangedSignatures;
    private final Map<String, String> changedSignatures;

    public SignatureRuleImpl(Logger logger, Map<String, String> packageRenames, Map<String, String> packageVersions, Map<String, Map<String, String>> specificPackageVersions, Map<String, BundleData> bundleUpdates, Map<String, Map<String, String>> masterTextUpdates, Map<String, String> directStrings, Map<String, Map<String, String>> perClassDirectStrings) {
        Map<String, HashMap<String, String>> usePerClassDirectStrings;
        Map useSlashedRenames;
        Map useDottedRenames;
        this.logger = logger;
        if (packageRenames == null || packageRenames.isEmpty()) {
            useDottedRenames = Collections.emptyMap();
            useSlashedRenames = Collections.emptyMap();
        } else {
            useDottedRenames = new LinkedHashMap(packageRenames.size());
            useSlashedRenames = new LinkedHashMap(packageRenames.size());
            MapStream.of(packageRenames).sortedByKey((Comparator)new SignatureUtils.RenameKeyComparator('.')).forEachOrdered((initialName, finalName) -> {
                useDottedRenames.put(initialName, finalName);
                useSlashedRenames.put(SignatureUtils.putSlashes(initialName), SignatureUtils.putSlashes(finalName));
            });
        }
        this.dottedPackageRenames = useDottedRenames;
        this.slashedPackageRenames = useSlashedRenames;
        Map<Object, Object> useVersions = packageVersions != null && !packageVersions.isEmpty() ? new HashMap<String, String>(packageVersions) : Collections.emptyMap();
        this.packageVersions = useVersions;
        HashMap<String, HashMap<String, String>> useSpecificVersions = null;
        if (specificPackageVersions != null && !specificPackageVersions.isEmpty()) {
            for (Map.Entry<String, Map<String, String>> versionEntry : specificPackageVersions.entrySet()) {
                String propertyName = versionEntry.getKey();
                Map<String, String> versionsForProperty = versionEntry.getValue();
                if (useSpecificVersions == null) {
                    useSpecificVersions = new HashMap();
                }
                if (versionsForProperty == null || versionsForProperty.isEmpty()) continue;
                useSpecificVersions.put(propertyName, new HashMap<String, String>(versionsForProperty));
            }
        }
        if (useSpecificVersions == null) {
            useSpecificVersions = new HashMap<String, HashMap<String, String>>();
        }
        this.specificPackageVersions = useSpecificVersions;
        Map<Object, Object> useBundleUpdates = bundleUpdates != null && !bundleUpdates.isEmpty() ? new HashMap<String, BundleData>(bundleUpdates) : Collections.emptyMap();
        this.bundleUpdates = useBundleUpdates;
        if (masterTextUpdates != null && !masterTextUpdates.isEmpty()) {
            HashMap<String, Map<String, String>> useSpecificTextUpdates = new HashMap<String, Map<String, String>>();
            HashMap<Pattern, Map<String, String>> useWildCardTextUpdates = new HashMap<Pattern, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : masterTextUpdates.entrySet()) {
                String matchesFileName = entry.getKey();
                Map<String, String> substitutions = entry.getValue();
                if (matchesFileName.indexOf(63) != -1 || matchesFileName.indexOf(42) != -1) {
                    Pattern matchPattern = Glob.toPattern((String)matchesFileName);
                    useWildCardTextUpdates.put(matchPattern, substitutions);
                    continue;
                }
                useSpecificTextUpdates.put(matchesFileName, substitutions);
            }
            this.specificTextUpdates = useSpecificTextUpdates;
            this.wildCardTextUpdates = useWildCardTextUpdates;
        } else {
            this.specificTextUpdates = Collections.emptyMap();
            this.wildCardTextUpdates = Collections.emptyMap();
        }
        Map<Object, Object> useDirectStrings = directStrings == null || directStrings.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(directStrings);
        this.directStrings = useDirectStrings;
        if (perClassDirectStrings == null || perClassDirectStrings.isEmpty()) {
            usePerClassDirectStrings = Collections.emptyMap();
        } else {
            usePerClassDirectStrings = new HashMap(perClassDirectStrings.size());
            for (Map.Entry<String, Map<String, String>> perClassEntry : perClassDirectStrings.entrySet()) {
                String key = perClassEntry.getKey();
                Map<String, String> value = perClassEntry.getValue();
                HashMap<String, String> localValue = new HashMap<String, String>(value);
                usePerClassDirectStrings.put(key, localValue);
            }
        }
        this.perClassDirectStrings = usePerClassDirectStrings;
        this.unchangedBinaryTypes = new HashSet<String>();
        this.changedBinaryTypes = new HashMap<String, String>();
        this.unchangedDescriptors = new HashSet<String>();
        this.changedDescriptors = new HashMap<String, String>();
        this.unchangedSignatures = new HashSet<String>();
        this.changedSignatures = new HashMap<String, String>();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Map<String, String> getPackageRenames() {
        return this.dottedPackageRenames;
    }

    @Override
    public Map<String, String> getBinaryPackageRenames() {
        return this.slashedPackageRenames;
    }

    @Override
    public String replacePackage(String initialName) {
        return this.replacePackage(initialName, DOT_WILDCARD, this.dottedPackageRenames);
    }

    @Override
    public String replaceBinaryPackage(String initialName) {
        return this.replacePackage(initialName, SLASH_WILDCARD, this.slashedPackageRenames);
    }

    private String replacePackage(String initialName, String wildcard, Map<String, String> renames) {
        String finalName = SignatureUtils.keyStream(initialName, wildcard).filter(renames::containsKey).findFirst().map(key -> {
            String name = (String)renames.get(key);
            if (SignatureUtils.containsWildcard(key)) {
                name = name.concat(initialName.substring(key.length() - 2));
            }
            return name;
        }).orElse(null);
        return finalName;
    }

    @Override
    public String replacePackages(String text) {
        return this.replacePackages(text, this.dottedPackageRenames);
    }

    @Override
    public String replaceBinaryPackages(String text) {
        return this.replacePackages(text, this.slashedPackageRenames);
    }

    private String replacePackages(String text, Map<String, String> renames) {
        String initialText = text;
        for (Map.Entry<String, String> renameEntry : renames.entrySet()) {
            int matchStart;
            String key = renameEntry.getKey();
            boolean matchPackageStem = SignatureUtils.containsWildcard(key);
            if (matchPackageStem) {
                key = SignatureUtils.stripWildcard(key);
            }
            int keyLen = key.length();
            int textLimit = text.length() - keyLen;
            int matchEnd = 0;
            while (matchEnd <= textLimit && (matchStart = text.indexOf(key, matchEnd)) != -1) {
                matchEnd = matchStart + keyLen;
                int packageEnd = SignatureUtils.packageMatch(text, matchStart, matchEnd, matchPackageStem);
                if (packageEnd == -1) continue;
                String value = renameEntry.getValue();
                if (matchEnd < packageEnd) {
                    value = value.concat(text.substring(matchEnd, packageEnd));
                }
                String head = text.substring(0, matchStart);
                String tail = text.substring(packageEnd);
                text = head + value + tail;
                matchEnd = matchStart + value.length();
                textLimit = text.length() - keyLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    @Override
    public Map<String, String> getPackageVersions() {
        return this.packageVersions;
    }

    @Override
    public Map<String, Map<String, String>> getSpecificPackageVersions() {
        return this.specificPackageVersions;
    }

    @Override
    public String replacePackageVersion(String attributeName, String packageName, String oldVersion) {
        Logger useLogger = this.getLogger();
        Map<String, String> versionsForAttribute = this.getSpecificPackageVersions().get(attributeName);
        String specificVersion = versionsForAttribute != null ? versionsForAttribute.get(packageName) : null;
        String genericVersion = this.getPackageVersions().get(packageName);
        if (specificVersion == null && genericVersion == null) {
            useLogger.trace("Manifest attribute {}: Package {} version {} is unchanged", new Object[]{attributeName, packageName, oldVersion});
            return null;
        }
        if (specificVersion == null) {
            useLogger.trace("Manifest attribute {}: Generic update of package {} version {} to {}", new Object[]{attributeName, packageName, oldVersion, genericVersion});
            return genericVersion;
        }
        if (genericVersion == null) {
            useLogger.trace("Manifest attribute {}: Specific update of package {} version {} to {}", new Object[]{attributeName, packageName, oldVersion, specificVersion});
            return specificVersion;
        }
        useLogger.trace("Manifest attribute {}: Specific update of package {} version {} to {} overrides generic version update {}", new Object[]{attributeName, packageName, oldVersion, specificVersion, genericVersion});
        return specificVersion;
    }

    @Override
    public BundleData getBundleUpdate(String symbolicName) {
        return this.bundleUpdates.get(symbolicName);
    }

    @Override
    public Map<String, Map<String, String>> getSpecificTextUpdates() {
        return this.specificTextUpdates;
    }

    @Override
    public Map<Pattern, Map<String, String>> getWildCardTextUpdates() {
        return this.wildCardTextUpdates;
    }

    @Override
    public Map<String, String> getTextSubstitutions(String inputName) {
        String simpleFileName = FileUtils.getFileNameFromFullyQualifiedFileName(inputName);
        Map<String, Map<String, String>> specificUpdates = this.getSpecificTextUpdates();
        Map<String, String> updates = specificUpdates.get(simpleFileName);
        if (updates != null) {
            return updates;
        }
        Map<Pattern, Map<String, String>> wildcardUpdates = this.getWildCardTextUpdates();
        for (Map.Entry<Pattern, Map<String, String>> wildcardEntry : wildcardUpdates.entrySet()) {
            if (!SignatureRuleImpl.matches(wildcardEntry.getKey(), simpleFileName)) continue;
            return wildcardEntry.getValue();
        }
        return null;
    }

    private static boolean matches(Pattern p, CharSequence input) {
        Matcher m = p.matcher(input);
        return m.matches();
    }

    @Override
    public String replaceText(String inputName, String text) {
        Map<String, String> substitutions = this.getTextSubstitutions(inputName);
        if (substitutions == null) {
            return null;
        }
        String initialText = text;
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            int matchStart;
            int valueLen;
            String key = entry.getKey();
            int keyLen = key.length();
            int lastMatchEnd = 0;
            for (int textLimit = text.length() - keyLen; lastMatchEnd <= textLimit && (matchStart = text.indexOf(key, lastMatchEnd)) != -1; textLimit += valueLen - keyLen) {
                String value = entry.getValue();
                valueLen = value.length();
                String head = text.substring(0, matchStart);
                String tail = text.substring(matchStart + keyLen);
                text = head + value + tail;
                lastMatchEnd = matchStart + valueLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    @Override
    public boolean hasTextUpdates() {
        return !this.getSpecificTextUpdates().isEmpty() || !this.getWildCardTextUpdates().isEmpty();
    }

    @Override
    public Map<String, String> getDirectGlobalUpdates() {
        return this.directStrings;
    }

    @Override
    public Map<String, Map<String, String>> getDirectPerClassUpdates() {
        return this.perClassDirectStrings;
    }

    @Override
    public String replaceTextDirectGlobal(String initialValue, String inputName) {
        return this.replaceTextDirect(initialValue, inputName, this.directStrings, "Global");
    }

    @Override
    public String replaceTextDirectPerClass(String initialValue, String inputName) {
        Map<String, String> directStringsForClass = this.perClassDirectStrings.get(inputName);
        if (directStringsForClass == null) {
            return null;
        }
        return this.replaceTextDirect(initialValue, inputName, directStringsForClass, "Per-Class");
    }

    private String replaceTextDirect(String initialValue, String inputName, Map<String, String> updates, String updateCase) {
        Logger useLogger = this.getLogger();
        String fullFinalValue = updates.get(initialValue);
        if (fullFinalValue != null) {
            useLogger.debug("{} full direct replacement: [ {} ]: [ {} => {} ]", new Object[]{updateCase, inputName, initialValue, fullFinalValue});
            return fullFinalValue;
        }
        String finalValue = initialValue;
        for (Map.Entry<String, String> directEntry : updates.entrySet()) {
            String initialSubValue = directEntry.getKey();
            String finalSubValue = directEntry.getValue();
            if (!finalValue.contains(initialSubValue)) continue;
            finalValue = finalValue.replace(initialSubValue, finalSubValue);
            useLogger.debug("{} token direct replacement: [ {} ]: [ {} => {} ]", new Object[]{updateCase, inputName, initialSubValue, finalSubValue});
        }
        if (finalValue != initialValue) {
            return finalValue;
        }
        return null;
    }

    @Override
    public String packageRenameInput(String inputName) {
        String qualifiedName;
        String inputPrefix;
        int lastSlash = inputName.lastIndexOf(47);
        if (lastSlash == -1) {
            inputPrefix = null;
            qualifiedName = inputName;
        } else {
            inputPrefix = inputName.substring(0, lastSlash + 1);
            qualifiedName = inputName.substring(lastSlash + 1);
        }
        int classStart = qualifiedName.lastIndexOf(46);
        if (classStart == -1) {
            return null;
        }
        String packageName = qualifiedName.substring(0, classStart);
        if (packageName.isEmpty()) {
            return null;
        }
        String className = qualifiedName.substring(classStart);
        String outputName = this.replacePackage(packageName);
        if (outputName == null) {
            return null;
        }
        if (inputPrefix == null) {
            return outputName + className;
        }
        return inputPrefix + outputName + className;
    }

    @Override
    public String transformBinaryType(String inputConstant) {
        try {
            return this.basicTransformBinaryType(inputConstant);
        }
        catch (Throwable th) {
            this.getLogger().trace("Failed to parse constant as resource reference [ {} ]", (Object)inputConstant, (Object)th);
            return null;
        }
    }

    private String basicTransformBinaryType(String inputName) {
        if (this.unchangedBinaryTypes.contains(inputName)) {
            return null;
        }
        String outputName = this.changedBinaryTypes.get(inputName);
        if (outputName != null) {
            return outputName;
        }
        char c = inputName.charAt(0);
        if (c == '[' || c == 'L' && inputName.charAt(inputName.length() - 1) == ';') {
            JavaTypeSignature inputSignature = JavaTypeSignature.of((String)inputName.replace('$', '.'));
            JavaTypeSignature outputSignature = this.transform(inputSignature);
            if (outputSignature != null) {
                outputName = outputSignature.toString().replace('.', '$');
            }
        } else {
            String inputPackage;
            String outputPackage;
            int lastSlashOffset = inputName.lastIndexOf(47);
            if (lastSlashOffset != -1 && (outputPackage = this.replaceBinaryPackage(inputPackage = inputName.substring(0, lastSlashOffset))) != null) {
                outputName = outputPackage + inputName.substring(lastSlashOffset);
            }
        }
        if (outputName == null) {
            this.unchangedBinaryTypes.add(inputName);
        } else {
            this.changedBinaryTypes.put(inputName, outputName);
        }
        return outputName;
    }

    @Override
    public String transformDescriptor(String inputConstant) {
        try {
            return this.basicTransformDescriptor(inputConstant);
        }
        catch (Throwable th) {
            this.getLogger().trace("Failed to parse constant as descriptor [ {} ]", (Object)inputConstant, (Object)th);
            return null;
        }
    }

    @Override
    public String relocateResource(String inputPath) {
        String outputName;
        String inputName;
        String prefix;
        if (inputPath.startsWith("WEB-INF/classes/")) {
            prefix = "WEB-INF/classes/";
            inputName = inputPath.substring(prefix.length());
        } else if (inputPath.startsWith("META-INF/versions/")) {
            prefix = "META-INF/versions/";
            int nextSlash = inputPath.indexOf(47, prefix.length());
            if (nextSlash != -1) {
                prefix = inputPath.substring(0, nextSlash + 1);
            }
            inputName = inputPath.substring(prefix.length());
        } else {
            prefix = "";
            inputName = inputPath;
        }
        if (!inputName.isEmpty() && (outputName = this.transformBinaryType(inputName)) != null) {
            String outputPath = prefix.isEmpty() ? outputName : prefix.concat(outputName);
            return outputPath;
        }
        return inputPath;
    }

    private String basicTransformDescriptor(String inputDescriptor) {
        String inputSignature;
        String outputSignature;
        if (this.unchangedDescriptors.contains(inputDescriptor)) {
            return null;
        }
        String outputDescriptor = this.changedDescriptors.get(inputDescriptor);
        if (outputDescriptor != null) {
            return outputDescriptor;
        }
        char c = inputDescriptor.charAt(0);
        if (c == '(') {
            String inputSignature2 = inputDescriptor.replace('$', '.');
            String outputSignature2 = this.transformSignature(inputSignature2, SignatureRule.SignatureType.METHOD);
            if (outputSignature2 != null) {
                outputDescriptor = outputSignature2.replace('.', '$');
            }
        } else if ((c == '[' || c == 'L' && inputDescriptor.charAt(inputDescriptor.length() - 1) == ';') && (outputSignature = this.transformSignature(inputSignature = inputDescriptor.replace('$', '.'), SignatureRule.SignatureType.FIELD)) != null) {
            outputDescriptor = outputSignature.replace('.', '$');
        }
        if (outputDescriptor == null) {
            this.unchangedDescriptors.add(inputDescriptor);
        } else {
            this.changedDescriptors.put(inputDescriptor, outputDescriptor);
        }
        return outputDescriptor;
    }

    @Override
    public String transformSignature(String initialSignature, SignatureRule.SignatureType signatureType) {
        if (this.unchangedSignatures.contains(initialSignature)) {
            return null;
        }
        String finalSignature = this.changedSignatures.get(initialSignature);
        if (finalSignature != null) {
            return finalSignature;
        }
        if (signatureType == SignatureRule.SignatureType.CLASS) {
            ClassSignature initialClassSignature = ClassSignature.of((String)initialSignature);
            ClassSignature finalClassSignature = this.transform(initialClassSignature);
            if (finalClassSignature != null) {
                finalSignature = finalClassSignature.toString();
            }
        } else if (signatureType == SignatureRule.SignatureType.FIELD) {
            FieldSignature initialFieldSignature = FieldSignature.of((String)initialSignature);
            FieldSignature finalFieldSignature = this.transform(initialFieldSignature);
            if (finalFieldSignature != null) {
                finalSignature = finalFieldSignature.toString();
            }
        } else if (signatureType == SignatureRule.SignatureType.METHOD) {
            MethodSignature initialMethodSignature = MethodSignature.of((String)initialSignature);
            MethodSignature finalMethodSignature = this.transform(initialMethodSignature);
            if (finalMethodSignature != null) {
                finalSignature = finalMethodSignature.toString();
            }
        } else {
            throw new IllegalArgumentException("Signature [ " + initialSignature + " ] uses unknown type [ " + (Object)((Object)signatureType) + " ]");
        }
        if (finalSignature == null) {
            this.unchangedSignatures.add(initialSignature);
        } else {
            this.changedSignatures.put(initialSignature, finalSignature);
        }
        return finalSignature;
    }

    private ClassSignature transform(ClassSignature classSignature) {
        TypeParameter[] inputTypes = classSignature.typeParameters;
        TypeParameter[] outputTypes = null;
        for (int parmNo = 0; parmNo < inputTypes.length; ++parmNo) {
            TypeParameter inputType = inputTypes[parmNo];
            TypeParameter outputType = this.transform(inputType);
            if (outputType == null) continue;
            if (outputTypes == null) {
                outputTypes = (TypeParameter[])inputTypes.clone();
            }
            outputTypes[parmNo] = outputType;
        }
        ClassTypeSignature inputSuperClass = classSignature.superClass;
        ClassTypeSignature outputSuperClass = this.transform(inputSuperClass);
        ClassTypeSignature[] inputInterfaces = classSignature.superInterfaces;
        ClassTypeSignature[] outputInterfaces = null;
        for (int interfaceNo = 0; interfaceNo < inputInterfaces.length; ++interfaceNo) {
            ClassTypeSignature inputInterface = inputInterfaces[interfaceNo];
            ClassTypeSignature outputInterface = this.transform(inputInterface);
            if (outputInterface == null) continue;
            if (outputInterfaces == null) {
                outputInterfaces = (ClassTypeSignature[])inputInterfaces.clone();
            }
            outputInterfaces[interfaceNo] = outputInterface;
        }
        if (outputTypes == null && outputSuperClass == null && outputInterfaces == null) {
            return null;
        }
        return new ClassSignature(outputTypes == null ? inputTypes : outputTypes, outputSuperClass == null ? inputSuperClass : outputSuperClass, outputInterfaces == null ? inputInterfaces : outputInterfaces);
    }

    private FieldSignature transform(FieldSignature fieldSignature) {
        ReferenceTypeSignature inputType = fieldSignature.type;
        ReferenceTypeSignature outputType = this.transform(inputType);
        if (outputType == null) {
            return null;
        }
        return new FieldSignature(outputType);
    }

    private MethodSignature transform(MethodSignature methodSignature) {
        TypeParameter[] inputTypeParms = methodSignature.typeParameters;
        TypeParameter[] outputTypeParms = null;
        for (int parmNo = 0; parmNo < inputTypeParms.length; ++parmNo) {
            TypeParameter inputTypeParm = inputTypeParms[parmNo];
            TypeParameter outputTypeParm = this.transform(inputTypeParm);
            if (outputTypeParm == null) continue;
            if (outputTypeParms == null) {
                outputTypeParms = (TypeParameter[])inputTypeParms.clone();
            }
            outputTypeParms[parmNo] = outputTypeParm;
        }
        JavaTypeSignature[] inputParmTypes = methodSignature.parameterTypes;
        JavaTypeSignature[] outputParmTypes = null;
        for (int parmNo = 0; parmNo < inputParmTypes.length; ++parmNo) {
            JavaTypeSignature inputParmType = inputParmTypes[parmNo];
            JavaTypeSignature outputParmType = this.transform(inputParmType);
            if (outputParmType == null) continue;
            if (outputParmTypes == null) {
                outputParmTypes = (JavaTypeSignature[])inputParmTypes.clone();
            }
            outputParmTypes[parmNo] = outputParmType;
        }
        Result inputResult = methodSignature.resultType;
        Result outputResult = this.transform(inputResult);
        ThrowsSignature[] inputThrows = methodSignature.throwTypes;
        ThrowsSignature[] outputThrows = null;
        for (int throwNo = 0; throwNo < inputThrows.length; ++throwNo) {
            ThrowsSignature inputThrow = inputThrows[throwNo];
            ThrowsSignature outputThrow = this.transform(inputThrow);
            if (outputThrow == null) continue;
            if (outputThrows == null) {
                outputThrows = (ThrowsSignature[])inputThrows.clone();
            }
            outputThrows[throwNo] = outputThrow;
        }
        if (outputTypeParms == null && outputParmTypes == null && outputResult == null && outputThrows == null) {
            return null;
        }
        return new MethodSignature(outputTypeParms == null ? inputTypeParms : outputTypeParms, outputParmTypes == null ? inputParmTypes : outputParmTypes, outputResult == null ? inputResult : outputResult, outputThrows == null ? inputThrows : outputThrows);
    }

    private Result transform(Result type) {
        if (type instanceof JavaTypeSignature) {
            return this.transform((JavaTypeSignature)type);
        }
        return null;
    }

    private ThrowsSignature transform(ThrowsSignature type) {
        if (type instanceof ClassTypeSignature) {
            return this.transform((ClassTypeSignature)type);
        }
        return null;
    }

    private ArrayTypeSignature transform(ArrayTypeSignature inputType) {
        JavaTypeSignature inputComponent = inputType.component;
        int componentDepth = 1;
        while (inputComponent instanceof ArrayTypeSignature) {
            ++componentDepth;
            inputComponent = ((ArrayTypeSignature)inputComponent).component;
        }
        if (inputComponent instanceof BaseType || inputComponent instanceof TypeVariableSignature) {
            return null;
        }
        ClassTypeSignature outputComponent = this.transform((ClassTypeSignature)inputComponent);
        if (outputComponent == null) {
            return null;
        }
        ArrayTypeSignature outputType = new ArrayTypeSignature((JavaTypeSignature)outputComponent);
        while (--componentDepth > 0) {
            outputType = new ArrayTypeSignature((JavaTypeSignature)outputType);
        }
        return outputType;
    }

    private TypeParameter transform(TypeParameter inputTypeParameter) {
        ReferenceTypeSignature inputClassBound = inputTypeParameter.classBound;
        ReferenceTypeSignature outputClassBound = this.transform(inputClassBound);
        ReferenceTypeSignature[] inputBounds = inputTypeParameter.interfaceBounds;
        ReferenceTypeSignature[] outputBounds = null;
        for (int boundNo = 0; boundNo < inputBounds.length; ++boundNo) {
            ReferenceTypeSignature inputBound = inputBounds[boundNo];
            ReferenceTypeSignature outputBound = this.transform(inputBound);
            if (outputBound == null) continue;
            if (outputBounds == null) {
                outputBounds = (ReferenceTypeSignature[])inputBounds.clone();
            }
            outputBounds[boundNo] = outputBound;
        }
        if (outputClassBound == null && outputBounds == null) {
            return null;
        }
        return new TypeParameter(inputTypeParameter.identifier, outputClassBound == null ? inputClassBound : outputClassBound, outputBounds == null ? inputBounds : outputBounds);
    }

    private ClassTypeSignature transform(ClassTypeSignature inputType) {
        String inputBinaryPackage;
        String outputBinaryPackage;
        String inputPackageSpecifier = inputType.packageSpecifier;
        String outputPackageSpecifier = null;
        int length = inputPackageSpecifier.length();
        if (length > 0 && (outputBinaryPackage = this.replaceBinaryPackage(inputBinaryPackage = inputPackageSpecifier.substring(0, length - 1))) != null) {
            outputPackageSpecifier = outputBinaryPackage + '/';
        }
        SimpleClassTypeSignature inputClassType = inputType.classType;
        SimpleClassTypeSignature outputClassType = this.transform(inputClassType);
        SimpleClassTypeSignature[] inputInnerTypes = inputType.innerTypes;
        SimpleClassTypeSignature[] outputInnerTypes = null;
        for (int typeNo = 0; typeNo < inputInnerTypes.length; ++typeNo) {
            SimpleClassTypeSignature inputInnerType = inputInnerTypes[typeNo];
            SimpleClassTypeSignature outputInnerType = this.transform(inputInnerType);
            if (outputInnerType == null) continue;
            if (outputInnerTypes == null) {
                outputInnerTypes = (SimpleClassTypeSignature[])inputInnerTypes.clone();
            }
            outputInnerTypes[typeNo] = outputInnerType;
        }
        if (outputPackageSpecifier == null && outputClassType == null && outputInnerTypes == null) {
            return null;
        }
        return new ClassTypeSignature(inputType.binary, outputPackageSpecifier == null ? inputPackageSpecifier : outputPackageSpecifier, outputClassType == null ? inputClassType : outputClassType, outputInnerTypes == null ? inputInnerTypes : outputInnerTypes);
    }

    private SimpleClassTypeSignature transform(SimpleClassTypeSignature inputSignature) {
        TypeArgument[] inputArgs = inputSignature.typeArguments;
        TypeArgument[] outputArgs = null;
        for (int argNo = 0; argNo < inputArgs.length; ++argNo) {
            TypeArgument inputArg = inputArgs[argNo];
            TypeArgument outputArg = this.transform(inputArg);
            if (outputArg == null) continue;
            if (outputArgs == null) {
                outputArgs = (TypeArgument[])inputArgs.clone();
            }
            outputArgs[argNo] = outputArg;
        }
        if (outputArgs == null) {
            return null;
        }
        return new SimpleClassTypeSignature(inputSignature.identifier, outputArgs);
    }

    private TypeArgument transform(TypeArgument inputArgument) {
        ReferenceTypeSignature inputSignature = inputArgument.type;
        ReferenceTypeSignature outputSignature = this.transform(inputSignature);
        if (outputSignature == null) {
            return null;
        }
        return new TypeArgument(inputArgument.wildcard, outputSignature);
    }

    private JavaTypeSignature transform(JavaTypeSignature type) {
        if (type instanceof ReferenceTypeSignature) {
            return this.transform((ReferenceTypeSignature)type);
        }
        return null;
    }

    private ReferenceTypeSignature transform(ReferenceTypeSignature type) {
        if (type instanceof ClassTypeSignature) {
            return this.transform((ClassTypeSignature)type);
        }
        if (type instanceof ArrayTypeSignature) {
            return this.transform((ArrayTypeSignature)type);
        }
        return null;
    }
}

