/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferOutputStream;
import aQute.lib.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.ElementAction;
import org.eclipse.transformer.action.RenameAction;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ContainerActionImpl;
import org.eclipse.transformer.util.FileUtils;
import org.slf4j.Logger;

public class ZipActionImpl
extends ContainerActionImpl
implements ElementAction {
    private final ActionType actionType;

    public ZipActionImpl(ActionContext context, ActionType actionType) {
        super(context);
        this.actionType = actionType;
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public boolean isArchiveAction() {
        return true;
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        return this.matchResourceName(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String inputPath, File inputFile, String outputPath, File outputFile) throws TransformException {
        this.startRecording(inputPath);
        try {
            this.setResourceNames(inputPath, outputPath);
            this.applyFile(inputPath, inputFile, outputPath, outputFile);
        }
        finally {
            this.stopRecording(inputPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData apply(ByteData inputData) throws TransformException {
        String inputPath = inputData.name();
        this.startRecording(inputPath);
        try {
            ByteDataImpl outputData;
            String outputPath = this.relocateResource(inputPath);
            this.setResourceNames(inputPath, outputPath);
            InputStream inputStream = inputData.stream();
            ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputData.length());
            this.applyStream(inputPath, inputStream, outputPath, (OutputStream)outputStream);
            if (!this.isChanged()) {
                ByteData byteData = inputData;
                return byteData;
            }
            ByteBuffer outputBuffer = this.isContentChanged() ? outputStream.toByteBuffer() : inputData.buffer();
            ByteDataImpl byteDataImpl = outputData = new ByteDataImpl(outputPath, outputBuffer, inputData.charset());
            return byteDataImpl;
        }
        finally {
            this.stopRecording(inputPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(String inputPath, InputStream inputStream, String outputPath, OutputStream outputStream) throws TransformException {
        this.startRecording(inputPath);
        try {
            this.setResourceNames(inputPath, outputPath);
            this.applyStream(inputPath, inputStream, outputPath, outputStream);
        }
        finally {
            this.stopRecording(inputPath);
        }
    }

    private void applyFile(String inputPath, File inputFile, String outputPath, File outputFile) throws TransformException {
        File outputParent = outputFile.getParentFile();
        try {
            IO.mkdirs((File)outputParent);
        }
        catch (IOException e) {
            throw new TransformException("Failed to create directory [ " + outputParent.getAbsolutePath() + " ]", e);
        }
        try (InputStream inputStream = IO.stream((File)inputFile);){
            try (OutputStream outputStream = IO.outputStream((File)outputFile);){
                this.applyStream(inputPath, inputStream, outputPath, outputStream);
            }
            catch (IOException e) {
                throw new TransformException("Failed to write [ " + outputFile.getAbsolutePath() + " ]", e);
            }
        }
        catch (IOException e) {
            throw new TransformException("Failed to read [ " + inputFile.getAbsolutePath() + " ]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyStream(String inputPath, InputStream inputStream, String outputPath, OutputStream outputStream) throws TransformException {
        Charset charset = this.resourceCharset(inputPath);
        this.getLogger().debug("Zip Charset [ {} ]: {}", (Object)inputPath, (Object)charset);
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream, charset);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream, charset);
            try {
                this.applyZipStream(inputPath, zipInputStream, outputPath, zipOutputStream);
            }
            finally {
                zipOutputStream.finish();
            }
        }
        catch (IOException e) {
            throw new TransformException("Failed to complete output [ " + inputPath + " ]", e);
        }
    }

    protected boolean isDuplicate(String inputName, String inputPath, String outputName, String outputPath, Set<String> seen) {
        if (seen.add(outputName)) {
            return false;
        }
        if (inputName.equals(outputName)) {
            this.getLogger().error("Duplicate entry: Entry [ {} ] of [ {} ] is a duplicate and cannot be written to [ {} ].  Ignoring.", new Object[]{inputName, inputPath, outputPath});
        } else {
            this.getLogger().error("Duplicate entry: Entry [ {} ], initially [ {} ] of [ {} ], is a duplicate and cannot be written to [ {} ].  Ignoring.", new Object[]{outputName, inputName, inputPath, outputPath});
        }
        return true;
    }

    private void applyZipStream(String inputPath, ZipInputStream zipInputStream, String outputPath, ZipOutputStream zipOutputStream) throws TransformException {
        String className = this.getClass().getSimpleName();
        String methodName = "apply";
        Logger useLogger = this.getLogger();
        useLogger.debug("[ {}.{} ] [ {} ]", new Object[]{className, methodName, inputPath});
        byte[] copyBuffer = new byte[65536];
        HashSet<String> seen = new HashSet<String>();
        String prevName = null;
        String inputName = null;
        try {
            ZipEntry inputEntry;
            while ((inputEntry = zipInputStream.getNextEntry()) != null) {
                block31: {
                    try {
                        ByteData outputData;
                        String outputName;
                        inputName = FileUtils.sanitize(inputEntry.getName());
                        int inputLength = Math.toIntExact(inputEntry.getSize());
                        useLogger.debug("[ {}.{} ] Entry [ {} ] Size [ {} ]", new Object[]{className, methodName, inputName, inputLength});
                        Action action = this.selectAction(inputName);
                        if (action == null) {
                            if (this.isDuplicate(inputName, inputPath, inputName, outputPath, seen)) {
                                this.recordDuplicate(action, inputName);
                            } else {
                                this.copy(inputEntry, zipInputStream, inputName, zipOutputStream, copyBuffer);
                                this.recordUnaccepted(inputName);
                            }
                            break block31;
                        }
                        if (!this.selectResource(inputName)) {
                            if (this.isDuplicate(inputName, inputPath, inputName, outputPath, seen)) {
                                this.recordDuplicate(action, inputName);
                            } else {
                                this.copy(inputEntry, zipInputStream, inputName, zipOutputStream, copyBuffer);
                                this.recordUnselected(inputName);
                            }
                            break block31;
                        }
                        if (action.isRenameAction()) {
                            RenameAction renameAction = (RenameAction)action;
                            outputName = renameAction.apply(inputName);
                            if (this.isDuplicate(inputName, inputPath, outputName = FileUtils.sanitize(outputName), outputPath, seen)) {
                                this.recordDuplicate(action, inputName);
                            } else {
                                this.copy(inputEntry, zipInputStream, outputName, zipOutputStream, copyBuffer);
                                this.recordAction(action, inputName);
                            }
                            break block31;
                        }
                        if (action.isArchiveAction()) {
                            ZipActionImpl zipAction = (ZipActionImpl)action;
                            outputName = zipAction.relocateResource(inputName);
                            if (this.isDuplicate(inputName, inputPath, outputName = FileUtils.sanitize(outputName), outputPath, seen)) {
                                this.recordDuplicate(zipAction, inputName);
                            } else {
                                try {
                                    if (inputEntry.getMethod() == 0) {
                                        ByteData inputData = this.collect(inputName, zipInputStream, inputLength);
                                        outputData = zipAction.apply(inputData);
                                        ZipEntry outputEntry = this.createEntry(inputEntry, outputName, outputData);
                                        this.putEntry(zipOutputStream, outputEntry, () -> outputData.writeTo(zipOutputStream));
                                    } else {
                                        ZipEntry outputEntry = this.createEntry(inputEntry, outputName);
                                        String putInputName = inputName;
                                        String putOutputName = outputName;
                                        this.putEntry(zipOutputStream, outputEntry, () -> zipAction.apply(putInputName, zipInputStream, putOutputName, zipOutputStream));
                                    }
                                    this.recordAction(zipAction, inputName);
                                }
                                catch (Throwable th) {
                                    this.recordError(zipAction, inputName, th);
                                }
                            }
                            break block31;
                        }
                        if (!action.isElementAction()) {
                            useLogger.warn("Strange: Unknown action type [ {} ] for [ {} ] in {} ]", new Object[]{action.getClass().getName(), inputName, inputPath});
                            if (this.isDuplicate(inputName, inputPath, inputName, outputPath, seen)) {
                                this.recordDuplicate(action, inputName);
                            } else {
                                this.copy(inputEntry, zipInputStream, inputName, zipOutputStream, copyBuffer);
                                this.recordUnaccepted(inputName);
                            }
                            break block31;
                        }
                        ElementAction elementAction = (ElementAction)action;
                        ByteData inputData = this.collect(inputName, zipInputStream, inputLength);
                        boolean beganWrite = false;
                        try {
                            outputData = elementAction.apply(inputData);
                            String outputName2 = outputData.name();
                            outputName2 = FileUtils.sanitize(outputName2);
                            if (this.isDuplicate(inputName, inputPath, outputName2, outputPath, seen)) {
                                this.recordDuplicate(elementAction, inputName);
                                break block31;
                            }
                            beganWrite = true;
                            if (elementAction.getLastActiveChanges().isContentChanged()) {
                                this.writeModified(inputEntry, inputData, outputData, outputName2, zipOutputStream);
                            } else {
                                this.writeUnmodified(inputEntry, inputData, outputName2, zipOutputStream);
                            }
                            this.recordAction(elementAction, inputName);
                        }
                        catch (Throwable t) {
                            if (!beganWrite) {
                                this.writeUnmodified(inputEntry, inputData, inputName, zipOutputStream);
                            } else {
                                useLogger.error("Write failure of [ {} ] of [ {} ]", (Object)inputName, (Object)inputPath);
                            }
                            this.recordError(action, inputName, t);
                        }
                    }
                    catch (Throwable t) {
                        useLogger.error("Transform failure [ {} ] of [ {} ]", new Object[]{inputName, inputPath, t});
                    }
                }
                prevName = inputName;
                inputName = null;
            }
        }
        catch (IOException e) {
            String message = inputName != null ? "Failure while processing [ " + inputName + " ] from [ " + inputPath + " ]" : (prevName != null ? "Failure after processing [ " + prevName + " ] from [ " + inputPath + " ]" : "Failed to process first entry of [ " + inputPath + " ]");
            throw new TransformException(message, e);
        }
    }

    private void copy(ZipEntry inputEntry, ZipInputStream zipInputStream, String outputName, ZipOutputStream zipOutputStream, byte[] buffer) throws IOException {
        this.getLogger().trace("Copy entry [ {} ] Directory [ {} ] as [ {} ]", new Object[]{inputEntry.getName(), inputEntry.isDirectory(), outputName});
        ZipEntry outputEntry = this.copyEntry(inputEntry, outputName);
        this.putEntry(zipOutputStream, outputEntry, () -> {
            if (!inputEntry.isDirectory()) {
                long bytesWritten = FileUtils.transfer(zipInputStream, zipOutputStream, buffer);
                this.getLogger().trace("Copied [ {} ] bytes to [ {} ]", (Object)bytesWritten, (Object)outputName);
            }
        });
    }

    public void writeUnmodified(ZipEntry inputEntry, ByteData outputData, String outputName, ZipOutputStream zipOutputStream) throws IOException {
        this.getLogger().trace("Write unmodified entry [ {} ] bytes [ {} ]", (Object)outputName, (Object)outputData.length());
        ZipEntry outputEntry = this.copyEntry(inputEntry, outputName);
        this.putEntry(zipOutputStream, outputEntry, () -> outputData.writeTo(zipOutputStream));
    }

    public void writeModified(ZipEntry inputEntry, ByteData inputData, ByteData outputData, String outputName, ZipOutputStream zipOutputStream) throws IOException {
        this.getLogger().trace("Write modified entry [ {} ] bytes [ {} ]", (Object)outputName, (Object)outputData.length());
        ZipEntry outputEntry = this.createEntry(inputEntry, outputName, outputData);
        this.putEntry(zipOutputStream, outputEntry, () -> outputData.writeTo(zipOutputStream));
    }

    private ZipEntry createEntry(ZipEntry inputEntry, String outputName) {
        byte[] inputExtra;
        String inputComment;
        ZipEntry outputEntry = new ZipEntry(outputName);
        int method = inputEntry.getMethod();
        if (method != -1) {
            outputEntry.setMethod(method);
        }
        if ((inputComment = inputEntry.getComment()) != null) {
            outputEntry.setComment(inputComment);
        }
        if ((inputExtra = inputEntry.getExtra()) != null) {
            outputEntry.setExtra(inputExtra);
        }
        return outputEntry;
    }

    private ZipEntry copyEntry(ZipEntry inputEntry, String outputName) {
        FileTime modTime;
        FileTime createTime;
        ZipEntry outputEntry = this.createEntry(inputEntry, outputName);
        if (outputEntry.getMethod() == 0) {
            long crc;
            long cSize;
            long size = inputEntry.getSize();
            if (size >= 0L) {
                outputEntry.setSize(size);
            }
            if ((cSize = inputEntry.getCompressedSize()) >= 0L) {
                outputEntry.setCompressedSize(cSize);
            }
            if ((crc = inputEntry.getCrc()) >= 0L) {
                outputEntry.setCrc(crc);
            }
        }
        outputEntry.setTime(inputEntry.getTime());
        FileTime lastTime = inputEntry.getLastAccessTime();
        if (lastTime != null) {
            outputEntry.setLastAccessTime(lastTime);
        }
        if ((createTime = inputEntry.getCreationTime()) != null) {
            outputEntry.setCreationTime(createTime);
        }
        if ((modTime = inputEntry.getLastModifiedTime()) != null) {
            outputEntry.setLastModifiedTime(modTime);
        }
        return outputEntry;
    }

    private ZipEntry createEntry(ZipEntry inputEntry, String outputName, ByteData outputData) {
        ZipEntry outputEntry = this.createEntry(inputEntry, outputName);
        if (outputEntry.getMethod() == 0) {
            int length = outputData.length();
            outputEntry.setSize(length);
            outputEntry.setCompressedSize(length);
            CRC32 crc = new CRC32();
            crc.update(outputData.buffer());
            outputEntry.setCrc(crc.getValue());
        }
        return outputEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEntry(ZipOutputStream zipOutputStream, ZipEntry outputEntry, TransformerRunnable populator) throws IOException, TransformException {
        zipOutputStream.putNextEntry(outputEntry);
        try {
            populator.run();
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    @FunctionalInterface
    private static interface TransformerRunnable {
        public void run() throws IOException, TransformException;
    }
}

