/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.filevault.runtime;

import io.quarkiverse.filevault.runtime.FileVaultConfig;
import io.quarkiverse.filevault.runtime.encrypt.EncryptionUtil;
import io.quarkus.credentials.CredentialsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.jboss.logging.Logger;

@Named(value="quarkus.file.vault")
@ApplicationScoped
public class FileVaultCredentialsProvider
implements CredentialsProvider {
    static String BASE_PROVIDER_NAME = "quarkus.file.vault.provider";
    static String CERTIFICATE_PROPERTY = "certificate";
    private static String DEFAULT_KEY_STORE_FILE = "passwords.p12";
    private static final Logger LOGGER = Logger.getLogger((String)FileVaultCredentialsProvider.class.getName());
    private Map<String, Map<String, KeyStoreEntry>> storeProperties = new HashMap<String, Map<String, KeyStoreEntry>>();
    private Map<String, String> defaultAliases = new HashMap<String, String>();
    private boolean setAliasAsUser;

    public FileVaultCredentialsProvider(FileVaultConfig config) {
        for (Map.Entry<String, Map<String, String>> store : config.provider.entrySet()) {
            this.storeProperties.put(store.getKey(), FileVaultCredentialsProvider.readKeyStore(store.getValue()));
            if (!store.getValue().containsKey("alias")) continue;
            this.defaultAliases.put(store.getKey(), store.getValue().get("alias"));
        }
        this.setAliasAsUser = config.setAliasAsUser;
    }

    public Map<String, String> getCredentials(String credentialsProviderName) {
        String keyStoreAlias;
        if (!credentialsProviderName.startsWith(BASE_PROVIDER_NAME)) {
            LOGGER.tracef("Unrecognized provider name: %s", (Object)credentialsProviderName);
            return Map.of();
        }
        String[] nameParts = credentialsProviderName.split("\\.");
        if (nameParts.length != 5 && nameParts.length != 6) {
            LOGGER.warnf("Incorrect provider name format: %s,use 'quarkus.file.vault.provider.<storename>' or 'quarkus.file.vault.provider.<storename>.<alias>' format", (Object)credentialsProviderName);
            return Map.of();
        }
        String keyStoreName = nameParts[4];
        Map<String, KeyStoreEntry> keyStoreProperties = this.storeProperties.get(keyStoreName);
        if (keyStoreProperties == null) {
            LOGGER.warnf("Key store %s properties have not been found", (Object)keyStoreName);
            return Map.of();
        }
        HashMap<String, String> credProviderProperties = new HashMap<String, String>();
        String string = keyStoreAlias = nameParts.length == 6 ? nameParts[5] : this.defaultAliases.get(keyStoreName);
        if (keyStoreAlias == null) {
            for (Map.Entry<String, KeyStoreEntry> storeEntry : keyStoreProperties.entrySet()) {
                credProviderProperties.put(storeEntry.getKey(), storeEntry.getValue().value);
            }
        } else if (keyStoreProperties.containsKey(keyStoreAlias)) {
            KeyStoreEntry entry = keyStoreProperties.get(keyStoreAlias);
            String property = entry.cert ? CERTIFICATE_PROPERTY : "password";
            credProviderProperties.put(property, entry.value);
            if (this.setAliasAsUser) {
                credProviderProperties.put("user", keyStoreAlias);
            }
        } else {
            LOGGER.warnf("Key store %s values do not have a %s value", (Object)keyStoreName, (Object)keyStoreAlias);
        }
        return credProviderProperties;
    }

    private static Map<String, KeyStoreEntry> readKeyStore(Map<String, String> keyStoreProps) {
        String keyStoreFile = keyStoreProps.getOrDefault("path", DEFAULT_KEY_STORE_FILE);
        String keyStoreSecret = keyStoreProps.get("secret");
        if (keyStoreSecret != null) {
            String encryptionKey = keyStoreProps.get("encryption-key");
            if (encryptionKey != null) {
                String decodedEncryptionKey = new String(Base64.getUrlDecoder().decode(encryptionKey), StandardCharsets.UTF_8);
                keyStoreSecret = EncryptionUtil.decrypt(keyStoreSecret, decodedEncryptionKey);
            }
        } else {
            LOGGER.errorf("Keystore %s secret is not configured", (Object)keyStoreFile);
            throw new RuntimeException();
        }
        URL keyStoreFileUrl = null;
        keyStoreFileUrl = Thread.currentThread().getContextClassLoader().getResource(keyStoreFile);
        if (keyStoreFileUrl != null) {
            return FileVaultCredentialsProvider.readKeyStore(keyStoreFileUrl, keyStoreSecret);
        }
        Path filePath = Paths.get(keyStoreFile, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                return FileVaultCredentialsProvider.readKeyStore(filePath.toUri().toURL(), keyStoreSecret);
            }
            catch (MalformedURLException e) {
                LOGGER.errorf("Keystore %s location is not a valid URL", (Object)keyStoreFile);
                throw new RuntimeException(e);
            }
        }
        LOGGER.errorf("Keystore %s can not be found on the classpath and the file system", (Object)keyStoreFile);
        throw new RuntimeException();
    }

    private static Map<String, KeyStoreEntry> readKeyStore(URL keyStoreFileUrl, String keyStoreSecret) {
        HashMap<String, KeyStoreEntry> hashMap;
        block10: {
            InputStream fis = keyStoreFileUrl.openStream();
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(fis, keyStoreSecret.toCharArray());
                HashMap<String, KeyStoreEntry> properties = new HashMap<String, KeyStoreEntry>();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    KeyStoreEntry storeEntry = FileVaultCredentialsProvider.loadStoreEntry(keyStore, keyStoreSecret, alias);
                    if (storeEntry == null) continue;
                    properties.put(alias, storeEntry);
                }
                hashMap = properties;
                if (fis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.errorf("Keystore %s can not be loaded", (Object)keyStoreFileUrl.toString());
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    LOGGER.errorf("Keystore %s entries can not be loaded", (Object)keyStoreFileUrl.toString());
                    throw new RuntimeException(e);
                }
            }
            fis.close();
        }
        return hashMap;
    }

    private static KeyStoreEntry loadStoreEntry(KeyStore keyStore, String keyStoreSecret, String keyAlias) throws Exception {
        KeyStore.Entry entry = keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyStoreSecret.toCharArray()));
        if (entry instanceof KeyStore.SecretKeyEntry) {
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            return new KeyStoreEntry(new String(secretKey.getEncoded(), "UTF-8"));
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            Certificate[] certChain = keyStore.getCertificateChain(keyAlias);
            if (certChain != null && certChain.length > 0) {
                return new KeyStoreEntry(new String(certChain[0].getEncoded(), StandardCharsets.ISO_8859_1), true);
            }
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            return new KeyStoreEntry(new String(((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate().getEncoded(), StandardCharsets.ISO_8859_1), true);
        }
        LOGGER.tracef("%s entry type %s is not supported", (Object)keyAlias, (Object)entry.getClass().getName());
        return null;
    }

    private static class KeyStoreEntry {
        String value;
        boolean cert;

        KeyStoreEntry(String value) {
            this.value = value;
        }

        KeyStoreEntry(String value, boolean cert) {
            this.value = value;
            this.cert = cert;
        }
    }
}

