/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.flyway.FlywayCallbacksLocator;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.FlywayRecorder;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.extensibility.Plugin;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class FlywayProcessor {
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String JAR_APPLICATION_MIGRATIONS_PROTOCOL = "jar";
    private static final String FILE_APPLICATION_MIGRATIONS_PROTOCOL = "file";
    private static final String FLYWAY_BEAN_NAME_PREFIX = "flyway_";
    private static final DotName JAVA_MIGRATION = DotName.createSimple((String)JavaMigration.class.getName());
    private static final Logger LOGGER = Logger.getLogger(FlywayProcessor.class);
    FlywayBuildTimeConfig flywayBuildConfig;

    FlywayProcessor() {
    }

    @BuildStep
    IndexDependencyBuildItem indexFlyway() {
        return new IndexDependencyBuildItem("org.flywaydb", "flyway-core");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    MigrationStateBuildItem build(BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentProducer, FlywayRecorder recorder, RecorderContext context, CombinedIndexBuildItem combinedIndexBuildItem, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) throws Exception {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.FLYWAY));
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        HashMap<String, Object> applicationMigrationsToDs = new HashMap<String, Object>();
        for (String i : dataSourceNames) {
            Collection<String> migrationLocations = this.discoverApplicationMigrations(this.flywayBuildConfig.getConfigForDataSourceName((String)i).locations);
            applicationMigrationsToDs.put(i, migrationLocations);
        }
        HashSet<String> datasourcesWithMigrations = new HashSet<String>();
        HashSet<String> datasourcesWithoutMigrations = new HashSet<String>();
        for (Map.Entry entry : applicationMigrationsToDs.entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) {
                datasourcesWithoutMigrations.add((String)entry.getKey());
                continue;
            }
            datasourcesWithMigrations.add((String)entry.getKey());
        }
        Collection applicationMigrations = applicationMigrationsToDs.values().stream().collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
        for (String applicationMigration : applicationMigrations) {
            Location applicationMigrationLocation = new Location(applicationMigration);
            String applicationMigrationPath = applicationMigrationLocation.getPath();
            if (applicationMigrationPath == null) continue;
            hotDeploymentProducer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(applicationMigrationPath));
        }
        recorder.setApplicationMigrationFiles(applicationMigrations);
        HashSet<Class<? extends JavaMigration>> hashSet = new HashSet<Class<? extends JavaMigration>>();
        this.addJavaMigrations(combinedIndexBuildItem.getIndex().getAllKnownImplementors(JAVA_MIGRATION), context, reflectiveClassProducer, hashSet);
        recorder.setApplicationMigrationClasses(hashSet);
        Map<String, Collection<Callback>> callbacks = FlywayCallbacksLocator.with(dataSourceNames, this.flywayBuildConfig, combinedIndexBuildItem, reflectiveClassProducer).getCallbacks();
        recorder.setApplicationCallbackClasses(callbacks);
        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(applicationMigrations.toArray(new String[0])));
        return new MigrationStateBuildItem(datasourcesWithMigrations, datasourcesWithoutMigrations);
    }

    private void addJavaMigrations(Collection<ClassInfo> candidates, RecorderContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, Set<Class<? extends JavaMigration>> javaMigrationClasses) {
        for (ClassInfo javaMigration : candidates) {
            if (Modifier.isAbstract(javaMigration.flags())) continue;
            javaMigrationClasses.add(context.classProxy(javaMigration.name().toString()));
            reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{javaMigration.name().toString()}));
        }
    }

    @BuildStep
    @Produce(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Consume(value=LoggingSetupBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBeans(FlywayRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, List<JdbcInitialSQLGeneratorBuildItem> sqlGeneratorBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, MigrationStateBuildItem migrationsBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{FlywayContainerProducer.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(FlywayDataSource.class).build());
        recorder.resetFlywayContainers();
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            boolean hasMigrations = migrationsBuildItem.hasMigrations.contains(dataSourceName);
            boolean createPossible = false;
            if (!hasMigrations) {
                createPossible = sqlGeneratorBuildItems.stream().anyMatch(s -> s.getDatabaseName().equals(dataSourceName));
            }
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Flyway.class).scope(Dependent.class)).setRuntimeInit().unremovable()).supplier(recorder.flywaySupplier(dataSourceName, hasMigrations, createPossible));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                configurator.addQualifier(Default.class);
            } else {
                String beanName = FLYWAY_BEAN_NAME_PREFIX + dataSourceName;
                configurator.name(beanName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                configurator.addQualifier().annotation(FlywayDataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
    }

    @BuildStep
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem startActions(FlywayRecorder recorder, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem, MigrationStateBuildItem migrationsBuildItem) {
        recorder.doStartActions();
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(migrationsBuildItem.hasMigrations));
        return new ServiceStartBuildItem("flyway");
    }

    private Set<String> getDataSourceNames(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) {
        HashSet<String> result = new HashSet<String>(jdbcDataSourceBuildItems.size());
        for (JdbcDataSourceBuildItem item : jdbcDataSourceBuildItems) {
            result.add(item.getName());
        }
        return result;
    }

    private Collection<String> discoverApplicationMigrations(Collection<String> locations) throws IOException {
        LinkedHashSet<String> applicationMigrationResources = new LinkedHashSet<String>();
        for (String location : locations) {
            if ((location = this.normalizeLocation(location)).startsWith("filesystem:")) {
                applicationMigrationResources.add(location);
                continue;
            }
            String finalLocation = location;
            ClassPathUtils.consumeAsPaths((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)location, path -> {
                Set<String> applicationMigrations = null;
                try {
                    applicationMigrations = this.getApplicationMigrationsFromPath(finalLocation, (Path)path);
                }
                catch (IOException e) {
                    LOGGER.warnv((Throwable)e, "Can't process files in path %s", path);
                }
                if (applicationMigrations != null) {
                    applicationMigrationResources.addAll(applicationMigrations);
                }
            });
        }
        return applicationMigrationResources;
    }

    private String normalizeLocation(String location) {
        if (location == null) {
            throw new IllegalStateException("Flyway migration location may not be null.");
        }
        if (((String)location).startsWith("classpath:") && ((String)(location = ((String)location).substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1))).startsWith("/")) {
            location = ((String)location).substring(1);
        }
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }

    private Set<String> getApplicationMigrationsFromPath(String location, Path rootPath) throws IOException {
        try (Stream<Path> pathStream = Files.walk(rootPath, new FileVisitOption[0]);){
            Set<String> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> Paths.get(location, rootPath.relativize((Path)it).toString()).normalize().toString()).map(it -> it.replace('\\', '/')).peek(it -> LOGGER.debugf("Discovered path: %s", it)).collect(Collectors.toSet());
            return set;
        }
    }

    @BuildStep
    public RuntimeReinitializedClassBuildItem reinitInsertRowLock() {
        return new RuntimeReinitializedClassBuildItem("org.flywaydb.core.internal.database.InsertRowLock");
    }

    @BuildStep
    public NativeImageResourceBuildItem resources() {
        return new NativeImageResourceBuildItem(new String[]{"org/flywaydb/database/version.txt"});
    }

    @BuildStep
    public ServiceProviderBuildItem flywayPlugins() {
        return ServiceProviderBuildItem.allProvidersFromClassPath((String)Plugin.class.getName());
    }

    public static final class MigrationStateBuildItem
    extends SimpleBuildItem {
        final Set<String> hasMigrations;
        final Set<String> missingMigrations;

        MigrationStateBuildItem(Set<String> hasMigrations, Set<String> missingMigrations) {
            this.hasMigrations = hasMigrations;
            this.missingMigrations = missingMigrations;
        }
    }
}

