/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime.util;

import io.quarkus.scheduler.Scheduled;
import io.smallrye.common.expression.Expression;
import io.smallrye.common.expression.ResolveContext;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class SchedulerUtils {
    private static final String DELAYED = "delayed";
    private static final String EVERY = "every";
    private static final String OVERDUE_GRACE_PERIOD = "overdueGracePeriod";

    private SchedulerUtils() {
    }

    public static long parseDelayedAsMillis(Scheduled scheduled) {
        String value = SchedulerUtils.lookUpPropertyValue(scheduled.delayed());
        return SchedulerUtils.parseDurationAsMillis(scheduled, value, DELAYED);
    }

    public static OptionalLong parseEveryAsMillis(Scheduled scheduled) {
        String value = SchedulerUtils.lookUpPropertyValue(scheduled.every());
        OptionalLong optionalMillis = OptionalLong.empty();
        if (!SchedulerUtils.isOff(value)) {
            optionalMillis = OptionalLong.of(SchedulerUtils.parseDurationAsMillis(scheduled, value, EVERY));
        }
        return optionalMillis;
    }

    public static Duration parseOverdueGracePeriod(Scheduled scheduled, Duration defaultDuration) {
        String value = SchedulerUtils.lookUpPropertyValue(scheduled.overdueGracePeriod());
        if (value.isEmpty()) {
            return defaultDuration;
        }
        return SchedulerUtils.parseDuration(scheduled, value, OVERDUE_GRACE_PERIOD);
    }

    public static boolean isOff(String value) {
        return value != null && (value.equalsIgnoreCase("off") || value.equalsIgnoreCase("disabled"));
    }

    public static String lookUpPropertyValue(String propertyValue) {
        String value = propertyValue.stripLeading();
        if (!value.isEmpty() && SchedulerUtils.isConfigValue(value)) {
            value = SchedulerUtils.resolvePropertyExpression(SchedulerUtils.adjustExpressionSyntax(value));
        }
        return value;
    }

    public static boolean isConfigValue(String val) {
        return SchedulerUtils.isSimpleConfigValue(val) || SchedulerUtils.isConfigExpression(val);
    }

    private static boolean isSimpleConfigValue(String val) {
        return (val = val.trim()).startsWith("{") && val.endsWith("}");
    }

    private static String adjustExpressionSyntax(String val) {
        if (SchedulerUtils.isSimpleConfigValue(val)) {
            return "$" + val;
        }
        return val;
    }

    private static String resolvePropertyExpression(final String expr) {
        ClassLoader cl = SchedulerUtils.class.getClassLoader();
        final Config config = ConfigProviderResolver.instance().getConfig(cl);
        Expression expression = Expression.compile((String)expr, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM});
        String expanded = expression.evaluate((BiConsumer)new BiConsumer<ResolveContext<RuntimeException>, StringBuilder>(){

            @Override
            public void accept(ResolveContext<RuntimeException> resolveContext, StringBuilder stringBuilder) {
                Optional resolve = config.getOptionalValue(resolveContext.getKey(), String.class);
                if (resolve.isPresent()) {
                    stringBuilder.append((String)resolve.get());
                } else if (resolveContext.hasDefault()) {
                    resolveContext.expandDefault();
                } else {
                    throw new NoSuchElementException(String.format("Could not expand value %s in property %s", resolveContext.getKey(), expr));
                }
            }
        });
        return expanded;
    }

    private static boolean isConfigExpression(String val) {
        if (val == null) {
            return false;
        }
        int exprStart = val.indexOf("${");
        int exprEnd = -1;
        if (exprStart >= 0) {
            exprEnd = val.indexOf(125, exprStart + 2);
        }
        return exprEnd > 0;
    }

    private static long parseDurationAsMillis(Scheduled scheduled, String value, String memberName) {
        return Math.abs(SchedulerUtils.parseDuration(scheduled, value, memberName).toMillis());
    }

    private static Duration parseDuration(Scheduled scheduled, String value, String memberName) {
        if (Character.isDigit(((String)value).charAt(0))) {
            value = "PT" + (String)value;
        }
        try {
            return Duration.parse((CharSequence)value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid " + memberName + "() expression on: " + scheduled, e);
        }
    }
}

