/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.interceptor;

import io.quarkus.narayana.jta.runtime.test.TestTransactionCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;

public class TestTransactionInterceptor {
    static final List<TestTransactionCallback> CALLBACKS;
    @Inject
    public UserTransaction userTransaction;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (this.userTransaction.getStatus() != 6) {
            return context.proceed();
        }
        Throwable caught = null;
        try {
            this.userTransaction.begin();
            for (TestTransactionCallback i : CALLBACKS) {
                i.postBegin();
            }
            Object result = context.proceed();
            for (TestTransactionCallback i : CALLBACKS) {
                i.preRollback();
            }
            Object object = result;
            return object;
        }
        catch (Error | Exception e) {
            caught = e;
            throw e;
        }
        finally {
            if (caught == null) {
                this.userTransaction.rollback();
            } else {
                try {
                    this.userTransaction.rollback();
                }
                catch (Exception e) {
                    caught.addSuppressed(e);
                }
            }
        }
    }

    static {
        ArrayList<TestTransactionCallback> callbacks = new ArrayList<TestTransactionCallback>();
        for (TestTransactionCallback i : ServiceLoader.load(TestTransactionCallback.class)) {
            callbacks.add(i);
        }
        CALLBACKS = callbacks;
    }
}

