/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.InjectionPointInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class UnusedBeans {
    private static final Logger LOG = Logger.getLogger(UnusedBeans.class);

    private UnusedBeans() {
    }

    static Set<BeanInfo> findRemovableBeans(Collection<BeanInfo> beans, Collection<InjectionPointInfo> injectionPoints, Set<BeanInfo> declaresObserver, List<Predicate<BeanInfo>> allUnusedExclusions) {
        HashSet<BeanInfo> removableBeans = new HashSet<BeanInfo>();
        HashSet<BeanInfo> unusedProducers = new HashSet<BeanInfo>();
        HashSet<BeanInfo> unusedButDeclaresProducer = new HashSet<BeanInfo>();
        List producers = beans.stream().filter(b -> b.isProducerMethod() || b.isProducerField()).collect(Collectors.toList());
        List instanceInjectionPoints = injectionPoints.stream().filter(InjectionPointInfo::isProgrammaticLookup).collect(Collectors.toList());
        Set injected = injectionPoints.stream().filter(Predicate.not(InjectionPointInfo::isDelegate).and(InjectionPointInfo::hasResolvedBean)).map(InjectionPointInfo::getResolvedBean).collect(Collectors.toSet());
        Set declaresProducer = producers.stream().map(BeanInfo::getDeclaringBean).collect(Collectors.toSet());
        block0: for (BeanInfo bean : beans) {
            if (bean.getName() != null) {
                LOG.debugf("Unremovable - named: %s", (Object)bean);
                continue;
            }
            if (!bean.isRemovable()) {
                LOG.debugf("Unremovable - unremovable synthetic: %s", (Object)bean);
                continue;
            }
            for (Predicate<BeanInfo> exclusion : allUnusedExclusions) {
                if (!exclusion.test(bean)) continue;
                LOG.debugf("Unremovable - excluded by %s: %s", (Object)exclusion.toString(), (Object)bean);
                continue block0;
            }
            if (injected.contains(bean)) {
                LOG.debugf("Unremovable - injected: %s", (Object)bean);
                continue;
            }
            if (declaresObserver.contains(bean)) {
                LOG.debugf("Unremovable - declares observer: %s", (Object)bean);
                continue;
            }
            for (InjectionPointInfo injectionPoint : instanceInjectionPoints) {
                if (!Beans.hasQualifiers(bean, injectionPoint.getRequiredQualifiers()) || !bean.getDeployment().getBeanResolver().matchesType(bean, (Type)injectionPoint.getType().asParameterizedType().arguments().get(0))) continue;
                LOG.debugf("Unremovable - programmatic lookup: %s", (Object)bean);
                continue block0;
            }
            if (declaresProducer.contains(bean)) {
                unusedButDeclaresProducer.add(bean);
                continue;
            }
            if (bean.isProducerField() || bean.isProducerMethod()) {
                unusedProducers.add(bean);
            }
            removableBeans.add(bean);
        }
        if (!unusedProducers.isEmpty()) {
            Map<BeanInfo, List<BeanInfo>> declaringMap = producers.stream().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
            for (Map.Entry<BeanInfo, List<BeanInfo>> entry : declaringMap.entrySet()) {
                BeanInfo declaringBean = entry.getKey();
                if (unusedButDeclaresProducer.contains(declaringBean) && unusedProducers.containsAll((Collection)entry.getValue())) {
                    removableBeans.add(declaringBean);
                    continue;
                }
                LOG.debugf("Unremovable - declares producer: %s", (Object)declaringBean);
            }
        }
        return removableBeans;
    }
}

