/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.processmigration.model.Execution;
import org.kie.processmigration.model.MigrationDefinition;

@Entity
@Table(name="migrations")
public class Migration
extends PanacheEntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="migrationIdSeq")
    @SequenceGenerator(name="migrationIdSeq", sequenceName="MIGRATION_ID_SEQ")
    private Long id;
    @Embedded
    private MigrationDefinition definition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="created_at")
    private Instant createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="finished_at")
    private Instant finishedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="started_at")
    private Instant startedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="cancelled_at")
    private Instant cancelledAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Column(name="error_message")
    @Lob
    private String errorMessage;
    private Execution.ExecutionStatus status;

    public Migration() {
    }

    public Migration(MigrationDefinition definition) {
        Instant now;
        this.definition = definition;
        this.createdAt = now = Instant.now();
        this.status = definition.getExecution() != null && Execution.ExecutionType.ASYNC.equals((Object)definition.getExecution().getType()) && definition.getExecution().getScheduledStartTime() != null && now.isBefore(definition.getExecution().getScheduledStartTime()) ? Execution.ExecutionStatus.SCHEDULED : Execution.ExecutionStatus.CREATED;
    }

    public Migration start() {
        this.startedAt = Instant.now();
        this.status = Execution.ExecutionStatus.STARTED;
        return this;
    }

    public Migration complete(Boolean hasErrors) {
        this.finishedAt = Instant.now();
        this.status = Boolean.TRUE.equals(hasErrors) ? Execution.ExecutionStatus.FAILED : Execution.ExecutionStatus.COMPLETED;
        return this;
    }

    public Migration cancel() {
        this.cancelledAt = Instant.now();
        this.status = Execution.ExecutionStatus.CANCELLED;
        return this;
    }

    public Migration fail(Exception e) {
        this.finishedAt = Instant.now();
        this.status = Execution.ExecutionStatus.FAILED;
        this.errorMessage = e.toString();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Migration)) {
            return false;
        }
        Migration other = (Migration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MigrationDefinition this$definition = this.getDefinition();
        MigrationDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$finishedAt = this.getFinishedAt();
        Instant other$finishedAt = other.getFinishedAt();
        if (this$finishedAt == null ? other$finishedAt != null : !((Object)this$finishedAt).equals(other$finishedAt)) {
            return false;
        }
        Instant this$startedAt = this.getStartedAt();
        Instant other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        Instant this$cancelledAt = this.getCancelledAt();
        Instant other$cancelledAt = other.getCancelledAt();
        if (this$cancelledAt == null ? other$cancelledAt != null : !((Object)this$cancelledAt).equals(other$cancelledAt)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Execution.ExecutionStatus this$status = this.getStatus();
        Execution.ExecutionStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Migration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MigrationDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $finishedAt = this.getFinishedAt();
        result = result * 59 + ($finishedAt == null ? 43 : ((Object)$finishedAt).hashCode());
        Instant $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        Instant $cancelledAt = this.getCancelledAt();
        result = result * 59 + ($cancelledAt == null ? 43 : ((Object)$cancelledAt).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Execution.ExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "Migration(id=" + this.getId() + ", definition=" + this.getDefinition() + ", createdAt=" + this.getCreatedAt() + ", finishedAt=" + this.getFinishedAt() + ", startedAt=" + this.getStartedAt() + ", cancelledAt=" + this.getCancelledAt() + ", errorMessage=" + this.getErrorMessage() + ", status=" + this.getStatus() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public MigrationDefinition getDefinition() {
        return this.definition;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getFinishedAt() {
        return this.finishedAt;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public Instant getCancelledAt() {
        return this.cancelledAt;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Execution.ExecutionStatus getStatus() {
        return this.status;
    }

    public Migration setId(Long id) {
        this.id = id;
        return this;
    }

    public Migration setDefinition(MigrationDefinition definition) {
        this.definition = definition;
        return this;
    }

    public Migration setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Migration setFinishedAt(Instant finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    public Migration setStartedAt(Instant startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    public Migration setCancelledAt(Instant cancelledAt) {
        this.cancelledAt = cancelledAt;
        return this;
    }

    public Migration setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Migration setStatus(Execution.ExecutionStatus status) {
        this.status = status;
        return this;
    }
}

