/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.instance.TaskSummaryList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="process-instance")
public class ProcessInstance {
    @XmlElement(name="process-instance-id")
    private Long id;
    @XmlElement(name="process-id")
    private String processId;
    @XmlElement(name="process-name")
    private String processName;
    @XmlElement(name="process-version")
    private String processVersion;
    @XmlElement(name="process-instance-state")
    private Integer state;
    @XmlElement(name="container-id")
    private String containerId;
    @XmlElement(name="initiator")
    private String initiator;
    @XmlElement(name="start-date")
    private Date date;
    @XmlElement(name="process-instance-desc")
    private String processInstanceDescription;
    @XmlElement(name="correlation-key")
    private String correlationKey;
    @XmlElement(name="parent-instance-id")
    private Long parentId;
    @XmlElement(name="active-user-tasks")
    private TaskSummaryList activeUserTasks;
    @XmlElement(name="process-instance-variables")
    private Map<String, Object> variables;

    public static Builder builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getProcessInstanceDescription() {
        return this.processInstanceDescription;
    }

    public void setProcessInstanceDescription(String processInstanceDescription) {
        this.processInstanceDescription = processInstanceDescription;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public TaskSummaryList getActiveUserTasks() {
        return this.activeUserTasks;
    }

    public void setActiveUserTasks(TaskSummaryList activeUserTasks) {
        this.activeUserTasks = activeUserTasks;
    }

    public String toString() {
        return "ProcessInstance{id=" + this.id + ", processId='" + this.processId + '\'' + ", processName='" + this.processName + '\'' + ", state=" + this.state + ", containerId='" + this.containerId + '\'' + ", correlationKey='" + this.correlationKey + '\'' + '}';
    }

    public static class Builder {
        private ProcessInstance processInstance = new ProcessInstance();

        public ProcessInstance build() {
            return this.processInstance;
        }

        public Builder id(Long id) {
            this.processInstance.setId(id);
            return this;
        }

        public Builder processId(String processId) {
            this.processInstance.setProcessId(processId);
            return this;
        }

        public Builder processName(String processName) {
            this.processInstance.setProcessName(processName);
            return this;
        }

        public Builder processVersion(String processVersion) {
            this.processInstance.setProcessVersion(processVersion);
            return this;
        }

        public Builder state(Integer state) {
            this.processInstance.setState(state);
            return this;
        }

        public Builder containerId(String containerId) {
            this.processInstance.setContainerId(containerId);
            return this;
        }

        public Builder initiator(String initiator) {
            this.processInstance.setInitiator(initiator);
            return this;
        }

        public Builder date(Date date) {
            this.processInstance.setDate(date == null ? date : new Date(date.getTime()));
            return this;
        }

        public Builder processInstanceDescription(String description) {
            this.processInstance.setProcessInstanceDescription(description);
            return this;
        }

        public Builder correlationKey(String correlationKey) {
            this.processInstance.setCorrelationKey(correlationKey);
            return this;
        }

        public Builder parentInstanceId(Long parentInstanceId) {
            this.processInstance.setParentId(parentInstanceId);
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.processInstance.setVariables(variables);
            return this;
        }

        public Builder activeUserTasks(TaskSummaryList activeUserTasks) {
            this.processInstance.setActiveUserTasks(activeUserTasks);
            return this;
        }
    }
}

