/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.ReleaseIdFilter;

@RunWith(value=Parameterized.class)
public class MarshallingRoundTripTest {
    @Parameterized.Parameter(value=0)
    public Object testObject;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{MarshallingRoundTripTest.createKieContainerResourceFilter()}, {MarshallingRoundTripTest.createReleaseIdFilter()}, {MarshallingRoundTripTest.createKieContainerResourceFilter()}, {MarshallingRoundTripTest.createListContainersCommand()}, {MarshallingRoundTripTest.createCommandScript()}};
        return Arrays.asList(data);
    }

    private static KieContainerStatusFilter createKieContainerStatusFilter() {
        return new KieContainerStatusFilter();
    }

    private static ReleaseIdFilter createReleaseIdFilter() {
        return new ReleaseIdFilter("group", "artifact", "version");
    }

    private static KieContainerResourceFilter createKieContainerResourceFilter() {
        return new KieContainerResourceFilter(MarshallingRoundTripTest.createReleaseIdFilter(), MarshallingRoundTripTest.createKieContainerStatusFilter());
    }

    private static ListContainersCommand createListContainersCommand() {
        return new ListContainersCommand(MarshallingRoundTripTest.createKieContainerResourceFilter());
    }

    private static DisposeContainerCommand createDisposeContainerCommand() {
        return new DisposeContainerCommand("some-container-id");
    }

    private static CommandScript createCommandScript() {
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(MarshallingRoundTripTest.createListContainersCommand());
        commands.add(MarshallingRoundTripTest.createDisposeContainerCommand());
        return new CommandScript(commands);
    }

    @Test
    public void testJaxb() {
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, this.testObject);
    }

    @Test
    public void testXStream() {
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, this.testObject);
    }

    @Test
    public void testJSON() {
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, this.testObject);
    }

    private void verifyMarshallingRoundTrip(Marshaller marshaller, Object inputObject) {
        String rawContent = marshaller.marshall(inputObject);
        Object testObjectAfterMarshallingTurnAround = marshaller.unmarshall(rawContent, inputObject.getClass());
        Assertions.assertThat((Object)inputObject).isEqualTo(testObjectAfterMarshallingTurnAround);
    }
}

