/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dmn-message")
public class DMNMessageKS
implements DMNMessage {
    @XmlElement(name="dmn-message-severity")
    private DMNMessageSeverityKS severity;
    @XmlElement(name="message")
    private String message;
    @XmlElement(name="source-id")
    private String sourceId;

    public static DMNMessageKS of(DMNMessage value) {
        DMNMessageKS res = new DMNMessageKS();
        res.severity = DMNMessageSeverityKS.of(value.getSeverity());
        res.message = value.getMessage();
        res.sourceId = value.getSourceId();
        return res;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity.asSeverity();
    }

    public String getMessage() {
        return this.message;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Throwable getException() {
        throw new UnsupportedOperationException();
    }

    public FEELEvent getFeelEvent() {
        throw new UnsupportedOperationException();
    }

    public Object getSourceReference() {
        throw new UnsupportedOperationException();
    }

    public static enum DMNMessageSeverityKS {
        TRACE,
        INFO,
        WARN,
        ERROR;


        public static DMNMessageSeverityKS of(DMNMessage.Severity value) {
            switch (value) {
                case ERROR: {
                    return ERROR;
                }
                case INFO: {
                    return INFO;
                }
                case TRACE: {
                    return TRACE;
                }
                case WARN: {
                    return WARN;
                }
            }
            return ERROR;
        }

        public DMNMessage.Severity asSeverity() {
            switch (this) {
                case ERROR: {
                    return DMNMessage.Severity.ERROR;
                }
                case INFO: {
                    return DMNMessage.Severity.INFO;
                }
                case TRACE: {
                    return DMNMessage.Severity.TRACE;
                }
                case WARN: {
                    return DMNMessage.Severity.WARN;
                }
            }
            return DMNMessage.Severity.ERROR;
        }
    }
}

