/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.xstream;

import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.marshalling.objects.AnotherMessage;
import org.kie.server.api.marshalling.objects.Message;
import org.kie.server.api.marshalling.objects.Top;
import org.kie.server.api.marshalling.xstream.KieServerTypePermission;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.admin.EmailNotification;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.dmn.DMNModelInfo;

public class KieServerTypePermissionTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.xstream.enabled.packages");
    }

    @Test
    public void testDefaultAcceptableClasses() {
        KieServerTypePermission permission = new KieServerTypePermission(new HashSet());
        Assert.assertTrue((boolean)permission.allows(KieContainerResource.class));
        Assert.assertTrue((boolean)permission.allows(ProcessDefinition.class));
        Assert.assertTrue((boolean)permission.allows(EmailNotification.class));
        Assert.assertTrue((boolean)permission.allows(CaseDefinition.class));
        Assert.assertTrue((boolean)permission.allows(DMNModelInfo.class));
    }

    @Test
    public void testDefaultForbiddenClasses() {
        KieServerTypePermission permission = new KieServerTypePermission(new HashSet());
        Assert.assertFalse((boolean)permission.allows(Top.class));
    }

    @Test
    public void testExplicitlyGivenClasses() {
        HashSet<Class<Top>> classes = new HashSet<Class<Top>>();
        classes.add(Top.class);
        KieServerTypePermission permission = new KieServerTypePermission(classes);
        Assert.assertTrue((boolean)permission.allows(Top.class));
    }

    @Test
    public void testSystemPropertyGivenClasses() {
        System.setProperty("org.kie.server.xstream.enabled.packages", "org.kie.server.api.marshalling.objects.Top,org.kie.server.api.marshalling.objects.Message");
        HashSet classes = new HashSet();
        KieServerTypePermission permission = new KieServerTypePermission(classes);
        Assert.assertTrue((boolean)permission.allows(Top.class));
        Assert.assertTrue((boolean)permission.allows(Message.class));
        Assert.assertFalse((boolean)permission.allows(AnotherMessage.class));
    }
}

