/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="error-info-instance")
public class ErrorInfoInstance {
    @XmlElement(name="error-instance-id")
    private Long id;
    @XmlElement(name="request-instance-id")
    private Long requestInfoId;
    @XmlElement(name="error-message")
    private String message;
    @XmlElement(name="error-stacktrace")
    private String stacktrace;
    @XmlElement(name="error-date")
    private Date errorDate;

    public static Builder builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRequestInfoId() {
        return this.requestInfoId;
    }

    public void setRequestInfoId(Long requestInfoId) {
        this.requestInfoId = requestInfoId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    public Date getErrorDate() {
        return this.errorDate;
    }

    public void setErrorDate(Date errorDate) {
        this.errorDate = errorDate;
    }

    public String toString() {
        return "ErrorInfoInstance{id=" + this.id + ", requestInfoId=" + this.requestInfoId + ", message='" + this.message + '\'' + ", errorDate=" + this.errorDate + '}';
    }

    public static class Builder {
        private ErrorInfoInstance errorInfoInstance = new ErrorInfoInstance();

        public ErrorInfoInstance build() {
            return this.errorInfoInstance;
        }

        public Builder id(Long id) {
            this.errorInfoInstance.setId(id);
            return this;
        }

        public Builder requestId(Long id) {
            this.errorInfoInstance.setRequestInfoId(id);
            return this;
        }

        public Builder stacktrace(String stacktrace) {
            this.errorInfoInstance.setStacktrace(stacktrace);
            return this;
        }

        public Builder errorDate(Date date) {
            this.errorInfoInstance.setErrorDate(date == null ? date : new Date(date.getTime()));
            return this;
        }

        public Builder message(String message) {
            this.errorInfoInstance.setMessage(message);
            return this;
        }
    }
}

