/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.server.api.model.definition.QueryParam;

public final class QueryParamFactory {
    private QueryParamFactory() {
    }

    public static QueryParam isNull(String column) {
        return new QueryParam(column, "IS_NULL", null);
    }

    public static QueryParam isNotNull(String column) {
        return new QueryParam(column, "NOT_NULL", null);
    }

    public static QueryParam equalsTo(String column, Comparable<?> ... values) {
        return new QueryParam(column, "EQUALS_TO", Arrays.asList(values));
    }

    public static QueryParam notEqualsTo(String column, Comparable<?> ... values) {
        return new QueryParam(column, "NOT_EQUALS_TO", Arrays.asList(values));
    }

    public static QueryParam likeTo(String column, boolean caseSensitive, Comparable<?> value) {
        return new QueryParam(column, "LIKE_TO", Arrays.asList(value, caseSensitive));
    }

    public static QueryParam greaterThan(String column, Comparable<?> value) {
        return new QueryParam(column, "GREATER_THAN", Arrays.asList(value));
    }

    public static QueryParam greaterOrEqualsTo(String column, Comparable<?> value) {
        return new QueryParam(column, "GREATER_OR_EQUALS_TO", Arrays.asList(value));
    }

    public static QueryParam lowerThan(String column, Comparable<?> value) {
        return new QueryParam(column, "LOWER_THAN", Arrays.asList(value));
    }

    public static QueryParam lowerOrEqualsTo(String column, Comparable<?> value) {
        return new QueryParam(column, "LOWER_OR_EQUALS_TO", Arrays.asList(value));
    }

    public static QueryParam between(String column, Comparable<?> start, Comparable<?> end) {
        return new QueryParam(column, "BETWEEN", Arrays.asList(start, end));
    }

    public static QueryParam in(String column, Object ... values) {
        return new QueryParam(column, "IN", Arrays.asList(values));
    }

    public static QueryParam in(String column, List<?> values) {
        return new QueryParam(column, "IN", values);
    }

    public static QueryParam notIn(String column, List<?> values) {
        return new QueryParam(column, "NOT_IN", values);
    }

    public static QueryParam and(QueryParam ... params) {
        return new QueryParam(null, "AND", Arrays.stream(params).collect(Collectors.toList()));
    }

    public static QueryParam or(QueryParam ... params) {
        return new QueryParam(null, "OR", Arrays.stream(params).collect(Collectors.toList()));
    }

    public static QueryParam not(QueryParam param) {
        return new QueryParam(null, "NOT", Collections.singletonList(param));
    }

    public static List<QueryParam> list(QueryParam ... params) {
        return Arrays.asList(params);
    }
}

