/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.core.impl.InternalKnowledgeBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;
import org.kie.scanner.KieMavenRepository;
import org.kie.scanner.KieURLClassLoader;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.AnotherMessage;
import org.kie.server.api.marshalling.objects.DateObject;
import org.kie.server.api.marshalling.objects.Message;
import org.kie.server.api.model.KieContainerResourceFilter;

public class XStreamMarshallerTest {
    @Test
    public void testXstreamMarshalWithAnnotation() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.Message>\n  <nameWithAlias>test content</nameWithAlias>\n</org.kie.server.api.marshalling.objects.Message>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        Message testMessage = new Message("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testXstreamMarshalWithCustomMarshallerBuilder() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.AnotherMessage>\n  <another_name>test content</another_name>\n</org.kie.server.api.marshalling.objects.AnotherMessage>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        AnotherMessage testMessage = new AnotherMessage("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testPMMLRequest() {
        PMMLRequestData request = new PMMLRequestData("123", "Test Model");
        request.addRequestParam("param1", (Object)10.0);
        request.addRequestParam("param2", (Object)"test string");
        HashSet<Class> extraClasses = new HashSet<Class>();
        extraClasses.add(PMMLRequestData.class);
        extraClasses.add(ParameterInfo.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        String marshalled = marshaller.marshall((Object)request);
        System.out.println(marshalled);
        PMMLRequestData rqst = (PMMLRequestData)marshaller.unmarshall(marshalled, PMMLRequestData.class);
        System.out.println(rqst);
    }

    @Test
    public void testPMMLResult() {
        System.out.println(System.getProperties().keySet());
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"Sample Score", (Resource)ResourceFactory.newClassPathResource((String)"test_scorecard.pmml"), null);
        PMMLRequestData request = new PMMLRequestDataBuilder("123", "Sample Score").addParameter("age", (Object)33.0, Double.class).addParameter("occupation", (Object)"SKYDIVER", String.class).addParameter("residenceState", (Object)"KN", String.class).addParameter("validLicense", (Object)true, Boolean.class).build();
        helper.addPossiblePackageName("org.drools.scorecards.example");
        PMML4Result resultHolder = helper.submitRequest(request);
        KieBase kb = helper.getKbase();
        KieServices ks = KieServices.Factory.get();
        KieRepository repo = ks.getRepository();
        ReleaseId relid = ((InternalKnowledgeBase)kb).getResolvedReleaseId();
        KieModule m = repo.getKieModule(relid);
        KieMavenRepository kmp = KieMavenRepository.getKieMavenRepository();
        String pomFileName = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "pom.xml";
        try (FileOutputStream fos = new FileOutputStream(pomFileName);){
            int readVal;
            ByteArrayInputStream bais = (ByteArrayInputStream)((MemoryKieModule)m).getMemoryFileSystem().getFile("META-INF/maven/org.default/artifact/pom.xml").getContents();
            do {
                if ((readVal = bais.read()) < 0) continue;
                fos.write(readVal);
            } while (readVal >= 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        File pomFile = new File(pomFileName);
        kmp.installArtifact((AFReleaseId)relid, (InternalKieModule)m, pomFile);
        HashSet extraClasses = new HashSet();
        ClassLoader clParent = this.getClass().getClassLoader();
        URL[] urls = new URL[1];
        try {
            File f = kmp.resolveArtifact((AFReleaseId)relid).getFile();
            urls[0] = f.toURI().toURL();
        }
        catch (MalformedURLException f) {
            // empty catch block
        }
        KieURLClassLoader clToUse = new KieURLClassLoader(urls, clParent);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)clToUse);
        String marshalled = marshaller.marshall((Object)resultHolder);
        System.out.println(marshalled);
        PMML4Result result = (PMML4Result)marshaller.unmarshall(marshalled, PMML4Result.class);
        Object o = result.getResultValue("CalculatedScore", null, new Object[0]);
        Object o1 = result.getResultValue("CalculatedScore", "value", new Object[0]);
        o = result.getResultValue("ScoreCard", null, new Object[0]);
        Assert.assertNotNull((Object)o);
        o1 = result.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assert.assertNotNull((Object)o1);
        Assert.assertTrue((boolean)LinkedHashMap.class.isAssignableFrom(o1.getClass()));
        LinkedHashMap map = (LinkedHashMap)o1;
        Assert.assertTrue((boolean)map.containsKey("LX00"));
        Assert.assertTrue((boolean)map.containsKey("RES"));
        Assert.assertTrue((boolean)map.containsKey("CX2"));
        Assert.assertEquals((Object)-1.0, map.get("LX00"));
        Assert.assertEquals((Object)-10.0, map.get("RES"));
        Assert.assertEquals((Object)-30.0, map.get("CX2"));
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"LX00", iter.next());
        Assert.assertEquals((Object)"RES", iter.next());
        Assert.assertEquals((Object)"CX2", iter.next());
    }

    @Test
    public void testUnmarshallListContainersCommandWithNoFilter() {
        String commandString = "<list-containers/>";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        ListContainersCommand command = (ListContainersCommand)marshaller.unmarshall(commandString, ListContainersCommand.class);
        Assertions.assertThat((Object)command.getKieContainerResourceFilter()).isEqualTo((Object)KieContainerResourceFilter.ACCEPT_ALL);
    }

    @Test
    public void testMarshallDateObject() {
        String expectedString = "<date-object>\n  <localDate>2017-01-01</localDate>\n  <localDateTime>2017-01-01T10:10:10</localDateTime>\n  <localTime>10:10:10</localTime>\n  <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = new DateObject();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObject() {
        String expectedString = "<date-object>\n  <localDate>2017-01-01</localDate>\n  <localDateTime>2017-01-01T10:10:10</localDateTime>\n  <localTime>10:10:10</localTime>\n  <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }
}

