/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.io.StringReader;
import java.util.Collections;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DMNContextKSMarshallingTest {
    private static final Set<Class<?>> classes = Collections.singleton(DMNContextKS.class);
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final String NAMESPACE = "foo";
    private static final String MODEL_NAME = "bar";
    private static final String DECISION_ID = "baz";
    private static final String DECISION_NAME = "qux";
    private static final String DMN_CONTEXT_KEY = "quux";
    private static final String DMN_CONTEXT_VALUE = "corge";
    private static final String NAMESPACE_XPATH = "/dmn-evaluation-context/model-namespace";
    private static final String MODEL_NAME_XPATH = "/dmn-evaluation-context/model-name";
    private static final String DECISION_ID_XPATH = "/dmn-evaluation-context/decision-id";
    private static final String DECISION_NAME_XPATH = "/dmn-evaluation-context/decision-name";
    private static final String DMN_CONTEXT_ENTRY_XPATH_XSTREAM = "/dmn-evaluation-context/dmn-context/entry/string";
    private static final String DMN_CONTEXT_KEY_XPATH_JAXB = "/dmn-evaluation-context/dmn-context/element/@key";
    private static final String DMN_CONTEXT_VALUE_XPATH_JAXB = "/dmn-evaluation-context/dmn-context/element/value";
    private static DMNContextKS BEAN;
    private static String XSTREAM;
    private static String JAXB;
    private static String JSON;
    private static Marshaller xStreamMarshaller;
    private static Marshaller jaxbMarshaller;
    private static Marshaller jsonMarshaller;

    @BeforeClass
    public static void setup() {
        BEAN = new DMNContextKS();
        BEAN.setNamespace(NAMESPACE);
        BEAN.setModelName(MODEL_NAME);
        BEAN.setDecisionIds(Collections.singletonList(DECISION_ID));
        BEAN.setDecisionNames(Collections.singletonList(DECISION_NAME));
        BEAN.setDmnContext(Collections.singletonMap(DMN_CONTEXT_KEY, DMN_CONTEXT_VALUE));
        XSTREAM = "<dmn-evaluation-context>\n  <model-namespace>foo</model-namespace>\n  <model-name>bar</model-name>\n  <decision-name>qux</decision-name>\n  <decision-id>baz</decision-id>\n  <dmn-context class=\"singleton-map\">\n    <entry>\n      <string>quux</string>\n      <string>corge</string>\n    </entry>\n  </dmn-context>\n</dmn-evaluation-context>";
        JAXB = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<dmn-evaluation-context>\n    <model-namespace>foo</model-namespace>\n    <model-name>bar</model-name>\n    <decision-name>qux</decision-name>\n    <decision-id>baz</decision-id>\n    <dmn-context xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n        <type>MAP</type>\n        <element xsi:type=\"jaxbStringObjectPair\" key=\"quux\">\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">corge</value>\n        </element>\n    </dmn-context>\n</dmn-evaluation-context>\n";
        JSON = "{\n  \"model-namespace\" : \"foo\",\n  \"model-name\" : \"bar\",\n  \"decision-name\" : \"qux\",\n  \"decision-id\" : \"baz\",\n  \"dmn-context\" : {\"quux\" : \"corge\"}\n}";
        xStreamMarshaller = MarshallerFactory.getMarshaller(classes, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)DMNContextKS.class.getClassLoader());
        jaxbMarshaller = MarshallerFactory.getMarshaller(classes, (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)DMNContextKS.class.getClassLoader());
        jsonMarshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)DMNContextKS.class.getClassLoader());
    }

    @Test
    public void testXStreamMarshalling() throws XPathExpressionException {
        String result = xStreamMarshaller.marshall((Object)BEAN);
        Assert.assertNotNull((Object)result);
        this.checkXPath(result, NAMESPACE_XPATH, NAMESPACE);
        this.checkXPath(result, MODEL_NAME_XPATH, MODEL_NAME);
        this.checkXPath(result, DECISION_ID_XPATH, DECISION_ID);
        this.checkXPath(result, DECISION_NAME_XPATH, DECISION_NAME);
        this.checkXPath(result, DMN_CONTEXT_ENTRY_XPATH_XSTREAM, DMN_CONTEXT_KEY, DMN_CONTEXT_VALUE);
    }

    private void checkXPath(String source, String xPath, String ... expectedValues) {
        try (StringReader reader = new StringReader(source);){
            InputSource src = new InputSource(reader);
            NodeList nodeList = (NodeList)xpath.evaluate(xPath, src, XPathConstants.NODESET);
            Assert.assertEquals((long)nodeList.getLength(), (long)expectedValues.length);
            for (int i = 0; i < expectedValues.length; ++i) {
                Assert.assertEquals((Object)nodeList.item(i).getTextContent(), (Object)expectedValues[i]);
            }
        }
        catch (XPathExpressionException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testXStreamUnmarshalling() {
        DMNContextKS result = (DMNContextKS)xStreamMarshaller.unmarshall(XSTREAM, DMNContextKS.class);
        DMNContextKSMarshallingTest.checkBean(result);
    }

    private static void checkBean(DMNContextKS bean) {
        Assert.assertNotNull((Object)bean);
        Assert.assertEquals((Object)bean.getNamespace(), (Object)NAMESPACE);
        Assert.assertEquals((Object)bean.getModelName(), (Object)MODEL_NAME);
        Assert.assertNotNull((Object)bean.getDecisionIds());
        Assert.assertEquals((long)bean.getDecisionIds().size(), (long)1L);
        Assert.assertEquals(bean.getDecisionIds().get(0), (Object)DECISION_ID);
        Assert.assertNotNull((Object)bean.getDecisionNames());
        Assert.assertEquals((long)bean.getDecisionNames().size(), (long)1L);
        Assert.assertEquals(bean.getDecisionNames().get(0), (Object)DECISION_NAME);
        Assert.assertNotNull((Object)bean.getDmnContext());
        Assert.assertEquals((long)bean.getDmnContext().size(), (long)1L);
        Assert.assertEquals(bean.getDmnContext().get(DMN_CONTEXT_KEY), (Object)DMN_CONTEXT_VALUE);
    }

    @Test
    public void testJaxbMarshalling() {
        String result = jaxbMarshaller.marshall((Object)BEAN);
        Assert.assertNotNull((Object)result);
        this.checkXPath(result, NAMESPACE_XPATH, NAMESPACE);
        this.checkXPath(result, MODEL_NAME_XPATH, MODEL_NAME);
        this.checkXPath(result, DECISION_ID_XPATH, DECISION_ID);
        this.checkXPath(result, DECISION_NAME_XPATH, DECISION_NAME);
        this.checkXPath(result, DMN_CONTEXT_KEY_XPATH_JAXB, DMN_CONTEXT_KEY);
        this.checkXPath(result, DMN_CONTEXT_VALUE_XPATH_JAXB, DMN_CONTEXT_VALUE);
    }

    @Test
    public void testJaxbUnmarshalling() {
        DMNContextKS result = (DMNContextKS)jaxbMarshaller.unmarshall(JAXB, DMNContextKS.class);
        DMNContextKSMarshallingTest.checkBean(result);
    }

    @Test
    public void testJsonMarshalling() {
        String result = jsonMarshaller.marshall((Object)BEAN);
        Assert.assertEquals((Object)result, (Object)JSON);
    }

    @Test
    public void testJsonUnmarshalling() {
        DMNContextKS result = (DMNContextKS)jsonMarshaller.unmarshall(JSON, DMNContextKS.class);
        DMNContextKSMarshallingTest.checkBean(result);
    }

    @AfterClass
    public static void teardown() {
        xStreamMarshaller.dispose();
        jaxbMarshaller.dispose();
        jsonMarshaller.dispose();
    }
}

