/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.DateObject;
import org.kie.server.api.model.definition.QueryParam;

public class JAXBMarshallerTest {
    @Test
    public void testMarshallDateObject() {
        String expectedString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<date-object>\n    <localDate>2017-01-01</localDate>\n    <localDateTime>2017-01-01T10:10:10</localDateTime>\n    <localTime>10:10:10</localTime>\n    <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>\n";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = new DateObject();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObject() {
        String expectedString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<date-object>\n    <localDate>2017-01-01</localDate>\n    <localDateTime>2017-01-01T10:10:10</localDateTime>\n    <localTime>10:10:10</localTime>\n    <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>\n";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }

    @Test
    public void testMarshallQueryParam() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        QueryParam subParam = new QueryParam("col2", "EQUALS_TO", Collections.singletonList("XXX"));
        QueryParam param = new QueryParam("hola", "OR", Collections.singletonList(subParam));
        String converted = marshaller.marshall((Object)param);
        QueryParam param2 = (QueryParam)marshaller.unmarshall(converted, QueryParam.class);
        Assert.assertTrue((boolean)(param2.getValue().get(0) instanceof QueryParam));
    }

    @Test
    public void testMarshallError() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)13L, (long)((Integer)marshaller.unmarshall("<int-type><value>13</value></int-type>", Integer.TYPE)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)marshaller.unmarshall("<int-type><value>2kkbk</value></int-type>", Integer.TYPE)).intValue());
        System.setProperty("org.kie.server.strict.jaxb.format", "true");
        try {
            Assert.assertThrows(MarshallingException.class, () -> marshaller.unmarshall("<int-type><value>13ab</value></int-type>", Integer.TYPE));
        }
        finally {
            System.clearProperty("org.kie.server.strict.jaxb.format");
        }
    }
}

