/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.definition.ProcessInstanceField;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.util.ProcessInstanceQueryFilterSpecBuilder;

public class ProcessInstanceQueryFilterSpecBuilderTest {
    @Test
    public void testGetEqualsTo() {
        ProcessInstanceQueryFilterSpec filterSpec = new ProcessInstanceQueryFilterSpecBuilder().equalsTo(ProcessInstanceField.PROCESSID, new Comparable[]{"test-process"}).get();
        QueryParam[] params = filterSpec.getParameters();
        Assert.assertEquals((long)1L, (long)params.length);
        QueryParam param = params[0];
        Assert.assertEquals((Object)ProcessInstanceField.PROCESSID.toString(), (Object)param.getColumn());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)param.getOperator());
        Assert.assertEquals((Object)"test-process", param.getValue().stream().findFirst().get());
    }

    @Test
    public void testGetBetween() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date from = null;
        Date to = null;
        try {
            from = sdf.parse("2017-05-10");
            to = sdf.parse("2017-05-14");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ProcessInstanceQueryFilterSpec filterSpec = new ProcessInstanceQueryFilterSpecBuilder().between(ProcessInstanceField.START_DATE, (Comparable)from, (Comparable)to).get();
        QueryParam[] params = filterSpec.getParameters();
        Assert.assertEquals((long)1L, (long)params.length);
        QueryParam param = params[0];
        Assert.assertEquals((Object)ProcessInstanceField.START_DATE.toString(), (Object)param.getColumn());
        Assert.assertEquals((Object)"BETWEEN", (Object)param.getOperator());
        List values = param.getValue();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)from, values.get(0));
        Assert.assertEquals((Object)to, values.get(1));
    }

    @Test
    public void testGetEqualsToAndBetween() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date from = null;
        Date to = null;
        try {
            from = sdf.parse("2017-05-10");
            to = sdf.parse("2017-05-14");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ProcessInstanceQueryFilterSpec filterSpec = new ProcessInstanceQueryFilterSpecBuilder().equalsTo(ProcessInstanceField.PROCESSID, new Comparable[]{"test-process"}).between(ProcessInstanceField.START_DATE, (Comparable)from, (Comparable)to).get();
        QueryParam[] params = filterSpec.getParameters();
        Assert.assertEquals((long)2L, (long)params.length);
        QueryParam paramEqualsTo = params[0];
        Assert.assertEquals((Object)ProcessInstanceField.PROCESSID.toString(), (Object)paramEqualsTo.getColumn());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)paramEqualsTo.getOperator());
        Assert.assertEquals((Object)"test-process", paramEqualsTo.getValue().stream().findFirst().get());
        QueryParam paramBetween = params[1];
        Assert.assertEquals((Object)ProcessInstanceField.START_DATE.toString(), (Object)paramBetween.getColumn());
        Assert.assertEquals((Object)"BETWEEN", (Object)paramBetween.getOperator());
        List values = paramBetween.getValue();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)from, values.get(0));
        Assert.assertEquals((Object)to, values.get(1));
    }
}

