/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONAPIRoundTripTest {
    private static final Logger LOG = LoggerFactory.getLogger(JSONAPIRoundTripTest.class);
    private Marshaller marshaller;

    @Before
    public void init() {
        HashSet<Class<Applicant>> extraClasses = new HashSet<Class<Applicant>>();
        extraClasses.add(Applicant.class);
        this.marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
    }

    @Test
    public void test() {
        Applicant applicant = new Applicant("John Doe", 47);
        Applicant applicant2 = this.roundTrip(applicant);
        Assertions.assertThat((Object)applicant2).isEqualTo((Object)applicant);
        DMNContextImpl ctx = new DMNContextImpl();
        ctx.set("Applicant", (Object)applicant);
        DMNContextKS contextKS = new DMNContextKS("ns1", "model1", ctx.getAll());
        DMNContextKS contextKS2 = this.roundTrip(contextKS);
        Assertions.assertThat((Map)contextKS2.getDmnContext()).isEqualTo((Object)contextKS.getDmnContext());
        Assertions.assertThat((String)contextKS2.toString()).isEqualTo(contextKS.toString());
        DMNResultImpl dmnResults = new DMNResultImpl(null);
        dmnResults.setContext((DMNContext)ctx);
        dmnResults.addDecisionResult((DMNDecisionResult)new DMNDecisionResultImpl("decision", "decision", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)applicant, Collections.emptyList()));
        DMNResultKS resultsKS = new DMNResultKS((DMNResult)dmnResults);
        DMNResultKS resultsKS2 = this.roundTrip(resultsKS);
        Assertions.assertThat((Map)resultsKS2.getContext().getAll()).isEqualTo((Object)resultsKS.getContext().getAll());
        ServiceResponse sr = new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "ok", (Object)resultsKS);
        ServiceResponse sr2 = this.roundTrip(sr);
        Assertions.assertThat((Map)((DMNResultKS)sr2.getResult()).getContext().getAll()).isEqualTo((Object)((DMNResultKS)sr.getResult()).getContext().getAll());
    }

    private <T> T roundTrip(T input) {
        String asJSON = this.marshaller.marshall(input);
        LOG.debug("{}", (Object)asJSON);
        Object unmarshall = this.marshaller.unmarshall(asJSON, input.getClass());
        LOG.debug("{}", unmarshall);
        return (T)unmarshall;
    }

    public static class Applicant {
        private String name;
        private int age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Applicant() {
        }

        public Applicant(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.age;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Applicant other = (Applicant)obj;
            if (this.age != other.age) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return "Applicant [name=" + this.name + ", age=" + this.age + "]";
        }
    }
}

