/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class QueryServicesClientImpl
extends AbstractKieServicesClientImpl
implements QueryServicesClient {
    public QueryServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public QueryServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<ProcessDefinition> findProcessesById(String processId) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions/{pId}", valuesMap), ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesById", new Object[]{processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public ProcessDefinition findProcessByContainerIdProcessId(String containerId, String processId) {
        ProcessDefinition result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definitions/{pId}", valuesMap), ProcessDefinition.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByDeploymentIdProcessId", new Object[]{containerId, processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinition)response.getResult();
        }
        return result;
    }

    @Override
    public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByFilter", new Object[]{"", page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?filter=" + filter, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByFilter", new Object[]{filter, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByDeploymentId", new Object[]{containerId, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{new ArrayList(), "", "", page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/correlation/{correlationKey}", valuesMap), ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByCorrelationKey", new Object[]{correlationKey.toExternalForm()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/{pId}/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstancesByProcessId", new Object[]{processId, this.safeList(status), "", page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?processName=" + processName, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), "", processName, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstancesByDeploymentId", new Object[]{containerId, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), "", "", page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?initiator=" + initiator, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), initiator, "", page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/variables/{varName}", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByVariables", new Object[]{variableName, "", this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String statusQueryString = this.getAdditionalParams("?varValue=" + variableValue, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/variables/{varName}", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByVariables", new Object[]{variableName, variableValue, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public ProcessInstance findProcessInstanceById(Long processInstanceId) {
        ProcessInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}", valuesMap), ProcessInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceById", new Object[]{processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstance)response.getResult();
        }
        return result;
    }

    @Override
    public ProcessInstance findProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/correlation/{correlationKey}", valuesMap), ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByCorrelationKey", new Object[]{correlationKey.toExternalForm()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null && result.getProcessInstances().length > 0) {
            for (ProcessInstance instance : result.getProcessInstances()) {
                if (instance.getState() != 1) continue;
                return instance;
            }
        }
        return null;
    }

    @Override
    public NodeInstance findNodeInstanceByWorkItemId(Long processInstanceId, Long workItemId) {
        NodeInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("workItemId", workItemId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/wi-nodes/instances/{workItemId}", valuesMap), NodeInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getNodeInstanceForWorkItem", new Object[]{processInstanceId, workItemId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstance)response.getResult();
        }
        return result;
    }

    @Override
    public List<NodeInstance> findActiveNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?activeOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, false, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findCompletedNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?completedOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, false, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariablesCurrentState(Long processInstanceId) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/variables/instances", valuesMap), VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariablesCurrentState", new Object[]{processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariableHistory(Long processInstanceId, String variableName, Integer page, Integer pageSize) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/variables/instances/{varName}", valuesMap) + queryString, VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariableHistory", new Object[]{processInstanceId, variableName, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }
}

