/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import org.kie.api.command.Command;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class RuleServicesClientImpl
extends AbstractKieServicesClientImpl
implements RuleServicesClient {
    public RuleServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public RuleServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<String> executeCommands(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, payload, String.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, cmd, String.class, this.getHeaders(cmd));
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, this.serialize(cmd))));
        return (ServiceResponse)this.executeJmsCommand(script, cmd.getClass().getName()).getResponses().get(0);
    }
}

