/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieServicesClientImpl {
    private static Logger logger = LoggerFactory.getLogger(AbstractKieServicesClientImpl.class);
    protected static final Boolean BYPASS_AUTH_USER = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));
    protected String baseURI;
    protected final KieServicesConfiguration config;
    protected final Marshaller marshaller;
    protected ClassLoader classLoader;
    protected KieServicesClientImpl owner;

    public AbstractKieServicesClientImpl(KieServicesConfiguration config) {
        this.config = config.clone();
        this.baseURI = config.getServerUrl();
        this.classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : CommandScript.class.getClassLoader();
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraJaxbClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)this.classLoader);
    }

    public AbstractKieServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        this.config = config.clone();
        this.baseURI = config.getServerUrl();
        this.classLoader = classLoader;
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraJaxbClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)classLoader);
    }

    protected String initializeURI(URL url, String servicePrefix) {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "services/" + servicePrefix + "/server";
        try {
            URL serverPlusServicePrefixUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return urlString;
    }

    public void setOwner(KieServicesClientImpl owner) {
        this.owner = owner;
    }

    protected void throwExceptionOnFailure(ServiceResponse<?> serviceResponse) {
        if (serviceResponse != null && ServiceResponse.ResponseType.FAILURE.equals((Object)serviceResponse.getType())) {
            throw new KieServicesException(serviceResponse.getMsg());
        }
    }

    protected void sendTaskOperation(String containerId, Long taskId, String operation, String queryString) {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)operation, valuesMap) + queryString, null, String.class, this.getHeaders(null));
    }

    protected <T> ServiceResponse<T> makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected String makeHttpGetRequestAndCreateRawResponse(String uri) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return response.body();
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected String makeHttpGetRequestAndCreateRawResponse(String uri, Map<String, String> headers) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).get();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return response.body();
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, body, resultType, new HashMap<String, String>());
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, new HashMap<String, String>());
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPutRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    protected <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPutRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpDeleteRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpDeleteRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.NO_CONTENT.getStatusCode()) {
            if (resultType == null) {
                return null;
            }
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected KieRemoteHttpRequest newRequest(String uri) {
        String authorization;
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(this.config.getTimeout());
        httpRequest.accept(this.getMediaType(this.config.getMarshallingFormat()));
        httpRequest.header("X-KIE-ContentType", (Object)this.config.getMarshallingFormat().toString());
        if (this.config.getCredentialsProvider() != null && (authorization = this.config.getCredentialsProvider().getAuthorization()) != null && !authorization.isEmpty()) {
            httpRequest.header(this.config.getCredentialsProvider().getHeaderName(), (Object)authorization);
        }
        if (this.owner.getConversationId() != null) {
            httpRequest.header("X-KIE-ConversationId", (Object)this.owner.getConversationId());
        }
        return httpRequest;
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command) {
        return this.executeJmsCommand(command, null);
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType) {
        return this.executeJmsCommand(command, classType, null, null);
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType, String targetCapability) {
        return this.executeJmsCommand(command, classType, targetCapability, null);
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType, String targetCapability, String containerId) {
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = this.config.getRequestQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        ServiceResponsesList cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            Marshaller marshaller;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUserName(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to setup a JMS connection.", jmse);
            }
            try {
                marshaller = MarshallerFactory.getMarshaller(this.config.getExtraJaxbClasses(), (MarshallingFormat)this.config.getMarshallingFormat(), (ClassLoader)this.classLoader);
                String xmlStr = marshaller.marshall((Object)command);
                TextMessage textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization_format", this.config.getMarshallingFormat().getId());
                if (classType != null) {
                    textMsg.setStringProperty("kie_class_type", classType);
                }
                if (targetCapability != null) {
                    textMsg.setStringProperty("kie_target_capability", targetCapability);
                }
                textMsg.setStringProperty("kie_user", this.config.getUserName());
                textMsg.setStringProperty("kie_password", this.config.getPassword());
                if (containerId != null) {
                    textMsg.setStringProperty("container_id", containerId);
                }
                if (this.owner.getConversationId() != null) {
                    textMsg.setStringProperty("kie_conversation_id", this.owner.getConversationId());
                }
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive(this.config.getTimeout());
            }
            catch (JMSException jmse) {
                logger.warn("JMS exception while waiting for response - {}", (Object)jmse.getMessage());
                throw new KieServicesException("Unable to receive or retrieve the JMS response.", jmse);
            }
            if (response == null) {
                logger.warn("Response is empty");
                ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Response is empty"));
                ServiceResponsesList serviceResponsesList = new ServiceResponsesList(responses);
                return serviceResponsesList;
            }
            assert (response != null) : "Response is empty.";
            try {
                this.owner.setConversationId(response.getStringProperty("kie_conversation_id"));
                String responseStr = ((TextMessage)response).getText();
                logger.debug("Received response from server '{}'", (Object)responseStr);
                ServiceResponsesList serviceResponsesList = cmdResponse = (ServiceResponsesList)marshaller.unmarshall(responseStr, ServiceResponsesList.class);
                return serviceResponsesList;
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to extract " + ServiceResponsesList.class.getSimpleName() + " instance from JMS response.", jmse);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
    }

    protected String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(String content, Class<T> type) {
        logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
        if (content == null || content.isEmpty()) {
            return null;
        }
        try {
            return (T)this.marshaller.unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while deserializing data received from server!", e);
        }
    }

    protected void checkResultType(ServiceResponse<?> serviceResponse, Class<?> expectedResultType) {
        Object actualResult = serviceResponse.getResult();
        if (actualResult != null && !expectedResultType.isInstance(actualResult)) {
            throw new KieServicesException("Error while creating service response! The actual result type " + serviceResponse.getResult().getClass() + " does not match the expected type " + expectedResultType + "!");
        }
    }

    protected RuntimeException createExceptionForUnexpectedResponseCode(KieRemoteHttpRequest request, KieRemoteHttpResponse response) {
        String summaryMessage = "Unexpected HTTP response code when requesting URI '" + request.getUri() + "'! Error code: " + response.code() + ", message: " + response.body();
        logger.debug(summaryMessage + ", response body: " + this.getMessage(response));
        return new KieServicesException(summaryMessage);
    }

    protected String getMessage(KieRemoteHttpResponse response) {
        try {
            String body = response.body();
            if (body != null && !body.isEmpty()) {
                return body;
            }
        }
        catch (Exception e) {
            logger.debug("Error when getting both of the response {}", (Object)e.getMessage());
        }
        return response.message();
    }

    protected String buildQueryString(String paramName, List<?> items) {
        StringBuilder builder = new StringBuilder("?");
        for (Object o : items) {
            builder.append(paramName).append("=").append(o).append("&");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    protected Map<String, String> getHeaders(Object object) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (object != null) {
            headers.put("X-KIE-ClassType", object.getClass().getName());
        }
        return headers;
    }

    protected String getUserQueryStr(String userId) {
        if (BYPASS_AUTH_USER.booleanValue()) {
            return "?user=" + userId;
        }
        return "";
    }

    protected String getUserAndPagingQueryString(String userId, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    protected String getUserAndAdditionalParam(String userId, String name, String value) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append(name).append("=").append(value);
        return queryString.toString();
    }

    protected String getUserAndAdditionalParams(String userId, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    protected String getPagingQueryString(String inQueryString, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    protected String getAdditionalParams(String inQueryString, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    protected Map<?, ?> safeMap(Map<?, ?> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap(map);
    }

    protected List<?> safeList(List<?> list) {
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList(list);
    }

    protected <T> ServiceResponse<T> makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(String uri, Object body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)this.serialize(body)).post();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            serviceResponse.setResult((Object)this.serialize(serviceResponse.getResult()));
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            serviceResponse.setResult((Object)this.serialize(serviceResponse.getResult()));
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    public String getConversationId() {
        return this.owner.getConversationId();
    }
}

