/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.api.command.Command;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.GetServerStateCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.helper.KieServicesClientBuilder;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServicesClientImpl
extends AbstractKieServicesClientImpl
implements KieServicesClient {
    private static Logger logger = LoggerFactory.getLogger(KieServicesClientImpl.class);
    private static final ServiceLoader<KieServicesClientBuilder> clientBuilders = ServiceLoader.load(KieServicesClientBuilder.class, KieServicesClientImpl.class.getClassLoader());
    private static List<KieServicesClientBuilder> loadedClientBuilders = KieServicesClientImpl.loadClientBuilders();
    private String conversationId;
    private KieServerInfo kieServerInfo;
    private Map<Class<?>, Object> servicesClients = new HashMap();

    public KieServicesClientImpl(KieServicesConfiguration config) {
        super(config);
        this.init();
    }

    public KieServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
        this.init();
    }

    private void init() {
        this.setOwner(this);
        List serverCapabilities = this.config.getCapabilities();
        if (serverCapabilities == null) {
            this.kieServerInfo = (KieServerInfo)this.getServerInfo().getResult();
            logger.debug("KieServicesClient connected to: {} version {}", (Object)this.kieServerInfo.getServerId(), (Object)this.kieServerInfo.getVersion());
            serverCapabilities = this.kieServerInfo.getCapabilities();
            logger.debug("Supported capabilities by the server: {}", (Object)serverCapabilities);
        }
        if (serverCapabilities != null && !serverCapabilities.isEmpty()) {
            HashMap<String, KieServicesClientBuilder> clientBuildersByCapability = new HashMap<String, KieServicesClientBuilder>();
            for (KieServicesClientBuilder builder : loadedClientBuilders) {
                clientBuildersByCapability.put(builder.getImplementedCapability(), builder);
            }
            for (String capability : serverCapabilities) {
                logger.debug("Building services client for server capability {}", (Object)capability);
                KieServicesClientBuilder builder = (KieServicesClientBuilder)clientBuildersByCapability.get(capability);
                if (builder != null) {
                    try {
                        logger.debug("Builder '{}' for capability '{}'", (Object)builder, (Object)capability);
                        Map<Class<?>, Object> clients = builder.build(this.config, this.classLoader);
                        for (Object serviceClient : clients.values()) {
                            if (!(serviceClient instanceof AbstractKieServicesClientImpl)) continue;
                            ((AbstractKieServicesClientImpl)serviceClient).setOwner(this);
                        }
                        logger.debug("Capability implemented by {}", clients);
                        this.servicesClients.putAll(clients);
                    }
                    catch (Exception e) {
                        logger.warn("Builder {} throw exception while setting up clients, no {} capabilities will be available", (Object)builder, (Object)capability);
                    }
                    continue;
                }
                logger.debug("No builder found for '{}' capability", (Object)capability);
            }
        }
    }

    @Override
    public <T> T getServicesClient(Class<T> serviceClient) {
        if (this.servicesClients.containsKey(serviceClient)) {
            return (T)this.servicesClients.get(serviceClient);
        }
        throw new KieServicesException("Server that this client is connected to has no capabilities to handle " + serviceClient.getSimpleName());
    }

    @Override
    public ServiceResponse<KieServerInfo> getServerInfo() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI, KieServerInfo.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerInfoCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResourceList> listContainers() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers", KieContainerResourceList.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new ListContainersCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPutRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, resource, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CreateContainerCommand(resource)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetContainerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponse<Void> disposeContainer(String id) {
        if (this.config.isRest()) {
            return this.makeHttpDeleteRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, Void.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeContainerCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponsesList executeScript(CommandScript script) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateCustomResponse(this.baseURI + "/config", script, ServiceResponsesList.class);
        }
        return this.executeJmsCommand(script);
    }

    @Override
    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetScannerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", resource, KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateScannerCommand(id, resource)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/release-id", releaseId, ReleaseId.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateReleaseIdCommand(id, releaseId)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieServerStateInfo> getServerState() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/state", KieServerStateInfo.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerStateCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    @Deprecated
    public ServiceResponse<String> executeCommands(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/instances/" + id, payload, String.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    @Deprecated
    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        if (this.config.isRest()) {
            return this.makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/instances/" + id, cmd, String.class, this.getHeaders(cmd));
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, this.serialize(cmd))));
        return (ServiceResponse)this.executeJmsCommand(script, cmd.getClass().getName(), null, id).getResponses().get(0);
    }

    public String toString() {
        return "KieServicesClient{kieServer=" + this.kieServerInfo + ", available clients=" + this.servicesClients + '}';
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.marshaller.setClassLoader(classLoader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.marshaller.getClassLoader();
    }

    @Override
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    public void completeConversation() {
        this.conversationId = null;
    }

    public void setConversationId(String conversationId) {
        if (conversationId != null) {
            this.conversationId = conversationId;
        }
    }

    private static synchronized List<KieServicesClientBuilder> loadClientBuilders() {
        ArrayList<KieServicesClientBuilder> builders = new ArrayList<KieServicesClientBuilder>();
        for (KieServicesClientBuilder builder : clientBuilders) {
            builders.add(builder);
        }
        return builders;
    }
}

