/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.KieServicesHttpException;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.kie.server.client.jms.ResponseHandler;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.KieServerHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieServicesClientImpl {
    private static Logger logger = LoggerFactory.getLogger(AbstractKieServicesClientImpl.class);
    protected static final Boolean BYPASS_AUTH_USER = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));
    protected LoadBalancer loadBalancer;
    protected final KieServicesConfiguration config;
    protected final Marshaller marshaller;
    protected ClassLoader classLoader;
    protected KieServicesClientImpl owner;
    private ResponseHandler responseHandler;

    public AbstractKieServicesClientImpl(KieServicesConfiguration config) {
        this.config = config.clone();
        this.loadBalancer = config.getLoadBalancer() == null ? LoadBalancer.getDefault(config.getServerUrl()) : config.getLoadBalancer();
        this.classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : CommandScript.class.getClassLoader();
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)this.classLoader);
        this.responseHandler = config.getResponseHandler();
    }

    public AbstractKieServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        this.config = config.clone();
        this.loadBalancer = config.getLoadBalancer() == null ? LoadBalancer.getDefault(config.getServerUrl()) : config.getLoadBalancer();
        this.classLoader = classLoader;
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)classLoader);
        this.responseHandler = config.getResponseHandler();
    }

    protected String initializeURI(URL url, String servicePrefix) {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "services/" + servicePrefix + "/server";
        try {
            URL serverPlusServicePrefixUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return urlString;
    }

    public void setOwner(KieServicesClientImpl owner) {
        this.owner = owner;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        if (this.config.getTransport() == KieServicesConfiguration.Transport.REST) {
            throw new UnsupportedOperationException("Response handlers can only be configured for JMS client");
        }
        this.responseHandler = responseHandler;
    }

    protected void throwExceptionOnFailure(ServiceResponse<?> serviceResponse) {
        if (serviceResponse != null && ServiceResponse.ResponseType.FAILURE.equals((Object)serviceResponse.getType())) {
            throw new KieServicesException(serviceResponse.getMsg());
        }
    }

    protected boolean shouldReturnWithNullResponse(ServiceResponse<?> serviceResponse) {
        if (serviceResponse != null && ServiceResponse.ResponseType.NO_RESPONSE.equals((Object)serviceResponse.getType())) {
            logger.debug("Returning null as the response type is NO_RESPONSE");
            return true;
        }
        return false;
    }

    protected void sendTaskOperation(String containerId, Long taskId, String operation, String queryString) {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)operation, valuesMap) + queryString, null, String.class, this.getHeaders(null));
    }

    protected <T> ServiceResponse<T> makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(url).get();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(url).get();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected String makeHttpGetRequestAndCreateRawResponse(String uri) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(url).get();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return response.body();
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected String makeHttpGetRequestAndCreateRawResponse(final String uri, final Map<String, String> headers) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).headers(headers).get();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return response.body();
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, body, resultType, new HashMap<String, String>());
    }

    protected <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(final String uri, final String body, Class<T> resultType, final Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).headers(headers).body((CharSequence)body).post();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, new HashMap<String, String>());
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(final String uri, final String body, Class<T> resultType, final Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).headers(headers).body((CharSequence)body).post();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPutRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    protected <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(final String uri, final String body, Class<T> resultType) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).body((CharSequence)body).put();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPutRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(final String uri, final String body, Class<T> resultType, final Map<String, String> headers) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).headers(headers).body((CharSequence)body).put();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.CREATED.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeHttpDeleteRequestAndCreateServiceResponse(final String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).delete();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> T makeHttpDeleteRequestAndCreateCustomResponse(final String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieServerHttpRequest request = this.invoke(uri, new RemoteHttpOperation(){

            @Override
            public KieServerHttpRequest doOperation(String url) {
                return AbstractKieServicesClientImpl.this.newRequest(uri).delete();
            }
        });
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.NO_CONTENT.getStatusCode()) {
            if (resultType == null) {
                return null;
            }
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected KieServerHttpRequest newRequest(String uri) {
        String authorization;
        KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)uri).followRedirects(true).timeout(this.config.getTimeout());
        httpRequest.accept(this.getMediaType(this.config.getMarshallingFormat()));
        httpRequest.header("X-KIE-ContentType", (Object)this.config.getMarshallingFormat().toString());
        if (this.config.getHeaders() != null) {
            for (Map.Entry<String, String> header : this.config.getHeaders().entrySet()) {
                httpRequest.header(header.getKey(), (Object)header.getValue());
                logger.debug("Adding additional header {} value {}", (Object)header.getKey(), (Object)header.getValue());
            }
        }
        if (this.config.getCredentialsProvider() != null && (authorization = this.config.getCredentialsProvider().getAuthorization()) != null && !authorization.isEmpty()) {
            httpRequest.header(this.config.getCredentialsProvider().getHeaderName(), (Object)authorization);
        }
        if (this.owner.getConversationId() != null) {
            httpRequest.header("X-KIE-ConversationId", (Object)this.owner.getConversationId());
        }
        return httpRequest;
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command) {
        return this.executeJmsCommand(command, null);
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType) {
        return this.executeJmsCommand(command, classType, null, null);
    }

    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType, String targetCapability) {
        return this.executeJmsCommand(command, classType, targetCapability, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceResponsesList executeJmsCommand(CommandScript command, String classType, String targetCapability, String containerId) {
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = this.config.getRequestQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        ServiceResponsesList cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Marshaller marshaller;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUserName(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(this.config.isJmsTransactional(), 1);
                producer = session.createProducer((Destination)sendQueue);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to setup a JMS connection.", jmse);
            }
            try {
                marshaller = MarshallerFactory.getMarshaller(this.config.getExtraClasses(), (MarshallingFormat)this.config.getMarshallingFormat(), (ClassLoader)this.classLoader);
                String xmlStr = marshaller.marshall((Object)command);
                logger.debug("Message content to be sent '{}'", (Object)xmlStr);
                TextMessage textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization_format", this.config.getMarshallingFormat().getId());
                textMsg.setIntProperty("kie_interaction_pattern", this.responseHandler.getInteractionPattern());
                if (classType != null) {
                    textMsg.setStringProperty("kie_class_type", classType);
                }
                if (targetCapability != null) {
                    textMsg.setStringProperty("kie_target_capability", targetCapability);
                }
                textMsg.setStringProperty("kie_user", this.config.getUserName());
                textMsg.setStringProperty("kie_password", this.config.getPassword());
                if (containerId != null) {
                    textMsg.setStringProperty("container_id", containerId);
                }
                if (this.owner.getConversationId() != null) {
                    textMsg.setStringProperty("kie_conversation_id", this.owner.getConversationId());
                }
                if (this.config.getHeaders() != null) {
                    for (Map.Entry<String, String> header : this.config.getHeaders().entrySet()) {
                        logger.debug("Adding additional property {} value {}", (Object)header.getKey(), (Object)header.getValue());
                        textMsg.setStringProperty(header.getKey(), header.getValue());
                    }
                }
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to send a JMS message.", jmse);
            }
            ServiceResponsesList serviceResponsesList = cmdResponse = this.responseHandler.handleResponse(selector, connection, session, responseQueue, this.config, marshaller, this.owner);
            this.responseHandler.dispose(connection, session);
            return serviceResponsesList;
        }
        catch (Throwable throwable) {
            this.responseHandler.dispose(connection, session);
            throw throwable;
        }
    }

    protected String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(String content, Class<T> type) {
        logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
        if (content == null || content.isEmpty()) {
            return null;
        }
        try {
            return (T)this.marshaller.unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while deserializing data received from server!", e);
        }
    }

    protected void checkResultType(ServiceResponse<?> serviceResponse, Class<?> expectedResultType) {
        Object actualResult = serviceResponse.getResult();
        if (actualResult != null && !expectedResultType.isInstance(actualResult)) {
            throw new KieServicesException("Error while creating service response! The actual result type " + serviceResponse.getResult().getClass() + " does not match the expected type " + expectedResultType + "!");
        }
    }

    protected RuntimeException createExceptionForUnexpectedResponseCode(KieServerHttpRequest request, KieServerHttpResponse response) {
        String summaryMessage = "Unexpected HTTP response code when requesting URI '" + request.getUri() + "'! Error code: " + response.code() + ", message: " + response.body();
        logger.debug(summaryMessage + ", response body: " + this.getMessage(response));
        return new KieServicesHttpException(summaryMessage, response.code(), request.getUri().toString(), response.body());
    }

    protected String getMessage(KieServerHttpResponse response) {
        try {
            String body = response.body();
            if (body != null && !body.isEmpty()) {
                return body;
            }
        }
        catch (Exception e) {
            logger.debug("Error when getting both of the response {}", (Object)e.getMessage());
        }
        return response.message();
    }

    protected String buildQueryString(String paramName, List<?> items) {
        StringBuilder builder = new StringBuilder("?");
        for (Object o : items) {
            builder.append(paramName).append("=").append(o).append("&");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    protected Map<String, String> getHeaders(Object object) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (object != null) {
            headers.put("X-KIE-ClassType", object.getClass().getName());
        }
        return headers;
    }

    protected String getUserQueryStr(String userId) {
        if (BYPASS_AUTH_USER.booleanValue()) {
            return "?user=" + userId;
        }
        return "";
    }

    protected String getUserAndPagingQueryString(String userId, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    protected String getUserAndAdditionalParam(String userId, String name, String value) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append(name).append("=").append(value);
        return queryString.toString();
    }

    protected String getUserAndAdditionalParams(String userId, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    protected String getPagingQueryString(String inQueryString, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    protected String getSortingQueryString(String inQueryString, String sort, boolean sortOrder) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("sort=" + sort).append("&sortOrder=" + sortOrder);
        return queryString.toString();
    }

    protected String getAdditionalParams(String inQueryString, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    protected Map<?, ?> safeMap(Map<?, ?> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap(map);
    }

    protected List<?> safeList(List<?> list) {
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList(list);
    }

    protected <T> ServiceResponse<T> makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(String uri, Object body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, body);
        KieServerHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)this.serialize(body)).post();
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            serviceResponse.setResult((Object)this.serialize(serviceResponse.getResult()));
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    protected <T> ServiceResponse<T> makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieServerHttpResponse response = request.response();
        this.owner.setConversationId(response.header("X-KIE-ConversationId"));
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            serviceResponse.setResult((Object)this.serialize(serviceResponse.getResult()));
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    public String getConversationId() {
        return this.owner.getConversationId();
    }

    protected KieServerHttpRequest invoke(String url, RemoteHttpOperation operation) {
        String nextUrl = null;
        while (true) {
            try {
                return operation.doOperation(url);
            }
            catch (KieServerHttpRequestException e) {
                if (!(e.getCause() instanceof IOException)) {
                    throw e;
                }
                logger.debug("Marking endpoint '{}' as failed due to {}", (Object)url, (Object)e.getCause().getMessage());
                this.loadBalancer.markAsFailed(url);
                url = nextUrl = this.loadBalancer.getUrl();
                logger.debug("Selecting next endpoint from load balancer - '{}'", (Object)url);
                if (nextUrl != null) continue;
                throw new KieServerHttpRequestException("Unable to invoke operation " + operation);
            }
            break;
        }
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected error while encoding string '" + value + "'", e);
        }
    }

    private abstract class RemoteHttpOperation {
        private RemoteHttpOperation() {
        }

        public abstract KieServerHttpRequest doOperation(String var1);
    }
}

