/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.balancer.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.server.client.balancer.impl.AbstractBalancerStrategy;

public class RandomBalancerStrategy
extends AbstractBalancerStrategy {
    private List<String> availableEndpoints = new ArrayList<String>();

    public RandomBalancerStrategy(List<String> availableEndpoints) {
        availableEndpoints.forEach(endpoint -> this.markAsOnline((String)endpoint));
    }

    @Override
    public String next() {
        this.checkEmpty(this.availableEndpoints);
        if (this.availableEndpoints.size() == 1) {
            return this.availableEndpoints.get(0);
        }
        int index = this.getRandomInt(0, this.availableEndpoints.size() - 1);
        return this.availableEndpoints.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsOffline(String url) {
        List<String> list = this.availableEndpoints;
        synchronized (list) {
            this.availableEndpoints.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsOnline(String url) {
        List<String> list = this.availableEndpoints;
        synchronized (list) {
            if (!this.availableEndpoints.contains(url)) {
                this.availableEndpoints.add(url);
            }
        }
    }

    @Override
    public List<String> getAvailableEndpoints() {
        return new ArrayList<String>(this.availableEndpoints);
    }

    protected int getRandomInt(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min + 1)) + min;
    }

    public String toString() {
        return "RandomBalancerStrategy{availableEndpoints=" + this.availableEndpoints + '}';
    }
}

