/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.DMNServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class DMNServicesClientImpl
extends AbstractKieServicesClientImpl
implements DMNServicesClient {
    public DMNServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public DMNServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<DMNModelInfoList> getModels(String containerId) {
        ServiceResponse result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            result = this.makeHttpGetRequestAndCreateServiceResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/dmn", valuesMap), DMNModelInfoList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DMNService", "getModels", new Object[]{containerId})));
            result = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "DMN", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(result);
            if (this.shouldReturnWithNullResponse(result)) {
                return null;
            }
        }
        return result;
    }

    @Override
    public ServiceResponse<DMNResult> evaluateAll(String containerId, DMNContext dmnContext) {
        return this.evaluateAll(containerId, null, null, dmnContext);
    }

    @Override
    public ServiceResponse<DMNResult> evaluateAll(String containerId, String namespace, String modelName, DMNContext dmnContext) {
        DMNContextKS payload = new DMNContextKS(namespace, modelName, dmnContext.getAll());
        return this.evaluateDecisions(containerId, payload);
    }

    @Override
    public ServiceResponse<DMNResult> evaluateDecisionByName(String containerId, String namespace, String modelName, String decisionName, DMNContext dmnContext) {
        Objects.requireNonNull(decisionName, "Parameter decisionName cannot be null; method evaluateAllDecisions() can be used to avoid the need of supplying decisionName");
        DMNContextKS payload = new DMNContextKS(namespace, modelName, dmnContext.getAll());
        payload.setDecisionNames(Collections.singletonList(decisionName));
        return this.evaluateDecisions(containerId, payload);
    }

    @Override
    public ServiceResponse<DMNResult> evaluateDecisionById(String containerId, String namespace, String modelName, String decisionId, DMNContext dmnContext) {
        Objects.requireNonNull(decisionId, "Parameter decisionId cannot be null; method evaluateAllDecisions() can be used to avoid the need of supplying decisionId");
        DMNContextKS payload = new DMNContextKS(namespace, modelName, dmnContext.getAll());
        payload.setDecisionIds(Collections.singletonList(decisionId));
        return this.evaluateDecisions(containerId, payload);
    }

    @Override
    public ServiceResponse<DMNResult> evaluateDecisionService(String containerId, String namespace, String modelName, String decisionServiceName, DMNContext dmnContext) {
        Objects.requireNonNull(decisionServiceName, "Parameter decisionServiceName cannot be null; method evaluateAllDecisions() can be used to evaluate all decisions in a model, this method is to invoke a specific decision service only.");
        DMNContextKS payload = new DMNContextKS(namespace, modelName, dmnContext.getAll());
        payload.setDecisionServiceName(decisionServiceName);
        return this.evaluateDecisions(containerId, payload);
    }

    public ServiceResponse<DMNResult> evaluateDecisions(String containerId, DMNContextKS payload) {
        ServiceResponse result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            result = this.makeHttpPostRequestAndCreateServiceResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/dmn", valuesMap), payload, DMNResultKS.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DMNService", "evaluateDecisions", this.serialize(payload), this.marshaller.getFormat().getType(), new Object[]{containerId})));
            result = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "DMN", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(result);
            if (this.shouldReturnWithNullResponse(result)) {
                return null;
            }
        }
        if (result instanceof Wrapped) {
            return (ServiceResponse)((Wrapped)result).unwrap();
        }
        ServiceResponse result2 = result;
        if (this.config.getMarshallingFormat() == MarshallingFormat.JSON) {
            DMNServicesClientImpl.recurseAndModifyByCoercingNumbers(((DMNResult)result2.getResult()).getContext());
            for (DMNDecisionResult dr : ((DMNResult)result2.getResult()).getDecisionResults()) {
                DMNServicesClientImpl.recurseAndModifyByCoercingNumbers(dr.getResult());
            }
        }
        return result2;
    }

    private static Object recurseAndModifyByCoercingNumbers(Object result) {
        if (result instanceof DMNContext) {
            DMNContext ctx = (DMNContext)result;
            ctx.getAll().replaceAll((k, v) -> DMNServicesClientImpl.recurseAndModifyByCoercingNumbers(v));
            return ctx;
        }
        if (result instanceof Map) {
            ((Map)result).replaceAll((k, v) -> DMNServicesClientImpl.recurseAndModifyByCoercingNumbers(v));
        } else {
            if (result instanceof List) {
                ((List)result).replaceAll(DMNServicesClientImpl::recurseAndModifyByCoercingNumbers);
                return result;
            }
            if (result instanceof Set) {
                Set originalSet = (Set)result;
                Collection mappedSet = originalSet.stream().map(DMNServicesClientImpl::recurseAndModifyByCoercingNumbers).collect(Collectors.toSet());
                originalSet.clear();
                originalSet.addAll(mappedSet);
                return result;
            }
            if (result instanceof Number) {
                return DMNServicesClientImpl.coerceNumber(result);
            }
        }
        return result;
    }

    @Override
    public DMNContext newContext() {
        return new DMNResultKS().getContext();
    }

    private static BigDecimal getBigDecimalOrNull(Object value) {
        if (!(value instanceof Number) && !(value instanceof String)) {
            return null;
        }
        if (!BigDecimal.class.isAssignableFrom(value.getClass())) {
            value = value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicLong || value instanceof AtomicInteger ? new BigDecimal(((Number)value).longValue(), MathContext.DECIMAL128) : (value instanceof BigInteger ? new BigDecimal(((BigInteger)value).toString(), MathContext.DECIMAL128) : (value instanceof String ? new BigDecimal(((String)value).replaceFirst("^0+(?!$)", ""), MathContext.DECIMAL128) : new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL128)));
        }
        return (BigDecimal)value;
    }

    private static Object coerceNumber(Object value) {
        if (value instanceof Number && !(value instanceof BigDecimal)) {
            return DMNServicesClientImpl.getBigDecimalOrNull(value);
        }
        return value;
    }
}

