/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.KieServicesClientImpl;

public class KieServicesClientErrorHandlingTest
extends BaseKieServicesClientTest {
    private static BaseMatcher<MarshallingException> serializationExceptionMatcher = new BaseMatcher<MarshallingException>(){

        public boolean matches(Object o) {
            return o instanceof MarshallingException;
        }

        public void describeTo(Description description) {
            description.appendText("SerializationException");
        }
    };
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testError404Handling() {
        this.expectedEx.expect(KieServicesHttpException.class);
        this.expectedEx.expectMessage("Error code: 404");
        this.expectedEx.expect(Matchers.hasProperty((String)"httpCode", (Matcher)Matchers.is((Object)404)));
        this.expectedEx.expect(Matchers.hasProperty((String)"url", (Matcher)Matchers.endsWith((String)"/containers")));
        this.expectedEx.expect(Matchers.hasProperty((String)"responseBody", (Matcher)Matchers.is((Object)"Resource not found!")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(404).withBody("Resource not found!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testError401Handling() {
        this.expectedEx.expect(KieServicesHttpException.class);
        this.expectedEx.expectMessage("Error code: 401");
        this.expectedEx.expect(Matchers.hasProperty((String)"httpCode", (Matcher)Matchers.is((Object)401)));
        this.expectedEx.expect(Matchers.hasProperty((String)"url", (Matcher)Matchers.endsWith((String)"/containers")));
        this.expectedEx.expect(Matchers.hasProperty((String)"responseBody", (Matcher)Matchers.is((Object)"Unauthorized!")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(401).withBody("Unauthorized!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testError500Handling() {
        this.expectedEx.expect(KieServicesHttpException.class);
        this.expectedEx.expectMessage("Error code: 500");
        this.expectedEx.expect(Matchers.hasProperty((String)"httpCode", (Matcher)Matchers.is((Object)500)));
        this.expectedEx.expect(Matchers.hasProperty((String)"url", (Matcher)Matchers.endsWith((String)"/containers")));
        this.expectedEx.expect(Matchers.hasProperty((String)"responseBody", (Matcher)Matchers.is((Object)"Internal server error!")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(500).withBody("Internal server error!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testXmlDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testJsonDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{\n  \"type\" : \"SUCCESS\",\n  \"msg\" : \"Kie Server info\",\n  \"result\" : {\n    \"kie-server-info\" : {\n      \"version\" : \"1.2.3\",\n    }\n  }\n}")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesConfiguration configJSON = this.config.clone();
        configJSON.setMarshallingFormat(MarshallingFormat.JSON);
        KieServicesClientImpl client = new KieServicesClientImpl(configJSON);
        client.listContainers();
    }
}

