/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import java.net.URLDecoder;
import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.ConversationId;
import org.kie.server.api.model.ReleaseId;

public class ConversationIdTest {
    @Test
    public void testParseConversationIdFromString() throws Exception {
        String conversationId = "'kie-server-id':'my-container':'org.kie:kjar:1.0':'12345abcdef'";
        ConversationId instance = ConversationId.fromString((String)conversationId);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"kie-server-id", (Object)instance.getKieServerId());
        Assert.assertEquals((Object)"my-container", (Object)instance.getContainerId());
        Assert.assertEquals((Object)"org.kie:kjar:1.0", (Object)instance.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)"12345abcdef", (Object)instance.getUniqueString());
        String conversationIdUrlEncoded = URLEncoder.encode(conversationId, "UTF-8");
        Assert.assertEquals((Object)conversationIdUrlEncoded, (Object)instance.toString());
    }

    @Test
    public void testParseConversationId() {
        ConversationId instance = ConversationId.from((String)"kie-server-id", (String)"my-container", (ReleaseId)new ReleaseId("org.kie", "kjar", "1.0"));
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"kie-server-id", (Object)instance.getKieServerId());
        Assert.assertEquals((Object)"my-container", (Object)instance.getContainerId());
        Assert.assertEquals((Object)"org.kie:kjar:1.0", (Object)instance.getReleaseId().toExternalForm());
    }

    @Test
    public void testParseConversationIdWithColonInName() {
        ConversationId instance = ConversationId.from((String)"kie:server:id", (String)"my:container", (ReleaseId)new ReleaseId("org.kie", "kjar", "1.0"));
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"kie:server:id", (Object)instance.getKieServerId());
        Assert.assertEquals((Object)"my:container", (Object)instance.getContainerId());
        Assert.assertEquals((Object)"org.kie:kjar:1.0", (Object)instance.getReleaseId().toExternalForm());
    }

    @Test
    public void testParseConversationRoundTripping() throws Exception {
        String conversationId = "'kie-server-id':'my-container':'org.kie:kjar:1.0':'12345abcdef'";
        ConversationId instance = ConversationId.fromString((String)conversationId);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"kie-server-id", (Object)instance.getKieServerId());
        Assert.assertEquals((Object)"my-container", (Object)instance.getContainerId());
        Assert.assertEquals((Object)"org.kie:kjar:1.0", (Object)instance.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)"12345abcdef", (Object)instance.getUniqueString());
        String conversationIdUrlEncoded = URLEncoder.encode(conversationId, "UTF-8");
        Assert.assertEquals((Object)conversationIdUrlEncoded, (Object)instance.toString());
        Assert.assertEquals((Object)conversationId, (Object)URLDecoder.decode(instance.toString(), "UTF-8"));
        instance = ConversationId.fromString((String)instance.toString());
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"kie-server-id", (Object)instance.getKieServerId());
        Assert.assertEquals((Object)"my-container", (Object)instance.getContainerId());
        Assert.assertEquals((Object)"org.kie:kjar:1.0", (Object)instance.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)"12345abcdef", (Object)instance.getUniqueString());
    }
}

