/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.UIServicesClient;

public class UIServicesClientTest
extends BaseKieServicesClientTest {
    private final String dummyFormContent = "form content";
    private static final String TEST_CONTAINER_ID = "test";
    private static final long TEST_TASK_ID = 1L;
    private UIServicesClient uiClient;

    @Before
    public void createClient() {
        this.config.setCapabilities(Arrays.asList("BPM-UI"));
        this.uiClient = (UIServicesClient)KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config).getServicesClient(UIServicesClient.class);
    }

    @Test
    public void testGetTaskForm() {
        String queryString = "?type=ANY&marshallContent=true&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        String form = this.uiClient.getTaskForm(TEST_CONTAINER_ID, Long.valueOf(1L));
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskFormByType() {
        String queryString = "?type=FTL&marshallContent=true&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        String form = this.uiClient.getTaskFormByType(TEST_CONTAINER_ID, Long.valueOf(1L), "FTL");
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskFormWithLang() {
        String queryString = "?type=ANY&marshallContent=true&lang=en&filter=true";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        String form = this.uiClient.getTaskForm(TEST_CONTAINER_ID, Long.valueOf(1L), "en");
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskRawForm() {
        String queryString = "?type=ANY&marshallContent=false&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        String form = this.uiClient.getTaskRawForm(TEST_CONTAINER_ID, Long.valueOf(1L));
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskRawFormAsUserBypassingAuthUser() {
        String userId = "user";
        String queryString = "?user=" + userId + "&type=ANY&marshallContent=false&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        this.setBypassAuthUserConfig(Boolean.TRUE);
        String form = this.uiClient.getTaskRawFormAsUser(TEST_CONTAINER_ID, Long.valueOf(1L), userId);
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskFormAsUserWithoutBypassingAuthUser() {
        String userId = "user";
        String queryString = "?type=ANY&marshallContent=true&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        this.setBypassAuthUserConfig(Boolean.FALSE);
        String form = this.uiClient.getTaskFormAsUser(TEST_CONTAINER_ID, Long.valueOf(1L), null, userId);
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    @Test
    public void testGetTaskFormAsUserBypassingAuthUser() {
        String userId = "user";
        String queryString = "?user=" + userId + "&type=ANY&marshallContent=true&filter=false";
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("containerId", TEST_CONTAINER_ID);
        valuesMap.put("taskInstanceId", 1L);
        String url = RestURI.build((String)"", (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + queryString;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("form content")));
        this.setBypassAuthUserConfig(Boolean.TRUE);
        String form = this.uiClient.getTaskFormAsUser(TEST_CONTAINER_ID, Long.valueOf(1L), "", userId);
        Assert.assertEquals((Object)"form content", (Object)form);
    }

    private void setBypassAuthUserConfig(Boolean newValue) {
        try {
            Field field = this.uiClient.getClass().getSuperclass().getDeclaredField("BYPASS_AUTH_USER");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(this.uiClient, newValue);
            field.setAccessible(true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

