/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import org.junit.Rule;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKieServicesClientTest {
    private static Logger logger = LoggerFactory.getLogger(BaseKieServicesClientTest.class);
    private final int port = BaseKieServicesClientTest.findFreePort();
    private final int sslPort = BaseKieServicesClientTest.findFreePort();
    protected final String mockServerBaseUri = "http://localhost:" + this.port;
    protected final String mockSecureServerBaseUri = "https://localhost:" + this.sslPort;
    protected final KieServicesConfiguration config;
    protected final KieServicesConfiguration sslConfig;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().port(this.port).httpsPort(Integer.valueOf(this.sslPort)).needClientAuth(true).keystorePath("src/test/resources/2wayssl/wiremock.jks").keystorePassword("password").trustStorePath("src/test/resources/2wayssl/server-truststore.jks").trustStorePassword("password"));

    public BaseKieServicesClientTest() {
        try {
            this.config = KieServicesFactory.newRestConfiguration((String)this.mockServerBaseUri, null, null);
            this.config.setCapabilities(Collections.emptyList());
            this.sslConfig = KieServicesFactory.newRestConfiguration((String)this.mockSecureServerBaseUri, null, null);
            this.config.setCapabilities(Collections.emptyList());
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating configuration", e);
        }
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        logger.debug("Allocating port: " + port);
        return port;
    }
}

