/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Fault;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class LoadBalancerClientAuthTest {
    private String mockServerBaseUri1;
    private String mockServerBaseUri2;
    private String loadBalanceUri;
    private WireMockServer wireMockServer1;
    private WireMockServer wireMockServer2;
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String AUTH_VALUE = "Basic " + new String(Base64.getEncoder().encode("user:pass".getBytes(StandardCharsets.UTF_8)));

    protected WireMockServer createMockServer(String version, int port) {
        WireMockServer wireMockServer = new WireMockServer(port);
        wireMockServer.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Authorization", WireMock.equalTo((String)AUTH_VALUE)).atPriority(Integer.valueOf(1)).willReturn(WireMock.aResponse().withStatus(200).withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>" + version + "</version>\n  </kie-server-info>\n</response>")));
        wireMockServer.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).atPriority(Integer.valueOf(2)).willReturn(WireMock.aResponse().withStatus(401).withFault(Fault.EMPTY_RESPONSE)));
        return wireMockServer;
    }

    @Before
    public void startServers() {
        int port1 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer1 = this.createMockServer("1", port1);
        this.wireMockServer1.start();
        int port2 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer2 = this.createMockServer("2", port2);
        this.wireMockServer2.start();
        this.mockServerBaseUri1 = "http://localhost:" + port1;
        this.mockServerBaseUri2 = "http://localhost:" + port2;
        this.loadBalanceUri = this.mockServerBaseUri1 + "|" + this.mockServerBaseUri2;
    }

    @After
    public void stopServers() {
        this.wireMockServer1.stop();
        this.wireMockServer2.stop();
    }

    @Test
    public void testDefaultLoadBalancer() {
        KieServicesConfiguration config = KieServicesFactory.newRestConfiguration((String)this.loadBalanceUri, (String)USER, (String)PASS);
        config.setCapabilities(Arrays.asList("KieServer"));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)2L, (long)available.size());
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    private void assertSuccess(ServiceResponse<?> response) {
        Assert.assertEquals((String)"Response type", (Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }

    @Test
    public void testCheckFailedEndpointsDefaultConfig() throws Exception {
        KieServicesConfiguration config = KieServicesFactory.newRestConfiguration((String)this.loadBalanceUri, (String)USER, (String)PASS);
        config.setCapabilities(Arrays.asList("KieServer"));
        this.testCheckFailedEndpoints(config);
    }

    @Test
    public void testCheckFailedEndpointsCreateLoadBalancer() throws Exception {
        KieServicesConfiguration config = KieServicesFactory.newRestConfiguration((String)this.loadBalanceUri, (String)USER, (String)PASS);
        config.setCapabilities(Arrays.asList("KieServer"));
        LoadBalancer loadBalancer = LoadBalancer.getDefault((String)this.loadBalanceUri);
        Assert.assertNull((Object)loadBalancer.getUserName());
        Assert.assertNull((Object)loadBalancer.getPassword());
        loadBalancer.setUserName(USER);
        loadBalancer.setPassword(PASS);
        config.setLoadBalancer(loadBalancer);
        this.testCheckFailedEndpoints(config);
    }

    private void testCheckFailedEndpoints(KieServicesConfiguration config) throws Exception {
        this.wireMockServer1.stop();
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)1L, (long)available.size());
        this.wireMockServer1.start();
        Future waitForResult = ((AbstractKieServicesClientImpl)client).getLoadBalancer().checkFailedEndpoints();
        waitForResult.get(5L, TimeUnit.SECONDS);
        available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)2L, (long)available.size());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }
}

