/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.common.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.B64Code;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.ServerTestCase;

public class KieServerHttpRequestTest
extends ServerTestCase {
    private static String url;
    private static ServerTestCase.RequestHandler handler;

    @BeforeClass
    public static void startServer() throws Exception {
        url = KieServerHttpRequestTest.setUp((Handler)new ServerTestCase.RequestHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (handler != null) {
                    handler.handle(target, baseRequest, request, response);
                }
            }

            @Override
            public void handle(Request request, HttpServletResponse response) {
                if (handler != null) {
                    handler.handle(request, response);
                }
            }
        });
    }

    @After
    public void clearHandler() {
        handler = null;
    }

    @Test(expected=KieServerHttpRequestException.class)
    public void malformedStringUrlTest() {
        KieServerHttpRequest.newRequest((String)"\\m/");
    }

    @Test
    public void malformedStringUrlCauseTest() {
        try {
            KieServerHttpRequest.newRequest((String)"\\m/");
            Assert.fail((String)"Exception not thrown");
        }
        catch (KieServerHttpRequestException e) {
            Assert.assertNotNull((Object)e.getCause());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeBufferSize() {
        KieServerHttpRequest.newRequest((String)"http://localhost").bufferSize(-1);
    }

    @Test
    public void getEmptyTest() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((URL)new URL(url));
        Assert.assertNotNull((Object)request.getConnection());
        Assert.assertEquals((long)30000L, (long)request.timeout(30000L).getConnection().getReadTimeout());
        Assert.assertEquals((long)2500L, (long)request.bufferSize(2500).bufferSize());
        Assert.assertFalse((boolean)request.ignoreCloseExceptions(false).ignoreCloseExceptions());
        int code = request.get().response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"OK", (Object)request.response().message());
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"", (Object)request.response().body());
        Assert.assertNotNull((Object)request.toString());
        Assert.assertFalse((request.toString().length() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)request, (Object)request.disconnect());
        Assert.assertTrue((request.response().contentLength() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)request.getUrl().toString(), (Object)url);
        Assert.assertEquals((Object)"GET", (Object)request.getMethod());
    }

    @Test
    public void getUrlEmpty() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((URL)new URL(url));
        Assert.assertNotNull((Object)request.getConnection());
        int code = request.response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"OK", (Object)request.response().message());
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"", (Object)request.response().body());
    }

    @Test
    public void getNoContent() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(204);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((URL)new URL(url));
        Assert.assertNotNull((Object)request.getConnection());
        int code = request.response().code();
        Assert.assertEquals((long)204L, (long)code);
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"No Content", (Object)request.response().message());
        Assert.assertEquals((long)204L, (long)code);
        Assert.assertEquals((Object)"", (Object)request.response().body());
    }

    @Test
    public void getUrlEncodedWithSpace() throws Exception {
        String unencoded = "/a resource";
        final AtomicReference path = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                path.set(request.getPathInfo());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)(url + unencoded));
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)unencoded, path.get());
    }

    @Test
    public void getUrlEncodedWithUnicode() throws Exception {
        String unencoded = "/\u00df";
        final AtomicReference path = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                path.set(request.getPathInfo());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)(url + unencoded));
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)unencoded, path.get());
    }

    @Test
    public void getUrlEncodedWithPercent() throws Exception {
        String unencoded = "/%";
        final AtomicReference path = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                path.set(request.getPathInfo());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)(url + unencoded));
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)unencoded, path.get());
    }

    @Test
    public void deleteEmpty() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.deleteRequest((URL)new URL(url));
        Assert.assertNotNull((Object)request.getConnection());
        Assert.assertEquals((long)200L, (long)request.delete().response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"", (Object)request.response().body());
        Assert.assertEquals((Object)"DELETE", (Object)request.getMethod());
    }

    @Test
    public void deleteUrlEmpty() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.deleteRequest((URL)new URL(url));
        Assert.assertNotNull((Object)request.getConnection());
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"", (Object)request.response().body());
    }

    @Test
    public void postEmpty() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(201);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)201L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
    }

    @Test
    public void postUrlEmpty() throws Exception {
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                response.setStatus(201);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((URL)new URL(url));
        Assert.assertEquals((long)201L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
    }

    @Test
    public void postNonEmptyString() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setStatus(200);
            }
        };
        int code = KieServerHttpRequest.postRequest((URL)new URL(url)).body((CharSequence)"hello").response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"hello", body.get());
    }

    @Test
    public void postWithLength() throws Exception {
        final AtomicReference body = new AtomicReference();
        final AtomicReference length = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                length.set(request.getContentLength());
                response.setStatus(200);
            }
        };
        String data = "hello";
        int sent = data.getBytes().length;
        int code = KieServerHttpRequest.newRequest((URL)new URL(url)).body((CharSequence)data).post().response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((long)sent, (long)((Integer)length.get()).intValue());
        Assert.assertEquals((Object)data, body.get());
    }

    @Test
    public void postForm() throws Exception {
        final AtomicReference body = new AtomicReference();
        final AtomicReference contentType = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                contentType.set(request.getContentType());
                response.setStatus(200);
            }
        };
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("name", "user");
        data.put("number", "100");
        int code = KieServerHttpRequest.postRequest((URL)new URL(url)).form(data).form((Object)"zip", (Object)"12345").response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"name=user&number=100&zip=12345", body.get());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded; charset=UTF-8", contentType.get());
    }

    @Test
    public void postFormWithNoCharset() throws Exception {
        final AtomicReference body = new AtomicReference();
        final AtomicReference contentType = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                contentType.set(request.getContentType());
                response.setStatus(200);
            }
        };
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("name", "user");
        data.put("number", "100");
        int code = KieServerHttpRequest.postRequest((URL)new URL(url)).form(data, null).form((Object)"zip", (Object)"12345").response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"name=user&number=100&zip=12345", body.get());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", contentType.get());
    }

    @Test
    public void postEmptyForm() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setStatus(200);
            }
        };
        int code = KieServerHttpRequest.postRequest((URL)new URL(url)).form(new HashMap()).response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"", body.get());
    }

    @Test
    public void getNonEmptyString() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                this.write("hello");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"hello", (Object)request.response().body());
        Assert.assertEquals((long)"hello".getBytes().length, (long)request.response().contentLength());
        Assert.assertFalse((request.response().contentLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getWithResponseCharset() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setContentType("text/html; charset=UTF-8");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"UTF-8", (Object)request.response().charset().toUpperCase());
    }

    @Test
    public void getWithResponseCharsetAsSecondParam() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setContentType("text/html; param1=val1; charset=UTF-8");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"UTF-8", (Object)request.response().charset());
    }

    @Test
    public void basicAuthentication() throws Exception {
        final AtomicReference user = new AtomicReference();
        final AtomicReference password = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                String auth = request.getHeader("Authorization");
                auth = auth.substring(auth.indexOf(32) + 1);
                auth = B64Code.decode((String)auth, (String)"UTF-8");
                int colon = auth.indexOf(58);
                user.set(auth.substring(0, colon));
                password.set(auth.substring(colon + 1));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).basicAuthorization("user", "p4ssw0rd");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"user", user.get());
        Assert.assertEquals((Object)"p4ssw0rd", password.get());
    }

    @Test
    @Ignore
    public void basicProxyAuthentication() throws Exception {
        final AtomicBoolean finalHostReached = new AtomicBoolean(false);
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                finalHostReached.set(true);
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).useProxy("localhost", proxyPort).proxyBasic("user", "p4ssw0rd");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"user", proxyUser.get());
        Assert.assertEquals((Object)"p4ssw0rd", proxyPassword.get());
        Assert.assertEquals((Object)true, (Object)finalHostReached.get());
        Assert.assertEquals((long)1L, (long)proxyHitCount.get());
    }

    @Test
    public void getBytes() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                this.write("hello");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertTrue((boolean)Arrays.equals("hello".getBytes(), request.response().bytes()));
    }

    @Test
    public void getError() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(404);
                this.write("error");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)404L, (long)request.get().response().code());
        Assert.assertEquals((Object)"error", (Object)request.response().body());
    }

    @Test
    public void noError() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"", (Object)request.response().body());
    }

    @Test
    public void contentEncodingHeader() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("Content-Encoding", "gzip");
            }
        };
        Assert.assertEquals((Object)"gzip", (Object)KieServerHttpRequest.newRequest((String)url).get().response().contentEncoding());
    }

    @Test
    public void contentTypeHeader() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("Content-Type", "text/html");
            }
        };
        Assert.assertEquals((Object)"text/html", (Object)KieServerHttpRequest.newRequest((String)url).get().response().contentType());
    }

    @Test
    public void requestContentTypeTest() throws Exception {
        final AtomicReference contentType = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                contentType.set(request.getContentType());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).contentType("text/html", "UTF-8");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"text/html; charset=UTF-8", contentType.get());
    }

    @Test
    public void requestContentTypeNullCharsetTest() throws Exception {
        final AtomicReference contentType = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                contentType.set(request.getContentType());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).contentType("text/html", null);
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"text/html", contentType.get());
    }

    @Test
    public void requestContentTypeEmptyCharsetTest() throws Exception {
        final AtomicReference contentType = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                contentType.set(request.getContentType());
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).contentType("text/html", "");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"text/html", contentType.get());
    }

    @Test
    public void headers() throws Exception {
        final AtomicReference h1 = new AtomicReference();
        final AtomicReference h2 = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                h1.set(request.getHeader("h1"));
                h2.set(request.getHeader("h2"));
            }
        };
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("h1", "v1");
        headers.put("h2", "v2");
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).headers(headers);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"v1", h1.get());
        Assert.assertEquals((Object)"v2", h2.get());
    }

    @Test
    public void emptyHeaders() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).headers(Collections.emptyMap());
        Assert.assertEquals((long)200L, (long)request.get().response().code());
    }

    @Test
    public void getAllHeaders() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "a");
                response.setHeader("b", "b");
                response.addHeader("a", "another");
            }
        };
        Map headers = KieServerHttpRequest.newRequest((String)url).get().response().headers();
        Assert.assertEquals((long)headers.size(), (long)6L);
        Assert.assertEquals((long)((List)headers.get("a")).size(), (long)2L);
        Assert.assertTrue((boolean)((String)((List)headers.get("b")).get(0)).equals("b"));
    }

    @Test
    public void numberHeader() throws Exception {
        final AtomicReference h1 = new AtomicReference();
        final AtomicReference h2 = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                h1.set(request.getHeader("h1"));
                h2.set(request.getHeader("h2"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).header("h1", (Object)5).header("h2", (Object)null);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"5", h1.get());
        Assert.assertEquals((Object)"", h2.get());
    }

    @Test
    public void userAgentHeader() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("User-Agent"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).header("User-Agent", (Object)"browser 1.0");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"browser 1.0", header.get());
    }

    @Test
    public void acceptHeader() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("Accept"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).accept("application/json");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"application/json", header.get());
    }

    @Test
    public void acceptJson() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("Accept"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).accept("application/json");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"application/json", header.get());
    }

    @Test
    public void ifNoneMatchHeader() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("If-None-Match"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).header("If-None-Match", (Object)"eid");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"eid", header.get());
    }

    @Test
    public void acceptCharsetHeader() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("Accept-Charset"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).acceptCharset("UTF-8");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"UTF-8", header.get());
    }

    @Test
    public void acceptEncodingHeader() throws Exception {
        final AtomicReference header = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                header.set(request.getHeader("Accept-Encoding"));
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).acceptEncoding("compress");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"compress", header.get());
    }

    @Test
    public void httpsTrust() throws Exception {
        Assert.assertNotNull((Object)KieServerHttpRequest.getRequest((String)"https://localhost").trustAllCerts().trustAllHosts());
    }

    @Test
    public void httpTrust() throws Exception {
        Assert.assertNotNull((Object)KieServerHttpRequest.getRequest((String)"http://localhost").trustAllCerts().trustAllHosts());
    }

    @Test
    public void verifierAccepts() {
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)"https://localhost");
        HttpsURLConnection connection = (HttpsURLConnection)request.getConnection();
        request.trustAllHosts();
        Assert.assertNotNull((Object)connection.getHostnameVerifier());
        Assert.assertTrue((boolean)connection.getHostnameVerifier().verify(null, null));
    }

    @Test
    public void singleVerifier() {
        KieServerHttpRequest request1 = KieServerHttpRequest.getRequest((String)"https://localhost").trustAllHosts();
        KieServerHttpRequest request2 = KieServerHttpRequest.getRequest((String)"https://localhost").trustAllHosts();
        Assert.assertNotNull((Object)((HttpsURLConnection)request1.getConnection()).getHostnameVerifier());
        Assert.assertNotNull((Object)((HttpsURLConnection)request2.getConnection()).getHostnameVerifier());
        Assert.assertEquals((Object)((HttpsURLConnection)request1.getConnection()).getHostnameVerifier(), (Object)((HttpsURLConnection)request2.getConnection()).getHostnameVerifier());
    }

    @Test
    public void singleSslSocketFactory() {
        KieServerHttpRequest request1 = KieServerHttpRequest.getRequest((String)"https://localhost").trustAllCerts();
        KieServerHttpRequest request2 = KieServerHttpRequest.getRequest((String)"https://localhost").trustAllCerts();
        Assert.assertNotNull((Object)((HttpsURLConnection)request1.getConnection()).getSSLSocketFactory());
        Assert.assertNotNull((Object)((HttpsURLConnection)request2.getConnection()).getSSLSocketFactory());
        Assert.assertEquals((Object)((HttpsURLConnection)request1.getConnection()).getSSLSocketFactory(), (Object)((HttpsURLConnection)request2.getConnection()).getSSLSocketFactory());
    }

    @Test
    public void getGzipped() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                GZIPOutputStream output;
                response.setStatus(200);
                if (!"gzip".equals(request.getHeader("Accept-Encoding"))) {
                    return;
                }
                response.setHeader("Content-Encoding", "gzip");
                try {
                    output = new GZIPOutputStream((OutputStream)response.getOutputStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    output.write("hello compressed".getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url).acceptEncoding("gzip").setUncompress(true);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"hello compressed", (Object)request.response().body());
    }

    @Test
    public void getNonGzippedWithUncompressEnabled() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                if (!"gzip".equals(request.getHeader("Accept-Encoding"))) {
                    return;
                }
                this.write("hello not compressed");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url).acceptEncoding("gzip").setUncompress(true);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"hello not compressed", (Object)request.response().body());
    }

    @Test
    public void getHeaders() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.addHeader("a", "1");
                response.addHeader("a", "2");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        String[] values = request.response().headers("a");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertTrue((boolean)Arrays.asList(values).contains("1"));
        Assert.assertTrue((boolean)Arrays.asList(values).contains("2"));
    }

    @Test
    public void getEmptyHeaders() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        String[] values = request.response().headers("a");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)0L, (long)values.length);
    }

    @Test
    public void getSingleParameterTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=d");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"d", (Object)request.response().headerParameter("a", "c"));
    }

    @Test
    public void getMultipleParametersTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=d;e=f");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"d", (Object)request.response().headerParameter("a", "c"));
        Assert.assertEquals((Object)"f", (Object)request.response().headerParameter("a", "e"));
    }

    @Test
    public void getSingleParameterQuotedTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=\"d\"");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"d", (Object)request.response().headerParameter("a", "c"));
    }

    @Test
    public void getMultipleParametersQuotedTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=\"d\";e=\"f\"");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.getRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.response().code());
        Assert.assertEquals((Object)"d", (Object)request.response().headerParameter("a", "c"));
        Assert.assertEquals((Object)"f", (Object)request.response().headerParameter("a", "e"));
    }

    @Test
    public void getMissingParameter() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=d");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertNull((Object)request.response().headerParameter("a", "e"));
    }

    @Test
    public void getParameterFromMissingHeaderTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=d");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertNull((Object)request.response().headerParameter("b", "c"));
        Assert.assertTrue((boolean)request.response().headerParameters("b").isEmpty());
    }

    @Test
    public void getEmptyParameterTest() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;c=");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertNull((Object)request.response().headerParameter("a", "c"));
        Assert.assertTrue((boolean)request.response().headerParameters("a").isEmpty());
    }

    @Test
    public void getEmptyParameters() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "b;");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertNull((Object)request.response().headerParameter("a", "c"));
        Assert.assertTrue((boolean)request.response().headerParameters("a").isEmpty());
    }

    @Test
    public void getParameters() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "value;b=c;d=e");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Map params = request.response().headerParameters("a");
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"c", params.get("b"));
        Assert.assertEquals((Object)"e", params.get("d"));
    }

    @Test
    public void getQuotedParameters() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "value;b=\"c\";d=\"e\"");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Map params = request.response().headerParameters("a");
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"c", params.get("b"));
        Assert.assertEquals((Object)"e", params.get("d"));
    }

    @Test
    public void getMixQuotedParameters() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
                response.setHeader("a", "value; b=c; d=\"e\"");
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Map params = request.response().headerParameters("a");
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"c", params.get("b"));
        Assert.assertEquals((Object)"e", params.get("d"));
    }

    @Test
    public void postFormAsEntries() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setStatus(200);
            }
        };
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("name", "user");
        data.put("number", "100");
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).form(data);
        int code = request.post().response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"name=user&number=100", body.get());
    }

    @Test
    public void postFormEntryWithNullValue() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setStatus(200);
            }
        };
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("name", null);
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).form(data);
        int code = request.post().response().code();
        Assert.assertEquals((long)200L, (long)code);
        Assert.assertEquals((Object)"name=", body.get());
    }

    @Test
    public void postWithMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "user");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void postWithVaragsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"user").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void postWithEscapedMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "us er");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void postWithEscapedVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"us er").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void postWithNumericQueryParams() throws Exception {
        HashMap<Integer, Integer> inputParams = new HashMap<Integer, Integer>();
        inputParams.put(1, 2);
        inputParams.put(3, 4);
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("1", request.getParameter("1"));
                outputParams.put("3", request.getParameter("3"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"2", outputParams.get("1"));
        Assert.assertEquals((Object)"4", outputParams.get("3"));
    }

    @Test
    public void getWithMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "user");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void getWithVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"user").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void getWithEscapedMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "us er");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void getWithEscapedVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"us er").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.get().response().code());
        Assert.assertEquals((Object)"GET", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void deleteWithMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "user");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.delete().response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void deleteWithVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"user").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.delete().response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void deleteWithEscapedMappedQueryParams() throws Exception {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("name", "us er");
        inputParams.put("number", "100");
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query(inputParams);
        Assert.assertEquals((long)200L, (long)request.delete().response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void deleteWithEscapedVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"us er").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.delete().response().code());
        Assert.assertEquals((Object)"DELETE", method.get());
        Assert.assertEquals((Object)"us er", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void postWithVarargsQueryParams() throws Exception {
        final HashMap outputParams = new HashMap();
        final AtomicReference method = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                method.set(request.getMethod());
                outputParams.put("name", request.getParameter("name"));
                outputParams.put("number", request.getParameter("number"));
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url).query((Object)"name", (Object)"user").query((Object)"number", (Object)"100");
        Assert.assertEquals((long)200L, (long)request.post().response().code());
        Assert.assertEquals((Object)"POST", method.get());
        Assert.assertEquals((Object)"user", outputParams.get("name"));
        Assert.assertEquals((Object)"100", outputParams.get("number"));
    }

    @Test
    public void appendMappedQueryParamsWithNoPath() throws Exception {
        Assert.assertEquals((Object)"http://test.com/?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com", Collections.singletonMap("a", "b")));
    }

    @Test
    public void appendVarargsQueryParmasWithNoPath() throws Exception {
        Assert.assertEquals((Object)"http://test.com/?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com", (Object[])new Object[]{"a", "b"}));
    }

    @Test
    public void appendMappedQueryParamsWithPath() throws Exception {
        Assert.assertEquals((Object)"http://test.com/segment1?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/segment1", Collections.singletonMap("a", "b")));
        Assert.assertEquals((Object)"http://test.com/?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/", Collections.singletonMap("a", "b")));
    }

    @Test
    public void appendVarargsQueryParamsWithPath() throws Exception {
        Assert.assertEquals((Object)"http://test.com/segment1?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/segment1", (Object[])new Object[]{"a", "b"}));
        Assert.assertEquals((Object)"http://test.com/?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/", (Object[])new Object[]{"a", "b"}));
    }

    @Test
    public void appendMultipleMappedQueryParams() throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("a", "b");
        params.put("c", "d");
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", params));
    }

    @Test
    public void appendMultipleVarargsQueryParams() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", (Object[])new Object[]{"a", "b", "c", "d"}));
    }

    @Test
    public void appendNullMappedQueryParams() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", (Map)null));
    }

    @Test
    public void appendNullVaragsQueryParams() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", (Object[])null));
    }

    @Test
    public void appendEmptyMappedQueryParams() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", Collections.emptyMap()));
    }

    @Test
    public void appendEmptyVarargsQueryParams() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", (Object[])new Object[0]));
    }

    @Test
    public void appendWithNullMappedQueryParamValues() throws Exception {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("a", null);
        params.put("b", null);
        Assert.assertEquals((Object)"http://test.com/1?a=&b=", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", params));
    }

    @Test
    public void appendWithNullVaragsQueryParamValues() throws Exception {
        Assert.assertEquals((Object)"http://test.com/1?a=&b=", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1", (Object[])new Object[]{"a", null, "b", null}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void appendOddNumberOfParams() {
        KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com", (Object[])new Object[]{"1"});
    }

    @Test
    public void appendMappedQueryParamsWithExistingQueryStart() {
        Assert.assertEquals((Object)"http://test.com/1?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?", Collections.singletonMap("a", "b")));
    }

    @Test
    public void appendVarargsQueryParamsWithExistingQueryStart() {
        Assert.assertEquals((Object)"http://test.com/1?a=b", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?", (Object[])new Object[]{"a", "b"}));
    }

    @Test
    public void appendMappedQueryParamsWithExistingParams() {
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?a=b", Collections.singletonMap("c", "d")));
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?a=b&", Collections.singletonMap("c", "d")));
    }

    @Test
    public void appendWithVarargsQueryParamsWithExistingParams() {
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?a=b", (Object[])new Object[]{"c", "d"}));
        Assert.assertEquals((Object)"http://test.com/1?a=b&c=d", (Object)KieServerHttpRequest.appendQueryParameters((CharSequence)"http://test.com/1?a=b&", (Object[])new Object[]{"c", "d"}));
    }

    @Test
    public void badRequestCode() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(400);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((String)url);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((long)400L, (long)request.get().response().code());
    }

    @Test
    public void sendReceiveWithoutcode() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                try {
                    response.getWriter().write("world");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((URL)new URL(url)).ignoreCloseExceptions(false);
        Assert.assertEquals((Object)"world", (Object)request.body((CharSequence)"hello").post().response().body());
        Assert.assertEquals((Object)"hello", body.get());
    }

    @Test
    public void sendHeadersWithoutCode() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setHeader("h1", "v1");
                response.setHeader("h2", "v2");
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((URL)new URL(url)).ignoreCloseExceptions(false);
        Map headers = request.body((CharSequence)"hello").post().response().headers();
        Assert.assertEquals((Object)"v1", ((List)headers.get("h1")).get(0));
        Assert.assertEquals((Object)"v2", ((List)headers.get("h2")).get(0));
        Assert.assertEquals((Object)"hello", body.get());
    }

    @Test
    public void sendIntHeaderWithoutCode() throws Exception {
        final AtomicReference body = new AtomicReference();
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                body.set(new String(this.read()));
                response.setIntHeader("Width", 9876);
                response.setStatus(200);
            }
        };
        KieServerHttpRequest request = KieServerHttpRequest.newRequest((URL)new URL(url)).ignoreCloseExceptions(false);
        Assert.assertEquals((long)9876L, (long)request.body((CharSequence)"hello").post().response().intHeader("Width"));
        Assert.assertEquals((Object)"hello", body.get());
    }

    @Test
    public void streamOfEmptyOkResponse() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(200);
            }
        };
        Assert.assertEquals((Object)"", (Object)KieServerHttpRequest.newRequest((String)url).get().response().body());
    }

    @Test
    public void bodyOfEmptyErrorResponse() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(400);
            }
        };
        Assert.assertEquals((Object)"", (Object)KieServerHttpRequest.newRequest((String)url).get().response().body());
    }

    @Test
    public void bodyOfNonEmptyErrorResponse() throws Exception {
        handler = new ServerTestCase.RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                response.setStatus(400);
                try {
                    response.getWriter().write("error");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Assert.assertEquals((Object)"error", (Object)KieServerHttpRequest.newRequest((String)url).get().response().body());
    }
}

