/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.api.model;

import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="kie-server-instance")
public class KieServerInstance {
    private String identifier;
    private String name;
    private String version;
    private Set<KieServerInstanceInfo> managedInstances;
    private KieServerStatus status;
    private KieServerSetup kieServerSetup;

    @XmlElement(name="server-id")
    public String getIdentifier() {
        return this.identifier;
    }

    @XmlElementWrapper(name="server-managed-instances")
    public Set<KieServerInstanceInfo> getManagedInstances() {
        return this.managedInstances;
    }

    @XmlElement(name="server-status")
    public KieServerStatus getStatus() {
        if (this.managedInstances != null && !this.managedInstances.isEmpty()) {
            int statusBalance = 0;
            for (KieServerInstanceInfo instanceInfo : this.managedInstances) {
                if (KieServerStatus.UP.equals((Object)instanceInfo.getStatus())) {
                    ++statusBalance;
                    continue;
                }
                if (!KieServerStatus.DOWN.equals((Object)instanceInfo.getStatus())) continue;
                --statusBalance;
            }
            this.status = statusBalance == this.managedInstances.size() ? KieServerStatus.UP : (statusBalance * -1 == this.managedInstances.size() ? KieServerStatus.DOWN : KieServerStatus.PARTIAL_UP);
        } else {
            this.status = KieServerStatus.UNKNOWN;
        }
        return this.status;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setManagedInstances(Set<KieServerInstanceInfo> managedInstances) {
        this.managedInstances = managedInstances;
    }

    public void setStatus(KieServerStatus status) {
        this.status = status;
    }

    @XmlElement(name="server-setup")
    public KieServerSetup getKieServerSetup() {
        return this.kieServerSetup;
    }

    public void setKieServerSetup(KieServerSetup kieServerSetup) {
        this.kieServerSetup = kieServerSetup;
    }

    @XmlElement(name="server-name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="server-version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

