/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.websocket;

import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.client.websocket.WebSocketKieServerControllerClient;
import org.kie.server.controller.websocket.common.KieServerControllerNotificationWebSocketClient;
import org.kie.server.controller.websocket.common.KieServerMessageHandlerWebSocketClient;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.WebSocketServiceResponse;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketKieServerControllerClientTest {
    @Mock
    private KieServerMessageHandlerWebSocketClient client;
    @Mock
    private KieServerControllerNotificationWebSocketClient notificationClient;
    @InjectMocks
    @Spy
    private WebSocketKieServerControllerClient controllerClient;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.controllerClient.getMessageHandler()).thenReturn(Mockito.mock(WebSocketServiceResponse.class));
    }

    @Test
    public void testServiceMethods() throws Exception {
        this.verifyServiceMethods(SpecManagementService.class);
        this.verifyServiceMethods(RuntimeManagementService.class);
        this.verifyServiceMethods(RuleCapabilitiesService.class);
    }

    private void verifyServiceMethods(Class service) throws Exception {
        String name = service.getName();
        Method[] methods = service.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            MethodUtils.invokeMethod((Object)this.controllerClient, (String)m.getName(), (Object[])new Object[m.getParameterCount()]);
            ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
            ((KieServerMessageHandlerWebSocketClient)Mockito.verify((Object)this.client)).sendTextWithInternalHandler((String)contentCaptor.capture(), (InternalMessageHandler)Matchers.any(InternalMessageHandler.class));
            DescriptorCommand command = (DescriptorCommand)WebSocketUtils.unmarshal((String)((String)contentCaptor.getValue()), DescriptorCommand.class);
            Assert.assertNotNull((Object)command);
            Assert.assertEquals((Object)name, (Object)command.getService());
            Assert.assertEquals((Object)m.getName(), (Object)command.getMethod());
            Mockito.reset((Object[])new KieServerMessageHandlerWebSocketClient[]{this.client});
        }
    }

    @Test
    public void testClose() throws Exception {
        this.controllerClient.close();
        ((KieServerMessageHandlerWebSocketClient)Mockito.verify((Object)this.client)).close();
        ((KieServerControllerNotificationWebSocketClient)Mockito.verify((Object)this.notificationClient)).close();
    }
}

