/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.impl.KieServerControllerAdminImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Path(value="/controller/admin")
public class RestKieServerControllerAdminImpl
extends KieServerControllerAdminImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestKieServerControllerAdminImpl.class);

    @PUT
    @Path(value="server/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response addKieServerInstance(@Context HttpHeaders headers, @PathParam(value="id") String id, String serverInfoPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        logger.debug("Received add kie server instance request for server with id {}", (Object)id);
        KieServerInfo serverInfo = ControllerUtils.unmarshal(serverInfoPayload, contentType, KieServerInfo.class);
        logger.debug("Server info {}", (Object)serverInfo);
        try {
            KieServerInstance kieServerInstance = this.addKieServerInstance(serverInfo);
            logger.info("Server with id '{}' added", (Object)id);
            String response = ControllerUtils.marshal(contentType, kieServerInstance);
            logger.debug("Returning response for connect of server '{}': {}", (Object)id, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.CREATED);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Add kie server instance for server id {} failed due to {}", new Object[]{id, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="server/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeKieServerInstance(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        logger.debug("Received remove kie server instance request for server with id {}", (Object)id);
        try {
            this.removeKieServerInstance(id);
            return null;
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove kie server instance for server id {} failed due to {}", new Object[]{id, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="server/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getKieServerInstance(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        String contentType = ControllerUtils.getContentType(headers);
        logger.debug("Received get kie server instance request for server with id {}", (Object)id);
        try {
            KieServerInstance kieServerInstance = this.getKieServerInstance(id);
            String response = ControllerUtils.marshal(contentType, kieServerInstance);
            logger.debug("Returning response for connect of server '{}': {}", (Object)id, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get kie server instance for server id {} failed due to {}", new Object[]{id, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers")
    @Produces(value={"application/xml", "application/json"})
    public Response getKieServerInstances(@Context HttpHeaders headers) {
        String contentType = ControllerUtils.getContentType(headers);
        logger.debug("Received get kie server instances request");
        try {
            List kieServerInstance = this.listKieServerInstances();
            String response = ControllerUtils.marshal(contentType, new KieServerInstanceList(kieServerInstance));
            logger.debug("Returning response for get server instances: {}", (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get kie server instances failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="server/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createContainer(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="containerId") String containerId, String containerPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            KieContainerResource container = ControllerUtils.unmarshal(containerPayload, contentType, KieContainerResource.class);
            KieContainerResource result = this.createContainer(id, containerId, container);
            String response = ControllerUtils.marshal(contentType, result);
            logger.debug("Returning response for create container with id {} server instances: {}", (Object)containerId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.CREATED);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Create container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="server/{id}/containers/{containerId}/status/started")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response startContainer(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            this.startContainer(id, containerId);
            logger.debug("Returning response for start container with id {} server instances: {}", (Object)containerId, (Object)id);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Create container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="server/{id}/containers/{containerId}/status/stopped")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response stopContainer(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            this.stopContainer(id, containerId);
            logger.debug("Returning response for stop container with id {} server instances: {}", (Object)containerId, (Object)id);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Create container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="server/{id}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerInfo(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            KieContainerResource containerResource = this.getContainer(id, containerId);
            String response = ControllerUtils.marshal(contentType, containerResource);
            logger.debug("Returning response for create container with id {} server instances: {}", (Object)containerId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get container info for container id {} within server id {} failed due to {}", new Object[]{containerId, id, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="server/{id}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeContainer(@Context HttpHeaders headers, @PathParam(value="id") String id, @PathParam(value="containerId") String containerId) {
        try {
            this.deleteContainer(id, containerId);
            return null;
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant("Request failed to be processed due to" + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove container with id {} for server id {} failed due to {}", new Object[]{containerId, id, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void notifyKieServersOnCreateContainer(KieServerInstance kieServerInstance, KieContainerResource container) {
        Set managedInstances = kieServerInstance.getManagedInstances();
        if (managedInstances != null) {
            for (KieServerInstanceInfo instanceInfo : managedInstances) {
                if (!KieServerStatus.UP.equals((Object)instanceInfo.getStatus())) continue;
                logger.debug("Server at {} is in online, sending notification to create container...", (Object)instanceInfo.getLocation());
                try {
                    String uri = instanceInfo.getLocation() + "/containers/" + container.getContainerId();
                    this.makeHttpPutRequestAndCreateCustomResponse(uri, this.serialize(container), ServiceResponse.class, ControllerUtils.getUser(), ControllerUtils.getPassword());
                }
                catch (Throwable e) {
                    logger.error("Unable to notify kie server instance at {} about new container {} due to {}", new Object[]{instanceInfo.getLocation(), container, e.getMessage(), e});
                }
            }
        }
    }

    public void notifyKieServersOnDeleteContainer(KieServerInstance kieServerInstance, String containerId) {
        Set managedInstances = kieServerInstance.getManagedInstances();
        if (managedInstances != null) {
            for (KieServerInstanceInfo instanceInfo : managedInstances) {
                if (!KieServerStatus.UP.equals((Object)instanceInfo.getStatus())) continue;
                logger.debug("Server at {} is in online, sending notification to create container...", (Object)instanceInfo.getLocation());
                try {
                    String uri = instanceInfo.getLocation() + "/containers/" + containerId;
                    this.makeHttpDeleteRequestAndCreateCustomResponse(uri, null, ControllerUtils.getUser(), ControllerUtils.getPassword());
                }
                catch (Throwable e) {
                    logger.error("Unable to notify kie server instance at {} about deleted container {} due to {}", new Object[]{instanceInfo.getLocation(), containerId, e.getMessage(), e});
                }
            }
        }
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, String user, String password) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri, user, password).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending PUT request to " + uri + " response code " + response.code());
    }

    protected <T> T makeHttpDeleteRequestAndCreateCustomResponse(String uri, Class<T> resultType, String user, String password) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri, user, password).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending PUT request to " + uri + " response code " + response.code());
    }

    private KieRemoteHttpRequest newRequest(String uri, String userName, String password) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(5000L);
        httpRequest.accept("application/json");
        httpRequest.basicAuthorization(userName, password);
        return httpRequest;
    }

    private <T> T deserialize(String content, Class<T> type) {
        if (type == null) {
            return null;
        }
        try {
            return (T)MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while deserializing data received from server!", e);
        }
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).marshall(object);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while serializing request data!", e);
        }
    }
}

