/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Controller :: KIE Server templates and KIE containers")
@Path(value="/controller/management")
public class RestSpecManagementServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestSpecManagementServiceImpl.class);
    private static final String REQUEST_FAILED_TOBE_PROCESSED = "Request failed to be processed due to: ";
    private SpecManagementServiceImpl specManagementService;

    @ApiOperation(value="Creates a KIE container in a specified KIE Server template", notes="You set the KIE container configurations in the request body", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="KIE container successfully deployed"), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="servers/{serverTemplateId}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response saveContainerSpec(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the new KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the new KIE container", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(name="body", value="A map containing the container-name, relevant release-id (group ID, artifact ID, and version), configuration specifications (rule, process, planning), and other components of the new KIE container", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n  \"container-name\" : \"evaluation\",\n  \"server-template-key\" : null,\n  \"release-id\" : {\"\n    \"group-id\" : \"evaluation\",\n    \"artifact-id\" : \"evaluation\",\n    \"version\" : \"1.0.0-SNAPSHOT\"\n  },\n  \"configuration\" : {\n    \"RULE\" : {\n      \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n        \"pollInterval\" : null,\n        \"scannerStatus\" : \"STOPPED\"\n      }\n    },\n    \"PROCESS\" : {\n      \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n        \"runtimeStrategy\" : \"SINGLETON\",\n        \"kbase\" : \"\",\n        \"ksession\" : \"\",\n        \"mergeMode\" : \"MERGE_COLLECTIONS\"\n      }\n    }\n  },\n  \"status\" : \"STARTED\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-details>\n    <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n    <container-name>evaluation</container-name>\n    <release-id>\n        <artifact-id>evaluation</artifact-id>\n        <group-id>evaluation</group-id>\n        <version>1.0.0-SNAPSHOT</version>\n    </release-id>\n    <configs>\n        <entry>\n            <key>RULE</key>\n            <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <scannerStatus>STOPPED</scannerStatus>\n            </value>\n        </entry>\n        <entry>\n            <key>PROCESS</key>\n            <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <runtimeStrategy>SINGLETON</runtimeStrategy>\n                <kbase></kbase>\n                <ksession></ksession>\n                <mergeMode>MERGE_COLLECTIONS</mergeMode>\n            </value>\n        </entry>\n    </configs>\n    <status>STARTED</status>\n</container-spec-details>")})) String containerSpecPayload, @Context UriInfo uriInfo) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received save container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            this.specManagementService.saveContainerSpec(serverTemplateId, containerSpec);
            logger.debug("Returning response for save container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCreatedVariant("", headers, uriInfo.getAbsolutePathBuilder());
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Updates information about a specified KIE container in a specified KIE Server template", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="KIE container successfully updated"), @ApiResponse(code=404, message="KIE Server template or KIE container not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response updateContainerSpec(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be updated", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(name="body", value="A map containing the updated specifications for the KIE container", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n  \"container-name\" : \"evaluation\",\n  \"server-template-key\" : null,\n  \"release-id\" : {\"\n    \"group-id\" : \"evaluation\",\n    \"artifact-id\" : \"evaluation\",\n    \"version\" : \"1.0.0-SNAPSHOT\"\n  },\n  \"configuration\" : {\n    \"RULE\" : {\n      \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n        \"pollInterval\" : null,\n        \"scannerStatus\" : \"STOPPED\"\n      }\n    },\n    \"PROCESS\" : {\n      \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n        \"runtimeStrategy\" : \"SINGLETON\",\n        \"kbase\" : \"\",\n        \"ksession\" : \"\",\n        \"mergeMode\" : \"MERGE_COLLECTIONS\"\n      }\n    }\n  },\n  \"status\" : \"STARTED\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-details>\n    <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n    <container-name>evaluation</container-name>\n    <release-id>\n        <artifact-id>evaluation</artifact-id>\n        <group-id>evaluation</group-id>\n        <version>1.0.0-SNAPSHOT</version>\n    </release-id>\n    <configs>\n        <entry>\n            <key>RULE</key>\n            <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <scannerStatus>STOPPED</scannerStatus>\n            </value>\n        </entry>\n        <entry>\n            <key>PROCESS</key>\n            <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <runtimeStrategy>SINGLETON</runtimeStrategy>\n                <kbase></kbase>\n                <ksession></ksession>\n                <mergeMode>MERGE_COLLECTIONS</mergeMode>\n            </value>\n        </entry>\n    </configs>\n    <status>STARTED</status>\n</container-spec-details>")})) String containerSpecPayload, @ApiParam(value="Allows to reset the current environment aborting active process instances before updating when the server runs on development mode. Optional, defaults to false") @QueryParam(value="resetBeforeUpdate") @DefaultValue(value="false") boolean resetBeforeUpdate) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received update container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            this.specManagementService.updateContainerSpec(serverTemplateId, containerId, containerSpec, Boolean.valueOf(resetBeforeUpdate));
            logger.debug("Returning response for update container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Creates a new KIE Server template with a specified ID", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="KIE Server template successfully created", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"type\" : \"SUCCESS\",\n  \"msg\" : \"Server template sample-server successfully created\",\n  \"result\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<response type=\"SUCCESS\" msg=\"Server template sample-server successfully created\"/>")})), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="servers/{serverTemplateId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response saveServerTemplate(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the new KIE Server template", required=true, example="sample-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="body", value="A map containing the server-name, capabilities, and other components of the new KIE Server template", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"server-id\" : \"sample-server\",\n  \"server-name\" : \"sample-server\",\n  \"capabilities\" : [\n       \"RULE\",       \"PROCESS\",       \"PLANNING\"    ],\n  \"container-specs\" : [ ],\n  \"server-config\" : { }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<server-template-details>\n  <server-id>sample-server</server-id>\n  <server-name>sample-server</server-name>\n  <configs/>\n  <capabilities>RULE</capabilities>\n  <capabilities>PROCESS</capabilities>\n  <capabilities>PLANNING</capabilities>\n</server-template-details>")})) String serverTemplatePayload, @Context UriInfo uriInfo) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received save server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = ControllerUtils.unmarshal(serverTemplatePayload, contentType, ServerTemplate.class);
            if (serverTemplate == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " not found", headers, Response.Status.NOT_FOUND);
            }
            logger.debug("Server template is {}", (Object)serverTemplate);
            this.specManagementService.saveServerTemplate(serverTemplate);
            logger.debug("Returning response for save server template with id '{}': CREATED", (Object)serverTemplateId);
            UriBuilder builder = uriInfo.getAbsolutePathBuilder();
            return ControllerUtils.createCreatedVariant("", headers, builder);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns information about a specified KIE Server template", response=ServerTemplate.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE Server template", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n       \"server-id\" : \"test-kie-server\",\n       \"server-name\" : \"test-kie-server\",\n       \"container-specs\" : [ {\n           \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n           \"container-name\" : \"evaluation\",\n              \"server-template-key\" : {\n                   \"server-id\" : \"test-kie-server\",\n                   \"server-name\" : \"test-kie-server\"\n               },\n           \"release-id\" : {\n                   \"group-id\" : \"evaluation\",\n                   \"artifact-id\" : \"evaluation\",\n                   \"version\" : \"1.0.0-SNAPSHOT\"\n           },\n           \"configuration\" : {\n                   \"PROCESS\" : {\n                       \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n                               \"runtimeStrategy\" : \"SINGLETON\",\n                               \"kbase\" : \"\",\n                               \"ksession\" : \"\",\n                               \"mergeMode\" : \"MERGE_COLLECTIONS\"\n                       }\n                   },\n                   \"RULE\" : {\n                       \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n                           \"pollInterval\" : null,\n                           \"scannerStatus\" : \"STOPPED\"\n                       }\n                   }\n           },\n           \"status\" : \"STARTED\"\n       } ],\n       \"server-config\" : { },\n       \"server-instances\" : [ {\n               \"server-instance-id\" : \"test-kie-server@localhost:8080\",\n                       \"server-name\" : \"test-kie-server@localhost:8080\",\n                       \"server-template-id\" : \"test-kie-server\",\n                       \"server-url\" : \"http://localhost:8080/kie-server/services/rest/server\"\n               } ],\n       \"capabilities\" : [ \"RULE\", \"PROCESS\", \"PLANNING\" ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<server-template>\n   <server-id>test-kie-server</server-id>\n   <server-name>test-kie-server</server-name>\n   <container-specs>\n       <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n       <container-name>evaluation</container-name>\n       <server-template-key>\n           <server-id>test-kie-server</server-id>\n           <server-name>test-kie-server</server-name>\n       </server-template-key>\n       <release-id>\n           <artifact-id>evaluation</artifact-id>\n           <group-id>evaluation</group-id>\n           <version>1.0.0-SNAPSHOT</version>\n       </release-id>\n       <configs>\n           <entry>\n               <key>PROCESS</key>\n               <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                   <runtimeStrategy>SINGLETON</runtimeStrategy>\n                   <kbase></kbase>\n                   <ksession></ksession>\n                   <mergeMode>MERGE_COLLECTIONS</mergeMode>\n               </value>\n           </entry>\n           <entry>\n               <key>RULE</key>\n               <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                   <scannerStatus>STOPPED</scannerStatus>\n               </value>\n           </entry>\n       </configs>\n       <status>STARTED</status>\n   </container-specs>\n   <configs/>\n   <server-instances>\n       <server-instance-id>test-kie-server@localhost:8080</server-instance-id>\n       <server-name>test-kie-server@localhost:8080</server-name>\n       <server-template-id>test-kie-server</server-template-id>\n       <server-url>http://localhost:8080/kie-server/services/rest/server</server-url>\n   </server-instances>\n   <capabilities>RULE</capabilities>\n   <capabilities>PROCESS</capabilities>\n   <capabilities>PLANNING</capabilities>\n</server-template>")})), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getServerTemplate(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template to be retrieved", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverTemplateId);
            String response = ControllerUtils.marshal(contentType, serverTemplate);
            logger.debug("Returning response for get server template with id '{}': {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns all KIE Server templates", response=ServerTemplateList.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE Server templates", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"server-template\" : [ {\n       \"server-id\" : \"test-kie-server\",\n       \"server-name\" : \"test-kie-server\",\n       \"container-specs\" : [ {\n           \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n           \"container-name\" : \"evaluation\",\n              \"server-template-key\" : {\n                   \"server-id\" : \"test-kie-server\",\n                   \"server-name\" : \"test-kie-server\"\n               },\n           \"release-id\" : {\n                   \"group-id\" : \"evaluation\",\n                   \"artifact-id\" : \"evaluation\",\n                   \"version\" : \"1.0.0-SNAPSHOT\"\n           },\n           \"configuration\" : {\n                   \"PROCESS\" : {\n                       \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n                               \"runtimeStrategy\" : \"SINGLETON\",\n                               \"kbase\" : \"\",\n                               \"ksession\" : \"\",\n                               \"mergeMode\" : \"MERGE_COLLECTIONS\"\n                       }\n                   },\n                   \"RULE\" : {\n                       \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n                           \"pollInterval\" : null,\n                           \"scannerStatus\" : \"STOPPED\"\n                       }\n                   }\n           },\n           \"status\" : \"STARTED\"\n       } ],\n       \"server-config\" : { },\n       \"server-instances\" : [ {\n               \"server-instance-id\" : \"test-kie-server@localhost:8080\",\n                       \"server-name\" : \"test-kie-server@localhost:8080\",\n                       \"server-template-id\" : \"test-kie-server\",\n                       \"server-url\" : \"http://localhost:8080/kie-server/services/rest/server\"\n               } ],\n       \"capabilities\" : [ \"RULE\", \"PROCESS\", \"PLANNING\" ]\n   } ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<server-template-list>\n    <server-template>\n        <server-id>test-kie-server</server-id>\n        <server-name>test-kie-server</server-name>\n        <container-specs>\n            <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n            <container-name>evaluation</container-name>\n            <server-template-key>\n                <server-id>test-kie-server</server-id>\n                <server-name>test-kie-server</server-name>\n            </server-template-key>\n            <release-id>\n                <artifact-id>evaluation</artifact-id>\n                <group-id>evaluation</group-id>\n                <version>1.0.0-SNAPSHOT</version>\n            </release-id>\n            <configs>\n                <entry>\n                    <key>PROCESS</key>\n                    <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                        <runtimeStrategy>SINGLETON</runtimeStrategy>\n                        <kbase></kbase>\n                        <ksession></ksession>\n                        <mergeMode>MERGE_COLLECTIONS</mergeMode>\n                    </value>\n                </entry>\n                <entry>\n                    <key>RULE</key>\n                    <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                        <scannerStatus>STOPPED</scannerStatus>\n                    </value>\n                </entry>\n            </configs>\n            <status>STARTED</status>\n        </container-specs>\n        <configs/>\n        <server-instances>\n            <server-instance-id>test-kie-server@localhost:8080</server-instance-id>\n            <server-name>test-kie-server@localhost:8080</server-name>\n            <server-template-id>test-kie-server</server-template-id>\n            <server-url>http://localhost:8080/kie-server/services/rest/server</server-url>\n        </server-instances>\n        <capabilities>RULE</capabilities>\n        <capabilities>PROCESS</capabilities>\n        <capabilities>PLANNING</capabilities>\n    </server-template>\n</server-template-list>")})), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response listServerTemplates(@Context HttpHeaders headers) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server templates");
            String response = ControllerUtils.marshal(contentType, this.specManagementService.listServerTemplates());
            logger.debug("Returning response for get server templates: {}", (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns all KIE containers for a specified KIE Server template", response=ContainerSpecList.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE containers", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n \"container-spec\" : [ {\n       \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n       \"container-name\" : \"evaluation\",\n       \"server-template-key\" : {\n           \"server-id\" : \"test-kie-server\",\n           \"server-name\" : \"test-kie-server\"\n       },\n       \"release-id\" : {\n           \"group-id\" : \"evaluation\",\n           \"artifact-id\" : \"evaluation\",\n           \"version\" : \"1.0.0-SNAPSHOT\"\n       },\n       \"configuration\" : {\n           \"PROCESS\" : {\n               \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n                   \"runtimeStrategy\" : \"SINGLETON\",\n                   \"kbase\" : \"\",\n                   \"ksession\" : \"\",\n                   \"mergeMode\" : \"MERGE_COLLECTIONS\"\n               }\n           },\n           \"RULE\" : {\n               \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n                   \"pollInterval\" : null,\n                   \"scannerStatus\" : \"STOPPED\"\n               }\n           }\n       },\n       \"status\" : \"STARTED\"\n   } ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-list>\n    <container-spec>\n        <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n        <container-name>evaluation</container-name>\n        <server-template-key>\n            <server-id>test-kie-server</server-id>\n            <server-name>test-kie-server</server-name>\n        </server-template-key>\n        <release-id>\n            <artifact-id>evaluation</artifact-id>\n            <group-id>evaluation</group-id>\n            <version>1.0.0-SNAPSHOT</version>\n        </release-id>\n        <configs>\n            <entry>\n                <key>PROCESS</key>\n                <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                    <runtimeStrategy>SINGLETON</runtimeStrategy>\n                    <kbase></kbase>\n                    <ksession></ksession>\n                    <mergeMode>MERGE_COLLECTIONS</mergeMode>\n                </value>\n            </entry>\n            <entry>\n                <key>RULE</key>\n                <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                    <scannerStatus>STOPPED</scannerStatus>\n                </value>\n            </entry>\n        </configs>\n        <status>STARTED</status>\n    </container-spec>\n</container-spec-list>")})), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}/containers")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response listContainerSpec(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template for which you are retrieving KIE containers", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get containers for server template with id {}", (Object)serverTemplateId);
            String response = ControllerUtils.marshal(contentType, this.specManagementService.listContainerSpec(serverTemplateId));
            logger.debug("Returning response for get containers for server templates with id {}: {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns information about a specified KIE container for a specified KIE Server template", response=ContainerSpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n  \"container-name\" : \"evaluation\",\n  \"server-template-key\" : {\n    \"server-id\" : \"test-kie-server\",\n    \"server-name\" : \"test-kie-server\"\n  },\n  \"release-id\" : {\n    \"group-id\" : \"evaluation\",\n    \"artifact-id\" : \"evaluation\",\n    \"version\" : \"1.0.0-SNAPSHOT\"\n  },\n  \"configuration\" : {\n    \"PROCESS\" : {\n      \"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n        \"runtimeStrategy\" : \"SINGLETON\",\n        \"kbase\" : \"\",\n        \"ksession\" : \"\",\n        \"mergeMode\" : \"MERGE_COLLECTIONS\"\n      }\n    },\n    \"RULE\" : {\n      \"org.kie.server.controller.api.model.spec.RuleConfig\" : {\n        \"pollInterval\" : null,\n        \"scannerStatus\" : \"STOPPED\"\n      }\n    }\n  },\n  \"status\" : \"STARTED\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-details>\n    <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n    <container-name>evaluation</container-name>\n    <server-template-key>\n        <server-id>test-kie-server</server-id>\n        <server-name>test-kie-server</server-name>\n    </server-template-key>\n    <release-id>\n        <artifact-id>evaluation</artifact-id>\n        <group-id>evaluation</group-id>\n        <version>1.0.0-SNAPSHOT</version>\n    </release-id>\n    <configs>\n        <entry>\n            <key>PROCESS</key>\n            <value xsi:type=\"processConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <runtimeStrategy>SINGLETON</runtimeStrategy>\n                <kbase></kbase>\n                <ksession></ksession>\n                <mergeMode>MERGE_COLLECTIONS</mergeMode>\n            </value>\n        </entry>\n        <entry>\n            <key>RULE</key>\n            <value xsi:type=\"ruleConfig\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <scannerStatus>STOPPED</scannerStatus>\n            </value>\n        </entry>\n    </configs>\n    <status>STARTED</status>\n</container-spec-details>")})), @ApiResponse(code=404, message="Container Specification or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getContainerSpec(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be retrieved", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get container {} for server template with id {}", (Object)containerId, (Object)serverTemplateId);
            ContainerSpec containerSpec = this.specManagementService.getContainerInfo(serverTemplateId, containerId);
            containerSpec.setServerTemplateKey(new ServerTemplateKey(containerSpec.getServerTemplateKey().getId(), containerSpec.getServerTemplateKey().getName()));
            String response = ControllerUtils.marshal(contentType, containerSpec);
            logger.debug("Returning response for get container {} for server templates with id {}: {}", new Object[]{containerId, serverTemplateId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Disposes a specified KIE container in a specified KIE Server template.", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="KIE container successfully disposed"), @ApiResponse(code=404, message="Container Specification or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="servers/{serverTemplateId}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteContainerSpec(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be disposed", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerSpecId) {
        try {
            this.specManagementService.deleteContainerSpec(serverTemplateId, containerSpecId);
            return null;
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove container with id {} from server template with id {} failed due to {}", new Object[]{containerSpecId, serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Deletes a specified KIE Server template", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="KIE Server template successfully deleted"), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="servers/{serverTemplateId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteServerTemplate(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template to be deleted", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId) {
        try {
            this.specManagementService.deleteServerTemplate(serverTemplateId);
            return null;
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Updates configurations for a specified KIE container in a specified KIE Server template", code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="KIE container successfully updated"), @ApiResponse(code=404, message="KIE container or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/config/{capability}")
    @Consumes(value={"application/xml", "application/json"})
    public Response updateContainerConfig(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be updated", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerSpecId, @ApiParam(name="capability", value="KIE container capability to be applied (RULE, PROCESS, or PLANNING, case sensitive)", required=true, example="PROCESS") @PathParam(value="capability") String capabilityStr, @ApiParam(name="body", value="An org.kie.server.controller.api.model.spec.<capability>Config map containing the configurations for the specified KIE container capability, such as runtimeStrategy, kbase, ksession, and mergeMode for process configuration", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n\"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n       \"runtimeStrategy\" : \"SINGLETON\",\n       \"kbase\" : null,\n       \"ksession\" : null,\n       \"mergeMode\" : \"MERGE_COLLECTIONS\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<process-config>\n    <runtimeStrategy>SINGLETON</runtimeStrategy>\n    <mergeMode>MERGE_COLLECTIONS</mergeMode>\n</process-config>\n")})) String containerConfigPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            ContainerConfig containerConfig;
            Capability capability;
            if (capabilityStr.equals(Capability.PROCESS.name())) {
                capability = Capability.PROCESS;
                logger.debug("Received update container (with id {}) process config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, ProcessConfig.class);
            } else if (capabilityStr.equals(Capability.RULE.name())) {
                capability = Capability.RULE;
                logger.debug("Received update container (with id {}) rule config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, RuleConfig.class);
            } else {
                logger.debug("Not supported configuration type {}, returning bad request response", (Object)capabilityStr);
                return ControllerUtils.createCorrectVariant("Not supported configuration " + capabilityStr, headers, Response.Status.BAD_REQUEST);
            }
            logger.debug("Container configuration is {}", (Object)containerConfig);
            this.specManagementService.updateContainerConfig(serverTemplateId, containerSpecId, capability, containerConfig);
            logger.debug("Returning response for update container (with id {}) config '{}': CREATED", (Object)containerSpecId, (Object)containerConfig);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Stops a specified KIE container in a specified KIE Server template")
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container successfully stopped"), @ApiResponse(code=404, message="KIE container or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/status/stopped")
    @Consumes(value={"application/xml", "application/json"})
    public Response stopContainer(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be stopped", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.stopContainer(containerSpecKey);
            logger.debug("Returning response for stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Stop container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Starts a specified KIE container in a specified KIE Server template")
    @ApiResponses(value={@ApiResponse(code=200, message="KIE Container successfully started"), @ApiResponse(code=404, message="KIE container or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/status/started")
    @Consumes(value={"application/xml", "application/json"})
    public Response startContainer(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be started", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.startContainer(containerSpecKey);
            logger.debug("Returning response for start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Start container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Activates a specified KIE container in a specified KIE Server template")
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container successfully activated"), @ApiResponse(code=404, message="KIE container or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/status/activated")
    @Consumes(value={"application/xml", "application/json"})
    public Response activateContainer(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be activated", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting activate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.activateContainer(containerSpecKey);
            logger.debug("Returning response for activate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Stop container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Deactivates a specified KIE container in a specified KIE Server template")
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container successfully deactivated"), @ApiResponse(code=404, message="KIE container or KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/status/deactivated")
    @Consumes(value={"application/xml", "application/json"})
    public Response deactivateContainer(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE container", required=true, example="test-kie-server") @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be deactivated", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting deactivate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.deactivateContainer(containerSpecKey);
            logger.debug("Returning response for deactivate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Start container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void setSpecManagementService(SpecManagementServiceImpl specManagementService) {
        this.specManagementService = specManagementService;
    }
}

