/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/controller/runtime")
public class RestRuntimeManagementServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestRuntimeManagementServiceImpl.class);
    private static final String REQUEST_FAILED_TOBE_PROCESSED = "Request failed to be processed due to: ";
    private RuntimeManagementServiceImpl runtimeManagementService;

    @GET
    @Path(value="servers/{id}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getServerInstances(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server template with id {}", (Object)serverTemplateId);
            ServerInstanceKeyList instances = this.runtimeManagementService.getServerInstances(serverTemplateId);
            String response = ControllerUtils.marshal(contentType, instances);
            logger.debug("Returning response for get server instance with server template id '{}': {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server instances using server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers/{id}/instances/{instanceId}/containers")
    @Produces(value={"application/xml", "application/json"})
    public Response getServerInstanceContainers(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="instanceId") String instanceId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get containers for server template with id {} and instance id {}", (Object)serverTemplateId, (Object)instanceId);
            ContainerList containers = this.runtimeManagementService.getServerInstanceContainers(serverTemplateId, instanceId);
            String response = ControllerUtils.marshal(contentType, containers);
            logger.debug("Returning response for get containers for server template with id {} and instance id {}: {}", new Object[]{serverTemplateId, instanceId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get containers using server template id {} and instance id {} failed due to {}", new Object[]{serverTemplateId, instanceId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers/{id}/containers/{containerId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getServerTemplateContainers(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get container {} for server template with id {}", (Object)containerId, (Object)serverTemplateId);
            ContainerList containers = this.runtimeManagementService.getServerTemplateContainers(serverTemplateId, containerId);
            String response = ControllerUtils.marshal(contentType, containers);
            logger.debug("Returning response for get containers for server template with id {} and container id {}: {}", new Object[]{serverTemplateId, containerId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get containers using server template id {} and container id {} failed due to {}", new Object[]{serverTemplateId, containerId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void setRuntimeManagementService(RuntimeManagementServiceImpl runtimeManagementService) {
        this.runtimeManagementService = runtimeManagementService;
    }
}

