/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.service;

import java.util.ServiceLoader;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.NotificationServiceFactory;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.rest.RestSpecManagementServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneSpecManagementServiceImpl
extends RestSpecManagementServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(StandaloneSpecManagementServiceImpl.class);

    public StandaloneSpecManagementServiceImpl() {
        ServiceLoader<PersistingServerTemplateStorageService> templateStorageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (templateStorageServices != null && templateStorageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = templateStorageServices.iterator().next();
            this.setTemplateStorage(storageService.getTemplateStorage());
            logger.debug("Setting template storage for SpecManagementService to {}", (Object)storageService.getTemplateStorage().toString());
        } else {
            logger.warn("No server template storage defined. Default storage: InMemoryKieServerTemplateStorage will be used");
        }
        ServiceLoader<NotificationServiceFactory> notificationServiceLoader = ServiceLoader.load(NotificationServiceFactory.class);
        if (notificationServiceLoader != null && notificationServiceLoader.iterator().hasNext()) {
            NotificationService notificationService = notificationServiceLoader.iterator().next().getNotificationService();
            this.setNotificationService(notificationService);
            logger.debug("Notification service for standalone kie server controller is {}", (Object)notificationService.toString());
        } else {
            logger.warn("Notification service not defined. Default notification: LoggingNotificationService will be used");
        }
    }
}

