/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.common.KeyStoreHelperUtil;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.websocket.client.WebSocketKieServerControllerReconnectHandler;
import org.kie.server.controller.websocket.client.handlers.KieServerSetupMessageHandler;
import org.kie.server.controller.websocket.common.KieServerMessageHandlerWebSocketClient;
import org.kie.server.controller.websocket.common.config.WebSocketClientConfiguration;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieServerRegistryAware;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketKieServerControllerImpl
implements KieServerController,
KieServerRegistryAware {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketKieServerControllerImpl.class);
    private KieServerRegistry context;
    private final KieServerMessageHandlerWebSocketClient client;
    private final Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
    private KieServerInfo serverInfo;
    private DefaultRestControllerImpl restController;

    public WebSocketKieServerControllerImpl() {
        this.client = new KieServerMessageHandlerWebSocketClient(client -> {
            try {
                ((KieServerMessageHandlerWebSocketClient)client).sendTextWithInternalHandler(this.serialize(this.serverInfo), (InternalMessageHandler)new WebSocketKieServerControllerReconnectHandler(this.context));
            }
            catch (IOException e) {
                logger.warn("Error when trying to reconnect to Web Socket server - {}", (Object)e.getMessage());
            }
        });
    }

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set controllers = currentState.getControllers();
        this.serverInfo = serverInfo;
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                if (controllerUrl == null || controllerUrl.isEmpty()) continue;
                if (controllerUrl.toLowerCase().startsWith("ws")) {
                    String connectAndSyncUrl = controllerUrl + "/" + KieServerEnvironment.getServerId();
                    KieServerSetup kieServerSetup = new KieServerSetup();
                    try {
                        this.client.init(WebSocketClientConfiguration.builder().controllerUrl(connectAndSyncUrl).userName(config.getConfigItemValue("org.kie.server.controller.user", "kieserver")).password(KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config)).token(config.getConfigItemValue("org.kie.server.controller.token")).build());
                        CountDownLatch waitLatch = new CountDownLatch(1);
                        this.client.sendTextWithInternalHandler(this.serialize(serverInfo), (InternalMessageHandler)new KieServerSetupMessageHandler(this.context, waitLatch, kieServerSetup));
                        boolean received = waitLatch.await(10L, TimeUnit.SECONDS);
                        if (received && kieServerSetup.getContainers() != null) {
                            return kieServerSetup;
                        }
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                        logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
                        continue;
                    }
                }
                logger.info("Kie Server points to non Web Socket controller '{}', using default REST mechanism", (Object)controllerUrl);
                KieServerSetup kieServerSetup = this.restController.connectToSingleController(serverInfo, config, controllerUrl);
                if (kieServerSetup == null) continue;
                return kieServerSetup;
            }
            throw new KieControllerNotConnectedException("Unable to connect to any controller");
        }
        throw new KieControllerNotDefinedException("Unable to connect to any controller");
    }

    public void disconnect(KieServerInfo serverInfo) {
        if (this.client.isActive()) {
            this.client.close();
        } else {
            KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
            Set controllers = currentState.getControllers();
            KieServerConfig config = currentState.getConfiguration();
            if (controllers != null && !controllers.isEmpty()) {
                for (String controllerUrl : controllers) {
                    if (controllerUrl == null || controllerUrl.isEmpty() || controllerUrl.toLowerCase().startsWith("ws")) continue;
                    logger.info("Kie Server points to non Web Socket controller '{}', using default REST mechanism", (Object)controllerUrl);
                    boolean disconnected = this.restController.disconnectFromSingleController(serverInfo, config, controllerUrl);
                    if (!disconnected) continue;
                    break;
                }
            }
        }
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while serializing request data!", e);
        }
    }

    public void setRegistry(KieServerRegistry registry) {
        this.context = registry;
        this.restController = new DefaultRestControllerImpl(this.context);
    }

    public KieServerRegistry getRegistry() {
        return this.context;
    }
}

