/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMessageHandler
implements MessageHandler.Whole<String> {
    private static final Logger logger = LoggerFactory.getLogger(KieServerMessageHandler.class);
    private ArrayDeque<InternalMessageHandler> internalHandlers = new ArrayDeque();
    private Session session;

    public KieServerMessageHandler(Session session) {
        this.session = session;
        this.session.addMessageHandler((MessageHandler)this);
    }

    public void onMessage(String message) {
        logger.debug("Message received with content '{}'", (Object)message);
        InternalMessageHandler handler = this.internalHandlers.poll();
        logger.debug("About to handle message with handler {}", (Object)handler);
        String response = handler.onMessage(message);
        logger.debug("Response to be send (if not null) is '{}'", (Object)response);
        this.addHandler(handler.getNextHandler());
        if (response != null) {
            try {
                this.session.getBasicRemote().sendText(response);
                logger.debug("Response successfully sent");
                handler.afterResponseSent();
            }
            catch (IOException e) {
                logger.error("Error when sending response", (Throwable)e);
            }
        }
    }

    public void addHandler(InternalMessageHandler handler) {
        if (handler != null) {
            this.internalHandlers.add(handler);
        }
    }
}

