/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.websocket.common.decoder.KieServerControllerNotificationDecoder;
import org.kie.server.controller.websocket.common.encoder.KieServerControllerNotificationEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class KieServerControllerNotificationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerControllerNotificationTest.class);
    @Parameterized.Parameter
    public KieServerControllerEvent event;
    private KieServerControllerNotificationDecoder decoder = new KieServerControllerNotificationDecoder();
    private KieServerControllerNotificationEncoder encoder = new KieServerControllerNotificationEncoder();

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({new ServerInstanceConnected(new ServerInstance())}, {new ServerInstanceDisconnected("serverId")}, {new ServerInstanceDeleted("serverId")}, {new ServerInstanceUpdated(new ServerInstance())}, {new ServerTemplateUpdated(new ServerTemplate())}, {new ServerTemplateDeleted("serverTemplateId")}, {new ContainerSpecUpdated(new ServerTemplate(), new ContainerSpec(), new ArrayList())}));
        return parameterData;
    }

    @Test
    public void testEventsEncodeDecode() throws Exception {
        KieServerControllerNotification notification = new KieServerControllerNotification(this.event);
        String json = this.encoder.encode(notification);
        LOGGER.info("JSON content\n{}", (Object)json);
        Assert.assertEquals((Object)notification, (Object)this.decoder.decode(json));
    }
}

