/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.commands.KieServerControllerDescriptorCommand;
import org.kie.server.controller.api.model.KieServerControllerServiceResponse;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUtilsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketUtilsTest.class);

    @Test
    public void testContainerSpecSerialization() {
        ContainerSpec spec = new ContainerSpec();
        spec.setId("id");
        spec.setContainerName("name");
        spec.setStatus(KieContainerStatus.STARTED);
        spec.setReleasedId(new ReleaseId("groupId", "artifactId", "1.0"));
        ProcessConfig processConfig = new ProcessConfig("runtimeStrategy", "kBase", "kSession", "mergeMode");
        spec.addConfig(Capability.PROCESS, (ContainerConfig)processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(1L), KieScannerStatus.SCANNING);
        spec.addConfig(Capability.RULE, (ContainerConfig)ruleConfig);
        String specContent = WebSocketUtils.marshal((Object)spec);
        LOGGER.info("JSON content\n{}", (Object)specContent);
        ContainerSpec specResult = (ContainerSpec)WebSocketUtils.unmarshal((String)specContent, ContainerSpec.class);
        Assert.assertNotNull((Object)specResult);
        Assert.assertEquals((Object)spec, (Object)specResult);
        Assert.assertEquals((Object)spec.getId(), (Object)specResult.getId());
        Assert.assertEquals((Object)spec.getStatus(), (Object)specResult.getStatus());
        Assert.assertEquals((Object)spec.getContainerName(), (Object)specResult.getContainerName());
        Assert.assertEquals((Object)spec.getReleasedId(), (Object)specResult.getReleasedId());
        Assert.assertNotNull((Object)specResult.getConfigs());
        Assert.assertEquals((long)spec.getConfigs().size(), (long)specResult.getConfigs().size());
        ContainerConfig processConfigResult = (ContainerConfig)specResult.getConfigs().get(Capability.PROCESS);
        Assert.assertNotNull((Object)processConfigResult);
        Assert.assertTrue((boolean)(processConfigResult instanceof ProcessConfig));
        Assert.assertEquals((Object)processConfig, (Object)processConfigResult);
        ContainerConfig ruleConfigResult = (ContainerConfig)specResult.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigResult);
        Assert.assertTrue((boolean)(ruleConfigResult instanceof RuleConfig));
        Assert.assertEquals((Object)ruleConfig, (Object)ruleConfigResult);
    }

    @Test
    public void testKieServerCommandSerialization() {
        String serverTemplateId = "serverTemplateId";
        String containerSpecId = "containerSpecId";
        Capability capability = Capability.PROCESS;
        ProcessConfig processConfig = new ProcessConfig("runtimeStrategy", "kBase", "kSession", "mergeMode");
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(1L), KieScannerStatus.SCANNING);
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "updateContainerConfig", null, null, new Object[]{"serverTemplateId", "containerSpecId", capability, processConfig, ruleConfig});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.info("JSON content\n{}", (Object)content);
        KieServerControllerDescriptorCommand commandResult = (KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class);
        Assert.assertNotNull((Object)commandResult);
        Assert.assertEquals((Object)command.getService(), (Object)commandResult.getService());
        Assert.assertEquals((Object)command.getMethod(), (Object)commandResult.getMethod());
        Assert.assertEquals((long)command.getArguments().size(), (long)commandResult.getArguments().size());
        Assert.assertTrue((boolean)commandResult.getArguments().contains("serverTemplateId"));
        Assert.assertTrue((boolean)commandResult.getArguments().contains("containerSpecId"));
        Assert.assertTrue((boolean)commandResult.getArguments().contains(capability));
        Assert.assertTrue((boolean)commandResult.getArguments().contains(processConfig));
        Assert.assertTrue((boolean)commandResult.getArguments().contains(ruleConfig));
    }

    @Test
    public void testContainerListSerialization() {
        ServerInstanceKey serverInstanceKey = new ServerInstanceKey("serverTemplateId", "serverName", "serverInstanceId", "url");
        ReleaseId releaseId = new ReleaseId("group", "artifact", "version");
        Container container = new Container("containerSpecId", "containerName", serverInstanceKey, Collections.emptyList(), releaseId, "url");
        ContainerList containerList = new ContainerList(Collections.singletonList(container));
        KieServerControllerServiceResponse response = new KieServerControllerServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "", (Object)containerList);
        String content = WebSocketUtils.marshal((Object)response);
        LOGGER.info("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse responseResult = (KieServerControllerServiceResponse)WebSocketUtils.unmarshal((String)content, KieServerControllerServiceResponse.class);
        Assert.assertNotNull((Object)responseResult);
        Assert.assertEquals((Object)response.getMsg(), (Object)responseResult.getMsg());
        Assert.assertArrayEquals((Object[])((ContainerList)response.getResult()).getContainers(), (Object[])((ContainerList)responseResult.getResult()).getContainers());
    }
}

