/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;

public interface InternalMessageHandler {
    public static final Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)InternalMessageHandler.class.getClassLoader());

    default public <T> T deserialize(String content, Class<T> type) {
        if (type == null) {
            return null;
        }
        try {
            return (T)marshaller.unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while deserializing data received from server!", e);
        }
    }

    default public String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while serializing request data!", e);
        }
    }

    public String onMessage(String var1);

    default public void afterResponseSent() {
    }

    default public InternalMessageHandler getNextHandler() {
        return null;
    }
}

