/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.management;

import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.commands.KieServerControllerDescriptorCommand;
import org.kie.server.controller.api.model.KieServerControllerServiceResponse;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.management.KieServerMgmtCommandService;
import org.kie.server.controller.websocket.management.KieServerMgmtCommandServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMgmtCommandServiceImplTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerMgmtCommandServiceImplTest.class);
    private static final String SERVER_TEMPLATE_ID = "templateId";
    private static final String SERVER_TEMPLATE_NAME = "templateName";
    private static final String CONTAINER_SPEC_ID = "specId";
    private static final String CONTAINER_SPEC_NAME = "specName";
    private KieServerMgmtCommandService service = KieServerMgmtCommandServiceImpl.getInstance();

    @Test
    public void testNullCommandScript() {
        KieServerControllerServiceResponse response = this.service.executeCommand(null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
    }

    @Test
    public void testInvalidService() {
        KieServerControllerServiceResponse response = this.service.executeCommand(new KieServerControllerDescriptorCommand("service", "method", new Object[0]));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
    }

    @Test
    public void testServiceWithWrongNumberOfParameter() {
        KieServerControllerServiceResponse response = this.service.executeCommand(new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "listServerTemplates", new Object[]{1}));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
    }

    @Test
    public void testValidServiceWithoutParameters() {
        KieServerControllerServiceResponse response = this.service.executeCommand(new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "listServerTemplates", new Object[0]));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }

    @Test
    public void testCommandSerialization() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setId(SERVER_TEMPLATE_ID);
        serverTemplate.setName(SERVER_TEMPLATE_NAME);
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "saveServerTemplate", new Object[]{serverTemplate});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse response = this.service.executeCommand((KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)response.getMsg(), (Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        Assert.assertNull((Object)response.getResult());
        command = new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "getServerTemplate", new Object[]{SERVER_TEMPLATE_ID});
        response = this.service.executeCommand(command);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        Assert.assertNotNull((Object)response.getResult());
        Assert.assertEquals((Object)serverTemplate, (Object)response.getResult());
        String responseContent = WebSocketUtils.marshal((Object)response);
        response = (KieServerControllerServiceResponse)WebSocketUtils.unmarshal((String)responseContent, KieServerControllerServiceResponse.class);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        Assert.assertNotNull((Object)response.getResult());
        Assert.assertEquals((Object)serverTemplate, (Object)response.getResult());
    }

    @Test
    public void testCommandWithDomainArguments() {
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId(CONTAINER_SPEC_ID);
        containerSpec.setContainerName(CONTAINER_SPEC_NAME);
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "saveContainerSpec", null, null, new Object[]{SERVER_TEMPLATE_ID, containerSpec});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse response = this.service.executeCommand((KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)response.getMsg(), (Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        Assert.assertNull((Object)response.getResult());
    }

    @Test
    public void testCommandUpgradeContainer() {
        ContainerSpecKey serverTemplate = new ContainerSpecKey("id", "name", new ServerTemplateKey("stid", "stname"));
        ReleaseId releaseId = new ReleaseId("group", "artifact", "version");
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(RuleCapabilitiesService.class.getName(), "upgradeContainer", new Object[]{serverTemplate, releaseId});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse response = this.service.executeCommand((KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
        Assert.assertEquals((Object)"No server template found for id stid", (Object)response.getMsg());
        Assert.assertNull((Object)response.getResult());
    }

    @Test
    public void testUpdateContainerConfig() {
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(SpecManagementService.class.getName(), "updateContainerConfig", null, null, new Object[]{"serverTemplateId", "containerSpecId", Capability.PROCESS, new ProcessConfig()});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse response = this.service.executeCommand((KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
        Assert.assertEquals((Object)"No server template found for id serverTemplateId", (Object)response.getMsg());
        Assert.assertNull((Object)response.getResult());
    }

    @Test
    public void testStartScanner() {
        ContainerSpecKey containerSpecKey = new ContainerSpecKey("id", "name", new ServerTemplateKey("serverTemplateId", "stname"));
        KieServerControllerDescriptorCommand command = new KieServerControllerDescriptorCommand(RuleCapabilitiesService.class.getName(), "startScanner", null, null, new Object[]{containerSpecKey, new Long(1L)});
        String content = WebSocketUtils.marshal((Object)command);
        LOGGER.debug("JSON content\n{}", (Object)content);
        KieServerControllerServiceResponse response = this.service.executeCommand((KieServerControllerDescriptorCommand)WebSocketUtils.unmarshal((String)content, KieServerControllerDescriptorCommand.class));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)response.getType());
        Assert.assertEquals((Object)"No server template found for id serverTemplateId", (Object)response.getMsg());
        Assert.assertNull((Object)response.getResult());
    }
}

