/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.util.ArrayList;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.websocket.notification.WebSocketNotificationService;
import org.kie.server.controller.websocket.notification.WebSocketNotificationSessionManager;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketNotificationServiceTest {
    private static long TIMEOUT = 5000L;
    @Mock
    Session session;
    @Mock
    RemoteEndpoint.Basic endpoint;
    @InjectMocks
    WebSocketNotificationService notificationService;

    @Before
    public void setUp() {
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"id");
        Mockito.when((Object)this.session.getBasicRemote()).thenReturn((Object)this.endpoint);
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        WebSocketNotificationSessionManager.getInstance().addSession(this.session);
    }

    @Test
    public void testServerInstanceConnected() throws Exception {
        ServerInstanceConnected event = new ServerInstanceConnected(new ServerInstance());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testServerInstanceDisconnected() throws Exception {
        ServerInstanceDisconnected event = new ServerInstanceDisconnected("serverId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testServerInstanceDeleted() throws Exception {
        ServerInstanceDeleted event = new ServerInstanceDeleted("serverId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testServerInstanceUpdated() throws Exception {
        ServerInstanceUpdated event = new ServerInstanceUpdated(new ServerInstance());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testServerTemplateUpdated() throws Exception {
        ServerTemplateUpdated event = new ServerTemplateUpdated(new ServerTemplate());
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testServerTemplateDeleted() throws Exception {
        ServerTemplateDeleted event = new ServerTemplateDeleted("serverTemplateId");
        this.notificationService.notify(event);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }

    @Test
    public void testContainerSpecUpdated() throws Exception {
        ServerTemplate serverTemplate = new ServerTemplate();
        ContainerSpec containerSpec = new ContainerSpec();
        ArrayList containers = new ArrayList();
        ContainerSpecUpdated event = new ContainerSpecUpdated(serverTemplate, containerSpec, containers);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)new KieServerControllerNotification((KieServerControllerEvent)event));
    }
}

