/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.kie.server.controller.websocket.notification.WebSocketNotificationSessionManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketNotificationSessionManagerTest {
    private static long TIMEOUT = 5000L;
    @Mock
    Session session;
    WebSocketNotificationSessionManager manager = WebSocketNotificationSessionManager.getInstance();

    @Test
    public void testSessionCleanUp() {
        this.manager.addSession(this.session);
        Assert.assertTrue((boolean)this.manager.getExecutorsBySession().containsKey(this.session));
        this.manager.removeSession(this.session);
        Assert.assertFalse((boolean)this.manager.getExecutorsBySession().containsKey(this.session));
    }

    @Test
    public void testBroadcast() throws Exception {
        RemoteEndpoint.Basic endpoint = (RemoteEndpoint.Basic)Mockito.mock(RemoteEndpoint.Basic.class);
        Mockito.when((Object)this.session.getBasicRemote()).thenReturn((Object)endpoint);
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        this.manager.addSession(this.session);
        KieServerControllerNotification notification = new KieServerControllerNotification();
        this.manager.broadcastObject((Object)notification);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)notification);
    }

    @Test
    public void testRemoveSessionWithMessageInProgress() throws Exception {
        RemoteEndpoint.Basic endpoint = (RemoteEndpoint.Basic)Mockito.mock(RemoteEndpoint.Basic.class);
        ((RemoteEndpoint.Basic)Mockito.doThrow((Throwable)new IOException()).when((Object)endpoint)).sendObject(Mockito.any());
        Mockito.when((Object)this.session.getBasicRemote()).thenReturn((Object)endpoint);
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        this.manager.addSession(this.session);
        KieServerControllerNotification notification = new KieServerControllerNotification();
        this.manager.broadcastObject((Object)notification);
        ExecutorService executor = (ExecutorService)this.manager.getExecutorsBySession().get(this.session);
        this.manager.removeSession(this.session);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)executor.isShutdown());
        Assert.assertTrue((boolean)executor.isTerminated());
    }

    @Test
    public void testBroadcastWithEncodeException() throws Exception {
        RemoteEndpoint.Basic endpoint = (RemoteEndpoint.Basic)Mockito.mock(RemoteEndpoint.Basic.class);
        ((RemoteEndpoint.Basic)Mockito.doThrow((Throwable)new EncodeException(null, "encode error")).when((Object)endpoint)).sendObject(Mockito.any());
        Mockito.when((Object)this.session.getBasicRemote()).thenReturn((Object)endpoint);
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        this.manager.addSession(this.session);
        KieServerControllerNotification notification = new KieServerControllerNotification();
        this.manager.broadcastObject((Object)notification);
        ((RemoteEndpoint.Basic)Mockito.verify((Object)endpoint, (VerificationMode)Mockito.timeout((long)TIMEOUT))).sendObject((Object)notification);
    }
}

