/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket;

import java.util.Collections;
import java.util.ServiceLoader;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.websocket.WebsocketSessionManager;
import org.kie.server.controller.websocket.WebsocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket/controller/{server-id}")
public class WebsocketKieServerControllerImpl
extends KieServerControllerImpl {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketKieServerControllerImpl.class);
    private WebsocketSessionManager manager = WebsocketSessionManager.getInstance();
    @Inject
    private Instance<KieServerTemplateStorage> templateStorage;
    @Inject
    private Instance<NotificationService> notificationService;

    public WebsocketKieServerControllerImpl() {
        ServiceLoader<PersistingServerTemplateStorageService> storageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (storageServices != null && storageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = storageServices.iterator().next();
            this.setTemplateStorage(storageService.getTemplateStorage());
            logger.debug("Server template storage for standalone kie server controller is {}", (Object)storageService.getTemplateStorage().toString());
        } else {
            logger.debug("No server template storage defined. Default storage: InMemoryKieServerTemplateStorage will be used");
        }
    }

    @PostConstruct
    public void configure() {
        try {
            this.setTemplateStorage((KieServerTemplateStorage)this.templateStorage.get());
        }
        catch (RuntimeException e) {
            logger.warn("Unable to find template storage implementation, using in memory");
        }
        try {
            this.setNotificationService((NotificationService)this.notificationService.get());
        }
        catch (RuntimeException e) {
            logger.warn("Unable to find notification service implementation, using logging only");
        }
    }

    @OnOpen
    public void onKieServerConnect(@PathParam(value="server-id") String serverId, Session session) {
        this.manager.addSession(session);
        this.manager.getHandler(session.getId()).addHandler(message -> {
            String contentType = MarshallingFormat.JSON.getType();
            KieServerInfo serverInfo = WebsocketUtils.unmarshal(message, contentType, KieServerInfo.class);
            this.manager.addSession(serverInfo.getLocation(), session);
            logger.debug("Server info {}", (Object)serverInfo);
            KieServerSetup serverSetup = this.connect(serverInfo);
            logger.info("Server with id '{}' connected", (Object)serverId);
            String response = WebsocketUtils.marshal(contentType, serverSetup);
            return response;
        });
    }

    @OnClose
    public void onKieServerDisconnect(@PathParam(value="server-id") String serverId, Session session, CloseReason closeReason) {
        String url = this.manager.removeSession(session);
        if (url != null) {
            KieServerInfo serverInfo = new KieServerInfo(serverId, "", "", Collections.emptyList(), url);
            this.disconnect(serverInfo);
            logger.info("Server with id '{}' disconnected", (Object)serverId);
        }
    }

    @OnError
    public void onKieServerError(Session session, Throwable e) {
        logger.error("Unexpected error", e);
    }
}

